/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.Collections;
import java.util.List;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.uml2.uml.NamedElements;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceSpecifications {
    private static final Logger a = LoggerFactory.getLogger(InstanceSpecifications.class);

    public static Classifier getBase(InstanceSpecification instanceSpecification) {
        if (!instanceSpecification.getClassifiers().isEmpty()) {
            return (Classifier)instanceSpecification.getClassifiers().get(0);
        }
        return null;
    }

    public static Slot createSlot(InstanceSpecification instanceSpecification, Property property) {
        Slot slot = instanceSpecification.createSlot();
        slot.setDefiningFeature((StructuralFeature)property);
        return slot;
    }

    public static EList<Slot> getSlots(InstanceSpecification instanceSpecification) {
        BasicEList basicEList = new BasicEList();
        for (Slot slot : instanceSpecification.getSlots()) {
            StructuralFeature structuralFeature = slot.getDefiningFeature();
            if (structuralFeature instanceof Property && ((Property)structuralFeature).getAssociation() != null || structuralFeature instanceof Port) continue;
            basicEList.add((Object)slot);
        }
        return basicEList;
    }

    public static Classifier getRoleClassifier(Slot slot) {
        EList eList = slot.getValues();
        if (eList.size() != 1) {
            throw new IllegalStateException("Slot has multiple values. '" + slot + "'");
        }
        ValueSpecification valueSpecification = (ValueSpecification)eList.get(0);
        if (!(valueSpecification instanceof InstanceValue)) {
            throw new IllegalStateException("The value of the slot is wrong. '" + slot + "'");
        }
        InstanceValue instanceValue = (InstanceValue)valueSpecification;
        InstanceSpecification instanceSpecification = instanceValue.getInstance();
        if (instanceSpecification == null) {
            return null;
        }
        EList eList2 = instanceSpecification.getClassifiers();
        if (eList2.isEmpty()) {
            return null;
        }
        if (eList2.size() != 1) {
            throw new IllegalStateException("InstanceSpecification has multiple classifires. '" + instanceSpecification + "'");
        }
        return (Classifier)eList2.get(0);
    }

    public static Association getAssociation(InstanceSpecification instanceSpecification) {
        EList eList = instanceSpecification.getClassifiers();
        if (!eList.isEmpty() && eList.get(0) instanceof Association) {
            return (Association)eList.get(0);
        }
        return null;
    }

    public static void createSlotForLink(InstanceSpecification instanceSpecification, InstanceSpecification instanceSpecification2) {
        Slot slot = instanceSpecification.createSlot();
        InstanceValue instanceValue = (InstanceValue)slot.createValue(null, null, UMLPackage.eINSTANCE.getInstanceValue());
        instanceValue.setInstance(instanceSpecification2);
    }

    public static boolean isLink(InstanceSpecification instanceSpecification) {
        if (instanceSpecification.eIsSet((EStructuralFeature)UMLPackage.Literals.INSTANCE_SPECIFICATION__SLOT)) {
            Slot slot = (Slot)instanceSpecification.getSlots().get(0);
            return InstanceSpecifications.hasInstanceValue(slot);
        }
        return false;
    }

    public static boolean hasInstanceValue(Slot slot) {
        if (slot.eIsSet((EStructuralFeature)UMLPackage.Literals.SLOT__VALUE)) {
            ValueSpecification valueSpecification = (ValueSpecification)slot.getValues().get(0);
            return valueSpecification instanceof InstanceValue;
        }
        return false;
    }

    public static boolean isLinkWithAssociation(InstanceSpecification instanceSpecification) {
        if (!InstanceSpecifications.isLink(instanceSpecification)) {
            return false;
        }
        Association association = InstanceSpecifications.getAssociation(instanceSpecification);
        return association != null;
    }

    public static boolean isLinkEnd(Slot slot) {
        Element element = slot.getOwner();
        if (element instanceof InstanceSpecification) {
            return InstanceSpecifications.isLink((InstanceSpecification)element);
        }
        return false;
    }

    public static boolean isObjectModified(String string, InstanceSpecification instanceSpecification) {
        Classifier classifier;
        String string2 = "";
        EList eList = instanceSpecification.getClassifiers();
        if (eList != null && !eList.isEmpty() && (classifier = (Classifier)eList.get(0)) != null) {
            string2 = classifier.getName();
        }
        return NamedElements.isModified(string, (NamedElement)instanceSpecification, string2);
    }

    public static void setClassifier(InstanceSpecification instanceSpecification, Classifier classifier) {
        InstanceSpecifications.a(instanceSpecification, classifier);
    }

    public static void unsetClassifier(InstanceSpecification instanceSpecification) {
        InstanceSpecifications.a(instanceSpecification, null);
    }

    private static void a(InstanceSpecification instanceSpecification, Classifier classifier) {
        List<Classifier> list = classifier == null ? SetCommand.UNSET_VALUE : Collections.singletonList(classifier);
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)instanceSpecification);
        try {
            Command command = SetCommand.create((EditingDomain)editingDomain, (Object)instanceSpecification, (Object)UMLPackage.Literals.INSTANCE_SPECIFICATION__CLASSIFIER, list);
            CommandUtils.execute((EditingDomain)editingDomain, (Command)command);
        }
        catch (InterruptedException | RollbackException throwable) {
            a.error("error has occurred.", throwable);
        }
    }
}

