/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Elements {
    private static final Logger a = LoggerFactory.getLogger(Elements.class);

    public static EList<Element> getAllOwnedElements(Element element, EList<Element> eList) {
        EList eList2 = element.getOwnedElements();
        eList.addAll((Collection)eList2);
        for (Element element2 : eList2) {
            Elements.getAllOwnedElements(element2, eList);
        }
        return eList;
    }

    public static List<Comment> getAnnotatedComments(Element element) {
        ArrayList<Comment> arrayList = new ArrayList<Comment>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)element)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof Comment) || !((Comment)eObject).getAnnotatedElements().contains((Object)element)) continue;
            arrayList.add((Comment)eObject);
        }
        return arrayList;
    }

    public static boolean isUnqualifiedStereotypeApplied(EObject eObject, String string) {
        return eObject instanceof Element && Elements.isUnqualifiedStereotypeApplied((Element)eObject, string);
    }

    public static boolean isUnqualifiedStereotypeApplied(Element element, String string) {
        return string != null && element.getAppliedStereotypes().stream().anyMatch(stereotype -> string.equalsIgnoreCase(stereotype.getName()));
    }

    public static <T> T getOwningElement(Element element, Class<T> clazz) {
        Element element2 = element.getOwner();
        if (element2 == null) {
            return null;
        }
        if (clazz.isInstance(element2)) {
            return clazz.cast(element2);
        }
        return Elements.getOwningElement(element2, clazz);
    }

    public static String getTypeModifierString(String string) {
        int n = -1;
        if (string.endsWith("**")) {
            n = string.lastIndexOf("**");
        } else if (string.endsWith("*")) {
            n = string.lastIndexOf("*");
        } else if (string.endsWith("&")) {
            n = string.lastIndexOf("&");
        }
        if (n >= 0) {
            return string.substring(n);
        }
        return "";
    }

    public static void removeModel(Collection<? extends Element> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)collection.iterator().next()));
        if (editingDomain == null) {
            for (Element element : collection) {
                element.destroy();
            }
            return;
        }
        try {
            CommandUtils.execute((EditingDomain)editingDomain, (Command)DestroyCommand.create((EditingDomain)editingDomain, collection));
        }
        catch (InterruptedException | RollbackException throwable) {
            a.error("error has occurred.", throwable);
        }
    }

    public static void removeModel(Element element) {
        if (element == null) {
            return;
        }
        Elements.removeModel(Collections.singletonList(element));
    }

    public static Model getTopModel(Element element) {
        if (element == null) {
            return null;
        }
        for (Model model = element.getModel(); model != null; model = model.getModel()) {
            if (model.getModel() != null) continue;
            return model;
        }
        return null;
    }

    public static Namespace findNearestNamespace(Element element) {
        Element element2 = element.getOwner();
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof Namespace) {
            return (Namespace)element2;
        }
        return Elements.findNearestNamespace(element2);
    }

    public static void compareStereotypeAndsetTagValue(Element element) {
    }
}

