/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import lombok.NonNull;
import net.astah.emf.edit.provider.LabelProviders;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class EcoreUMLIDGenerator
extends UMLSwitch<String>
implements Function<EObject, String> {
    private final URI a = URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml");
    protected final boolean useUUID;
    protected final Collection<String> ignoreURIs;

    public EcoreUMLIDGenerator(boolean bl, String ... stringArray) {
        this(bl, Arrays.asList(stringArray));
        if (stringArray == null) {
            throw new NullPointerException("ignoreURIs");
        }
    }

    public EcoreUMLIDGenerator(boolean bl, @NonNull Collection<String> collection) {
        if (collection == null) {
            throw new NullPointerException("ignoreURIs");
        }
        this.useUUID = bl;
        this.ignoreURIs = collection;
    }

    @Override
    public String apply(EObject eObject) {
        return (String)this.doSwitch(eObject);
    }

    public String casePackage(Package package_) {
        if (this.a(package_)) {
            return "_0";
        }
        return null;
    }

    public String caseClassifier(Classifier classifier) {
        if (this.a(classifier)) {
            return classifier.getName();
        }
        return null;
    }

    public String caseProperty(Property property) {
        String string;
        if (this.a(property) && !UML2Util.isEmpty((String)(string = property.getName()))) {
            return NLS.bind((String)"{0}-{1}", (Object)property.getNamespace().getName(), (Object)string);
        }
        return null;
    }

    public String caseAssociation(Association association) {
        Package package_;
        if (UML2Util.isEmpty((String)association.getName()) && (package_ = association.getNearestPackage()) != null && this.a(package_)) {
            String string = LabelProviders.getText((Object)association);
            association.setName(string.replaceAll("<[^>]*>\\s*", ""));
        }
        return (String)super.caseAssociation(association);
    }

    public String defaultCase(EObject eObject) {
        return this.useUUID ? EcoreUtil.generateUUID() : null;
    }

    boolean a(Package package_) {
        String string = package_.getURI();
        if (string != null) {
            if (this.ignoreURIs.stream().anyMatch(string::startsWith)) {
                return false;
            }
        }
        return package_.getAppliedStereotypes().stream().anyMatch(stereotype -> this.a((Stereotype)stereotype, EcorePackage.Literals.EPACKAGE.getName()));
    }

    boolean a(Classifier classifier) {
        if (UML2Util.isEmpty((String)classifier.getName())) {
            return false;
        }
        Package package_ = classifier.getNearestPackage();
        if (package_ == null || !this.a(package_)) {
            return false;
        }
        return classifier.getAppliedStereotypes().stream().noneMatch(stereotype -> this.a((Stereotype)stereotype, EcorePackage.Literals.EGENERIC_TYPE.getName()));
    }

    boolean a(Stereotype stereotype, String string) {
        if (!string.equals(stereotype.getName())) {
            return false;
        }
        Profile profile = stereotype.getProfile();
        if (profile == null) {
            return false;
        }
        URI uRI = EcoreUtil.getURI((EObject)profile);
        return uRI != null && this.a.equals(uRI.trimFragment());
    }

    boolean a(Property property) {
        Namespace namespace = property.getNamespace();
        return namespace instanceof Classifier && this.a((Classifier)namespace);
    }
}

