/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.astah.uml2.uml.Elements;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class Constraints {
    public static List<Constraint> findOwnedConstraints(Element element) {
        Namespace namespace;
        if (element instanceof Namespace) {
            return Constraints.a(element, (List<Constraint>)((Namespace)element).getOwnedRules());
        }
        if (element instanceof Property) {
            Property property = (Property)element;
            if (property.getAssociation() != null) {
                return Constraints.a(element, (List<Constraint>)property.getAssociation().getOwnedRules());
            }
            if (property.getOwner() instanceof Property) {
                return Constraints.a(element, (List<Constraint>)((Property)property.getOwner()).getAssociation().getOwnedRules());
            }
            if (property.getOwner() == null) {
                return Collections.emptyList();
            }
            return Constraints.a(element, (List<Constraint>)((Namespace)property.getOwner()).getOwnedRules());
        }
        if (element instanceof Realization) {
            Element element2 = element.getOwner();
            if (element2 != null && element2 instanceof Namespace) {
                return Constraints.a(element, (List<Constraint>)((Namespace)element.getOwner()).getOwnedRules());
            }
        } else if (element instanceof NamedElement && (namespace = ((NamedElement)element).getNamespace()) != null) {
            return Constraints.a(element, (List<Constraint>)namespace.getOwnedRules());
        }
        return Collections.emptyList();
    }

    private static List<Constraint> a(Element element, List<Constraint> list) {
        return Lists.newArrayList((Iterable)Collections2.filter(list, constraint -> constraint.getConstrainedElements().contains((Object)element) && !(constraint instanceof IntervalConstraint)));
    }

    public static List<String> separateConstraintText(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (char c2 : string.toCharArray()) {
            if (c2 == '{') {
                if (n > 0) {
                    stringBuffer.append(c2);
                }
                ++n;
                continue;
            }
            if (c2 == '}') {
                if (--n == 0) {
                    arrayList.add(stringBuffer.toString().trim());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(c2);
        }
        if (!stringBuffer.toString().isEmpty()) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public static String getLabel(Constraint constraint) {
        if (constraint != null) {
            ValueSpecification valueSpecification = constraint.getSpecification();
            if (valueSpecification instanceof OpaqueExpression && !((OpaqueExpression)valueSpecification).getBodies().isEmpty()) {
                return (String)((OpaqueExpression)valueSpecification).getBodies().get(0);
            }
            return constraint.getLabel();
        }
        return null;
    }

    public static boolean isTargetConstraint(Constraint constraint) {
        Operation operation;
        if (constraint instanceof TimeConstraint || constraint instanceof DurationConstraint) {
            return false;
        }
        Namespace namespace = constraint.getContext();
        return !(namespace instanceof Operation) || !(operation = (Operation)namespace).getPreconditions().contains((Object)constraint) && !operation.getPostconditions().contains((Object)constraint) && !constraint.equals(operation.getBodyCondition());
    }

    public static void setExpression(Constraint constraint, String string) {
        OpaqueExpression opaqueExpression;
        if (constraint instanceof DurationConstraint || constraint instanceof TimeConstraint) {
            constraint.setName(string);
            return;
        }
        ValueSpecification valueSpecification = constraint.getSpecification();
        if (valueSpecification instanceof OpaqueExpression) {
            opaqueExpression = (OpaqueExpression)valueSpecification;
            opaqueExpression.getBodies().clear();
        } else {
            opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
        }
        opaqueExpression.getBodies().add((Object)Constraints.removeConstraintPrefix(string));
        constraint.setSpecification((ValueSpecification)opaqueExpression);
        if (constraint.getContext() instanceof Operation) {
            Operation operation = (Operation)constraint.getContext();
            if (string.startsWith("BODYCONDITION:")) {
                operation.getPreconditions().remove((Object)constraint);
                operation.getPostconditions().remove((Object)constraint);
                Constraint constraint2 = operation.getBodyCondition();
                if (constraint2 != constraint) {
                    operation.setBodyCondition(constraint);
                    if (constraint2 != null) {
                        Elements.removeModel((Element)constraint2);
                    }
                }
            } else if (string.startsWith("PRECONDITION:")) {
                EList eList;
                operation.getPostconditions().remove((Object)constraint);
                if (operation.getBodyCondition() == constraint) {
                    operation.setBodyCondition(null);
                }
                if (!(eList = operation.getPreconditions()).contains((Object)constraint)) {
                    eList.add((Object)constraint);
                }
            } else if (string.startsWith("POSTCONDITION:")) {
                EList eList;
                operation.getPreconditions().remove((Object)constraint);
                if (operation.getBodyCondition() == constraint) {
                    operation.setBodyCondition(null);
                }
                if (!(eList = operation.getPostconditions()).contains((Object)constraint)) {
                    eList.add((Object)constraint);
                }
            } else {
                operation.getPreconditions().remove((Object)constraint);
                operation.getPostconditions().remove((Object)constraint);
                if (operation.getBodyCondition() == constraint) {
                    operation.setBodyCondition(null);
                }
            }
        }
    }

    public static void setConstraintContext(Constraint constraint, Element element) {
        if (element instanceof Namespace) {
            constraint.setContext((Namespace)element);
        } else if (element instanceof Realization) {
            Namespace namespace = Elements.findNearestNamespace(element);
            constraint.setContext(namespace);
        } else if (element instanceof Property) {
            Property property = (Property)element;
            if (property.getAssociation() != null) {
                constraint.setContext((Namespace)property.getAssociation());
            } else if (property.getOwner() instanceof Property) {
                constraint.setContext((Namespace)((Property)property.getOwner()).getAssociation());
            } else {
                Namespace namespace = Elements.findNearestNamespace(element);
                constraint.setContext(namespace);
            }
        } else if (element instanceof NamedElement) {
            constraint.setContext(((NamedElement)element).getNamespace());
        }
    }

    public static String removeConstraintPrefix(String string) {
        if (string.startsWith("PRECONDITION:")) {
            return string.substring("PRECONDITION:".length());
        }
        if (string.startsWith("POSTCONDITION:")) {
            return string.substring("POSTCONDITION:".length());
        }
        if (string.startsWith("BODYCONDITION:")) {
            return string.substring("BODYCONDITION:".length());
        }
        return string;
    }

    public static Constraint createConstraint(EObject eObject, String string) {
        if (!(eObject instanceof NamedElement)) {
            return null;
        }
        NamedElement namedElement = (NamedElement)eObject;
        Constraint constraint = UMLFactory.eINSTANCE.createConstraint();
        constraint.getConstrainedElements().add((Object)namedElement);
        Constraints.setConstraintContext(constraint, (Element)namedElement);
        Constraints.setExpression(constraint, string);
        return constraint;
    }
}

