/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.uml2.uml.Classes;
import net.astah.uml2.uml.Elements;
import net.astah.uml2.uml.Interfaces;
import net.astah.uml2.uml.Lifelines;
import net.astah.uml2.uml.Properties;
import net.astah.uml2.uml.TemplateBindings;
import net.astah.uml2.uml.TemplateParameters;
import net.astah.uml2.uml.TypeExpression;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CentralBufferNode;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationOwner;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class Classifiers {
    public static boolean isAllOperations(List<Feature> list) {
        if (list == null) {
            throw new IllegalArgumentException("objects is null.");
        }
        for (EObject eObject : list) {
            if (Classifiers.isOperation(eObject)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOperation(EObject eObject) {
        if (eObject == null) {
            return false;
        }
        return (Boolean)new UMLSwitch<Boolean>(){

            public Boolean caseOperation(Operation operation) {
                return true;
            }

            public Boolean defaultCase(EObject eObject) {
                return false;
            }
        }.doSwitch(eObject);
    }

    public static boolean isAllAttributes(List<Feature> list) {
        if (list == null) {
            throw new IllegalArgumentException("objects is null.");
        }
        for (EObject eObject : list) {
            if (eObject instanceof Port) {
                return false;
            }
            if (Classifiers.isAttributeWithoutAssociation(eObject)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAttributeWithoutAssociation(EObject eObject) {
        if (eObject == null) {
            return false;
        }
        return (Boolean)new UMLSwitch<Boolean>(){

            public Boolean caseProperty(Property property) {
                return Classifiers.isAttributeWithoutAssociation(property);
            }

            public Boolean defaultCase(EObject eObject) {
                return false;
            }
        }.doSwitch(eObject);
    }

    public static boolean isAttributeWithoutAssociation(Property property) {
        if (property == null) {
            throw new IllegalArgumentException("property is null.");
        }
        return Properties.isAttribute(property);
    }

    public static List<Property> getAllAttributesWithoutAssociations(Classifier classifier) {
        if (classifier == null) {
            throw new IllegalArgumentException("classifier is null.");
        }
        return Classifiers.getAttributesWithoutAssociations((List<Property>)classifier.getAllAttributes());
    }

    public static List<Property> getAttributesWithoutAssociations(Classifier classifier) {
        if (classifier == null) {
            throw new IllegalArgumentException("classifier is null.");
        }
        return Classifiers.getAttributesWithoutAssociations((List<Property>)classifier.getAttributes());
    }

    public static List<Property> getAttributesWithoutAssociations(List<Property> list) {
        if (list == null) {
            throw new IllegalArgumentException("propertys is null.");
        }
        return list.stream().filter(property -> Classifiers.isAttributeWithoutAssociation(property)).collect(Collectors.toList());
    }

    public static void changeFeatureOrder(Classifier classifier, Feature feature, List<Feature> list) {
        if (classifier == null) {
            throw new IllegalArgumentException("classifier is null.");
        }
        if (list == null) {
            throw new IllegalArgumentException("selectFeatures is null.");
        }
        if (feature == null) {
            Feature feature2 = list.get(0);
            if (feature2 instanceof Property) {
                Classifiers.a(classifier, list);
            } else if (feature2 instanceof Operation) {
                Classifiers.b(classifier, list);
            }
        } else if (feature instanceof Property) {
            Classifiers.a(classifier, feature, list);
        } else if (feature instanceof Operation) {
            Classifiers.b(classifier, feature, list);
        }
    }

    private static void a(Classifier classifier, List<Feature> list) {
        EList eList = ((AttributeOwner)classifier).getOwnedAttributes();
        for (int i = 0; i < list.size(); ++i) {
            eList.move(i, (Object)((Property)list.get(i)));
        }
    }

    private static void b(Classifier classifier, List<Feature> list) {
        EList eList = ((OperationOwner)classifier).getOwnedOperations();
        for (int i = 0; i < list.size(); ++i) {
            eList.move(i, (Object)((Operation)list.get(i)));
        }
    }

    private static void a(Classifier classifier, Feature feature, List<Feature> list) {
        int n;
        boolean bl;
        EList eList = ((AttributeOwner)classifier).getOwnedAttributes();
        int n2 = eList.indexOf((Object)feature);
        boolean bl2 = bl = n2 < (n = eList.indexOf((Object)list.get(0)));
        if (!bl) {
            Classifiers.a(list, (EList<Property>)eList, n2, n);
        }
        for (Feature feature2 : list) {
            if (bl) {
                ++n2;
            }
            eList.move(n2, (Object)((Property)feature2));
        }
    }

    private static void b(Classifier classifier, Feature feature, List<Feature> list) {
        int n;
        boolean bl;
        EList eList = ((OperationOwner)classifier).getOwnedOperations();
        int n2 = eList.indexOf((Object)feature);
        boolean bl2 = bl = n2 < (n = eList.indexOf((Object)list.get(0)));
        if (!bl) {
            Classifiers.b(list, (EList<Operation>)eList, n2, n);
        }
        for (Feature feature2 : list) {
            if (bl) {
                ++n2;
            }
            eList.move(n2, (Object)((Operation)feature2));
        }
    }

    private static void a(List<Feature> list, EList<Property> eList, int n, int n2) {
        int n3 = n - 1;
        BasicEList basicEList = new BasicEList();
        for (Feature feature : list) {
            int n4 = eList.indexOf((Object)feature);
            if (n4 >= n2 && n4 <= n3) continue;
            basicEList.add((Object)feature);
        }
        for (Feature feature : basicEList) {
            list.remove(feature);
        }
    }

    private static void b(List<Feature> list, EList<Operation> eList, int n, int n2) {
        int n3 = n - 1;
        BasicEList basicEList = new BasicEList();
        for (Feature feature : list) {
            int n4 = eList.indexOf((Object)feature);
            if (n4 >= n2 && n4 <= n3) continue;
            basicEList.add((Object)feature);
        }
        for (Feature feature : basicEList) {
            list.remove(feature);
        }
    }

    public static boolean validateClassifierUniqueness(Classifier classifier) {
        if (classifier == null) {
            throw new IllegalArgumentException("targetClassifier is null.");
        }
        if (Classes.isAnonymousBoundClass(classifier)) {
            return true;
        }
        if (classifier instanceof Behavior) {
            return true;
        }
        if (classifier instanceof Association && !(classifier instanceof AssociationClass)) {
            return true;
        }
        List<Classifier> list = Classifiers.getBrotherClassifiers(classifier);
        String string = classifier.getName();
        return list.stream().allMatch(classifier2 -> classifier2 == classifier || classifier2 instanceof Behavior || classifier2 instanceof Association && !(classifier2 instanceof AssociationClass) || string != null && !string.equals(classifier2.getName()));
    }

    public static List<Classifier> getBrotherClassifiers(Classifier classifier) {
        if (classifier == null) {
            throw new IllegalArgumentException("classifier is null.");
        }
        Element element2 = classifier.getOwner();
        ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
        if (element2 instanceof TemplateParameter) {
            TemplateSignature templateSignature = ((TemplateParameter)element2).getSignature();
            arrayList.addAll(TemplateParameters.getOwnedParametererdElements(templateSignature));
        } else if (element2 != null) {
            arrayList.addAll((Collection<Classifier>)element2.getOwnedElements());
        }
        return (List)List.class.cast(arrayList.stream().filter(element -> element instanceof Classifier).collect(Collectors.toList()));
    }

    public static List<Classifier> getSpecificClasses(Classifier classifier) {
        ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)classifier)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof Generalization) || ((Generalization)eObject).getGeneral() != classifier) continue;
            arrayList.add(((Generalization)eObject).getSpecific());
        }
        return arrayList;
    }

    public static Collection<Classifier> getAncestors(Classifier classifier) {
        Classifier classifier2;
        HashSet<Classifier> hashSet = new HashSet<Classifier>();
        if (classifier == null) {
            return hashSet;
        }
        for (TemplateBinding templateBinding : classifier.getTemplateBindings()) {
            classifier2 = (Classifier)templateBinding.getSignature().getTemplate();
            if (hashSet.contains(classifier2)) continue;
            hashSet.add(classifier2);
            hashSet.addAll(Classifiers.getAncestors(classifier2));
        }
        for (TemplateBinding templateBinding : classifier.getGeneralizations()) {
            classifier2 = templateBinding.getGeneral();
            if (hashSet.contains(classifier2)) continue;
            hashSet.add(classifier2);
            hashSet.addAll(Classifiers.getAncestors(classifier2));
        }
        if (classifier instanceof BehavioredClassifier) {
            for (TemplateBinding templateBinding : ((BehavioredClassifier)classifier).getInterfaceRealizations()) {
                classifier2 = templateBinding.getContract();
                if (hashSet.contains(classifier2)) continue;
                hashSet.add(classifier2);
                hashSet.addAll(Classifiers.getAncestors(classifier2));
            }
        }
        return hashSet;
    }

    public static Collection<Classifier> getGeneralizationAncestors(Classifier classifier) {
        HashSet<Classifier> hashSet = new HashSet<Classifier>();
        if (classifier == null) {
            return hashSet;
        }
        for (Generalization generalization : classifier.getGeneralizations()) {
            Classifier classifier2 = generalization.getGeneral();
            if (hashSet.contains(classifier2)) continue;
            hashSet.add(classifier2);
            hashSet.addAll(Classifiers.getGeneralizationAncestors(classifier2));
        }
        return hashSet;
    }

    public static Classifier getLastGeneral(Classifier classifier) {
        if (classifier == null) {
            return null;
        }
        EList eList = classifier.getGeneralizations();
        if (eList.size() > 0) {
            return ((Generalization)eList.get(eList.size() - 1)).getGeneral();
        }
        return null;
    }

    public static Generalization getGeneralizableRelation(Classifier classifier, Classifier classifier2) {
        for (Generalization generalization : classifier2.getGeneralizations()) {
            if (!generalization.getGeneral().equals(classifier)) continue;
            return generalization;
        }
        return null;
    }

    public static List<Generalization> getSpecializations(Classifier classifier) {
        ArrayList<Generalization> arrayList = new ArrayList<Generalization>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)classifier)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof Generalization) || ((Generalization)eObject).getGeneral() != classifier) continue;
            arrayList.add((Generalization)eObject);
        }
        return arrayList;
    }

    public static EList<InstanceSpecification> getInstanceSpecifications(Classifier classifier) {
        BasicEList basicEList = new BasicEList();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)classifier)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof InstanceSpecification)) continue;
            basicEList.add((Object)((InstanceSpecification)eObject));
        }
        return basicEList;
    }

    public static EList<Classifier> getSubClass(Classifier classifier, EList<Classifier> eList) {
        List<Classifier> list = Classifiers.getSpecificClasses(classifier);
        for (Classifier classifier2 : list) {
            eList.add((Object)classifier2);
            eList = Classifiers.getSubClass(classifier2, eList);
        }
        return eList;
    }

    public static List<Generalization> getGeneralizationPaths(Classifier classifier, Classifier classifier2) {
        if (classifier == classifier2) {
            return Collections.emptyList();
        }
        for (Generalization generalization : classifier.getGeneralizations()) {
            if (generalization.getGeneral() == classifier2) {
                return Arrays.asList(generalization);
            }
            List<Generalization> list = Classifiers.getGeneralizationPaths(generalization.getGeneral(), classifier2);
            if (list.isEmpty()) continue;
            ArrayList<Generalization> arrayList = new ArrayList<Generalization>();
            arrayList.add(generalization);
            arrayList.addAll(list);
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static List<Classifier> getAncestors(Classifier classifier, List<Classifier> list) {
        Classifier classifier2;
        Object object2;
        Classifier classifier3;
        if (classifier == null) {
            return list;
        }
        if (classifier instanceof Classifier) {
            classifier3 = classifier;
            for (Object object2 : classifier3.getTemplateBindings()) {
                classifier2 = (Classifier)object2.getSignature().getTemplate();
                if (list.contains(classifier2)) continue;
                list.add(classifier2);
                list = Classifiers.getAncestors(classifier2, list);
            }
        }
        classifier3 = classifier.getGeneralizations();
        for (Object object2 : classifier3) {
            classifier2 = object2.getGeneral();
            if (classifier2 == classifier || list.contains(classifier2) || !(classifier2 instanceof Classifier)) continue;
            list.add(classifier2);
            list = Classifiers.getAncestors(classifier2, list);
        }
        Iterator iterator = classifier.getRelationships(UMLPackage.Literals.REALIZATION);
        object2 = iterator.iterator();
        while (object2.hasNext()) {
            Element element;
            classifier2 = (Relationship)object2.next();
            if (!(classifier2 instanceof Realization) || !((element = (Element)((Realization)classifier2).getSuppliers().get(0)) instanceof Classifier) || element == classifier || list.contains(element)) continue;
            list.add((Classifier)element);
            list = Classifiers.getAncestors((Classifier)element, list);
        }
        return list;
    }

    public static List<Classifier> getSuperTypes(Classifier classifier) {
        ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
        Iterator iterator = classifier.getGeneralizations().iterator();
        while (iterator.hasNext()) {
            Classifier classifier2 = ((Generalization)iterator.next()).getSpecific();
            arrayList.add(classifier2);
        }
        return arrayList;
    }

    public static boolean hasStereotype(Classifier classifier, String string) {
        EList eList = classifier.getApplicableStereotypes();
        if (eList.size() == 0) {
            return false;
        }
        Stereotype stereotype = (Stereotype)eList.get(0);
        return stereotype.getName().equals(string);
    }

    public static boolean isInterface(Classifier classifier) {
        return classifier instanceof Interface;
    }

    public static boolean isActor(Classifier classifier) {
        return classifier instanceof Actor;
    }

    public static boolean isAnonymousBoundClass(Classifier classifier) {
        return classifier != null && Strings.isNullOrEmpty((String)classifier.getName()) && classifier.getTemplateBindings() != null && !classifier.getTemplateBindings().isEmpty();
    }

    public static List<Classifier> getActualParameterCandidates(Classifier classifier, List<Classifier> list, boolean bl) {
        for (Classifier object : Classifiers.getSpecificClasses(classifier)) {
            list = Classifiers.getValidActualParameterCandidates(classifier, object, list, bl);
        }
        if (Classes.isInterface((Type)classifier)) {
            Iterator<Classifier> iterator = Interfaces.getImplementingClassifiers((Interface)classifier);
            list.addAll((Collection<Classifier>)((Object)iterator));
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                BehavioredClassifier behavioredClassifier = (BehavioredClassifier)iterator2.next();
                for (Classifier classifier2 : Classifiers.getSpecificClasses((Classifier)behavioredClassifier)) {
                    list = Classifiers.getValidActualParameterCandidates((Classifier)behavioredClassifier, classifier2, list, bl);
                }
            }
        }
        return list;
    }

    public static List<Classifier> getValidActualParameterCandidates(Classifier classifier, Classifier classifier2, List<Classifier> list, boolean bl) {
        if (!classifier2.equals(classifier) && !list.contains(classifier2)) {
            if (classifier2 != null && (!Classes.isInterface((Type)classifier2) || bl)) {
                list.add(classifier2);
            }
            list = Classifiers.getActualParameterCandidates(classifier2, list, bl);
        }
        return list;
    }

    public static void addTemplateBinding(Classifier classifier, Classifier classifier2, Object[][] objectArray) {
        TemplateBinding templateBinding = TemplateBindings.createTemplateBinding(classifier2, classifier);
        EList eList = templateBinding.getParameterSubstitutions();
        for (int i = 0; i < eList.size(); ++i) {
            TemplateParameterSubstitution templateParameterSubstitution = (TemplateParameterSubstitution)eList.get(i);
            Object object = objectArray[i][0];
            if (object == null || object.equals("") || object.equals("?")) continue;
            if (object instanceof String) {
                StringExpression stringExpression = UMLFactory.eINSTANCE.createStringExpression();
                stringExpression.setName(object.toString());
                templateParameterSubstitution.setOwnedActual((ParameterableElement)stringExpression);
            } else if (object instanceof ParameterableElement) {
                templateParameterSubstitution.setActual((ParameterableElement)object);
            } else if (object instanceof TypeExpression) {
                templateParameterSubstitution.setActual((ParameterableElement)((TypeExpression)object).getType());
            }
            if (objectArray[i][1] == null) continue;
        }
    }

    public static TypeExpression generateTypeExpression(String string, Classifier classifier) {
        List<ValueSpecification> list = TypeExpression.getMultiplicityValue(string);
        Property property = UMLFactory.eINSTANCE.createProperty();
        if (list != null) {
            property.setLowerValue(list.size() > 0 ? list.get(0) : null);
            property.setUpperValue(list.size() > 1 ? list.get(1) : null);
        }
        return new TypeExpression((Type)classifier, (MultiplicityElement)property);
    }

    public static List<EObject> getClassifierInvInstances(Classifier classifier) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        EObject eObject = null;
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)classifier)) {
            EObject eObject2 = setting.getEObject();
            EObject eObject3 = eObject2.eContainer();
            if (eObject2 instanceof CentralBufferNode || eObject2 instanceof InputPin || eObject2 instanceof OutputPin || eObject2 instanceof ActivityParameterNode || eObject2 instanceof InstanceSpecification) {
                arrayList.add(eObject2);
            }
            if (eObject2 instanceof Property && Classifiers.isAttributeWithoutAssociation(eObject2)) {
                if (eObject3 instanceof Interaction) {
                    Lifeline lifeline = Lifelines.getLifeline((ConnectableElement)((Property)eObject2));
                    if (lifeline != null) {
                        arrayList.add((EObject)lifeline);
                    }
                } else {
                    arrayList.add(eObject3);
                }
            }
            if (eObject2 instanceof Parameter) {
                arrayList.add(eObject3.eContainer());
            }
            if (!(eObject2 instanceof ClassifierTemplateParameter)) continue;
            if (eObject == null || !eObject3.equals(eObject)) {
                arrayList.add(eObject3.eContainer());
            }
            eObject = eObject3;
        }
        return arrayList;
    }

    public static Classifier createAnonymousBoundClass(Classifier classifier, Object[][] objectArray) {
        Model model = Elements.getTopModel((Element)classifier);
        Class clazz = model.createOwnedClass(null, false);
        Classifiers.addTemplateBinding(classifier, (Classifier)clazz, objectArray);
        return clazz;
    }
}

