/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.astah.uml2.uml.Elements;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;

public class Activities {
    public static Activity createActivity(NamedElement namedElement, String string) {
        if (namedElement instanceof Package) {
            return Activities.createActivity((Package)namedElement, string);
        }
        if (namedElement instanceof BehavioredClassifier) {
            return Activities.createActivity((BehavioredClassifier)namedElement, string);
        }
        if (namedElement instanceof BehavioralFeature) {
            return Activities.createActivity((BehavioralFeature)namedElement, string);
        }
        if (namedElement instanceof Interface) {
            return Activities.createActivity((Interface)namedElement, string);
        }
        return null;
    }

    public static Activity createActivity(BehavioredClassifier behavioredClassifier, String string) {
        Activity activity = Activities.createActivity(string);
        behavioredClassifier.getOwnedBehaviors().add((Object)activity);
        return activity;
    }

    public static Activity createActivity(Package package_, String string) {
        Activity activity = Activities.createActivity(string);
        package_.getPackagedElements().add((Object)activity);
        return activity;
    }

    public static Activity createActivity(Interface interface_, String string) {
        BehavioredClassifier behavioredClassifier = Elements.getOwningElement((Element)interface_, BehavioredClassifier.class);
        if (behavioredClassifier != null) {
            return Activities.createActivity(behavioredClassifier, string);
        }
        Activity activity = Activities.createActivity(string);
        activity.setPackage(interface_.getNearestPackage());
        return activity;
    }

    public static Activity createActivity(BehavioralFeature behavioralFeature, String string) {
        Activity activity;
        Element element = behavioralFeature.getOwner();
        if (element instanceof NamedElement && (activity = Activities.createActivity((NamedElement)element, string)) != null) {
            behavioralFeature.getMethods().add((Object)activity);
            return activity;
        }
        return null;
    }

    public static Activity createActivity(String string) {
        Activity activity = UMLFactory.eINSTANCE.createActivity();
        activity.setName(string);
        return activity;
    }

    public static List<CallBehaviorAction> getCallBehaviorActions(Activity activity) {
        ArrayList<CallBehaviorAction> arrayList = new ArrayList<CallBehaviorAction>();
        Collection collection = UML2Util.getNonNavigableInverseReferences((EObject)activity);
        for (EStructuralFeature.Setting setting : collection) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof CallBehaviorAction)) continue;
            arrayList.add((CallBehaviorAction)eObject);
        }
        return arrayList;
    }
}

