/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.astah.emf.common.ecore.EcoreCopier;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.model.extension.ExtensionPackage;
import net.astah.uml2.umlx.UMLExtensionPackage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicClassMembers;

@Keep
@KeepPublicClassMembers
public class UMLExporter
implements IDisposable {
    protected ResourceSet a;
    protected Map<Object, Object> b;
    private String c;
    private boolean d;

    public void export(Iterable<? extends EObject> iterable, URI uRI) {
        this.export(iterable, uRI, null);
    }

    public void export(Iterable<? extends EObject> iterable, URI uRI, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)"Creating exported model image", (int)1);
        EcoreUtil.Copier copier = this.a();
        for (EObject eObject2 : iterable) {
            copier.copy(eObject2);
        }
        copier.copyReferences();
        ResourceSet resourceSet = this.getResourceSet();
        Resource resource = this.a(resourceSet, uRI);
        LinkedHashMap<EObject, Resource> linkedHashMap = new LinkedHashMap<EObject, Resource>();
        for (Map.Entry entry : copier.entrySet()) {
            String string;
            Resource resource2;
            Resource resource3;
            Element element;
            EObject eObject = (EObject)entry.getKey();
            EObject eObject2 = (EObject)entry.getValue();
            Resource resource4 = this.a(eObject2, element = this.a(copier, eObject, eObject2), uRI);
            if (resource4 != null) {
                resource3 = resource4;
                linkedHashMap.put(eObject2, resource3);
            } else {
                resource3 = resource;
            }
            if (resource3 instanceof XMLResource && (resource2 = eObject.eResource()) instanceof XMLResource && (string = ((XMLResource)resource2).getID(eObject)) != null) {
                ((XMLResource)resource3).setID(eObject2, string);
            }
            subMonitor.done();
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            ((Resource)entry.getValue()).getContents().add(entry.getKey());
        }
    }

    public void save(Map<Object, Object> map) throws IOException {
        this.save(map, null);
    }

    public void save(Map<Object, Object> map, IProgressMonitor iProgressMonitor) throws IOException {
        EList eList = this.a.getResources();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)"Saving XMI Files", (int)eList.size());
        if (map == null) {
            map = this.getDefaultOptions();
        }
        for (Resource resource : new ArrayList(eList)) {
            if (resource.isModified()) {
                resource.save(map);
            }
            subMonitor.worked(1);
        }
        subMonitor.done();
    }

    public void dispose() {
        if (this.a != null) {
            ResourceSets.dispose((ResourceSet)this.a);
            this.a = null;
        }
    }

    public ResourceSet getResourceSet() {
        if (this.a == null) {
            this.a = new ResourceSetImpl();
        }
        return this.a;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.a = resourceSet;
    }

    public Map<Object, Object> getDefaultOptions() {
        if (this.b == null) {
            this.b = new HashMap<Object, Object>();
            this.b.put("USE_XMI_TYPE", true);
            this.b.put("SAVE_TYPE_INFORMATION", true);
            this.b.put("SCHEMA_LOCATION_IMPLEMENTATION", true);
        }
        return this.b;
    }

    public void setDefaultOptions(Map<Object, Object> map) {
        this.b = map;
    }

    public String getContentType() {
        return this.c;
    }

    public void setContentType(String string) {
        this.c = string;
    }

    public boolean isOmitProfileDefinition() {
        return this.d;
    }

    public void setOmitProfileDefinition(boolean bl) {
        this.d = bl;
    }

    protected Element a(EcoreUtil.Copier copier, EObject eObject, EObject eObject2) {
        EObject eObject3;
        Element element;
        if (!(eObject instanceof Element) && (element = UMLUtil.getBaseElement((EObject)eObject)) != null && (eObject3 = (EObject)copier.get((Object)element)) instanceof Element) {
            return (Element)eObject3;
        }
        return null;
    }

    protected Resource a(EObject eObject, Element element, URI uRI) {
        if (element != null) {
            for (Element element2 = element; element2 != null; element2 = element2.eContainer()) {
                Resource resource = this.a((EObject)element2, uRI);
                if (resource == null) continue;
                return resource;
            }
        }
        return this.a(eObject, uRI);
    }

    protected Resource a(EObject eObject, URI uRI) {
        if (eObject instanceof Profile) {
            Profile profile = (Profile)eObject;
            URI uRI2 = this.a(uRI, profile);
            if (uRI2 != null) {
                ResourceSet resourceSet = this.getResourceSet();
                return this.a(resourceSet, uRI2);
            }
        } else if (eObject.eContainer() == null) {
            ResourceSet resourceSet = this.getResourceSet();
            return resourceSet.getResource(uRI, false);
        }
        return null;
    }

    protected Resource a(ResourceSet resourceSet, URI uRI) {
        Resource resource = resourceSet.getResource(uRI, false);
        if (resource != null) {
            return resource;
        }
        Resource resource2 = resourceSet.createResource(uRI, this.c);
        if (resource2 == null) {
            throw new IllegalArgumentException("Couldn't create resource for " + uRI);
        }
        resource2.setModified(true);
        return resource2;
    }

    protected URI a(URI uRI, Profile profile) {
        String string = profile.getName();
        if (string == null && (string = profile.getURI()) == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UML2Util.getValidJavaIdentifier((String)string)).append('.');
        String string2 = uRI.fileExtension();
        stringBuilder.append(string2 != null ? string2 : "xmi");
        return URI.createURI((String)stringBuilder.toString()).resolve(uRI);
    }

    protected EcoreUtil.Copier a() {
        return new Copier(this.isOmitProfileDefinition());
    }

    protected static class Copier
    extends EcoreCopier {
        private static final long serialVersionUID = 1L;
        protected final Set<EPackage> ePackages = new HashSet<EPackage>();
        protected final Set<String> extensions = new HashSet<String>();

        public Copier(boolean bl) {
            this.ePackages.add((EPackage)ExtensionPackage.eINSTANCE);
            this.ePackages.add((EPackage)UMLPackage.eINSTANCE);
            this.ePackages.add(UMLExtensionPackage.eINSTANCE);
            this.extensions.add("http://astah.net/model/1.0.0/Extension");
            if (!bl) {
                this.ePackages.add((EPackage)EcorePackage.eINSTANCE);
                this.extensions.add("http://www.eclipse.org/uml2/2.0.0/UML");
                this.extensions.add("http://www.eclipse.org/emf/2002/Ecore");
            }
        }

        public void copyReferences() {
            super.copyReferences();
            for (EObject eObject : this.values()) {
                EObject eObject2 = (EObject)this.get(eObject.eClass());
                if (!(eObject2 instanceof EClass)) continue;
                ((InternalEObject)eObject).eSetClass((EClass)eObject2);
            }
        }

        protected boolean shouldCopy(EObject eObject) {
            if (eObject instanceof EAnnotation) {
                return this.extensions.contains(((EAnnotation)eObject).getSource());
            }
            if (this.ePackages.contains(eObject.eClass().getEPackage())) {
                return true;
            }
            return UMLUtil.getBaseElement((EObject)eObject) != null;
        }

        protected void copyExtra(EObject eObject, EObject eObject2) {
            if (eObject instanceof Element) {
                EObject eObject3;
                Element element = (Element)eObject;
                Iterator iterator = element.getStereotypeApplications().iterator();
                while (iterator.hasNext()) {
                    eObject3 = (EObject)iterator.next();
                    this.copy(eObject3);
                }
                if (element instanceof ProfileApplication && (iterator = ((ProfileApplication)element).getAppliedProfile()) != null && (eObject3 = iterator.getDefinition()) != null && UMLUtil.getProfile((EPackage)eObject3) == iterator) {
                    this.copy((EObject)iterator);
                }
            }
        }
    }
}

