/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.provider.IChangeProcessor;
import net.astah.emf.edit.transaction.TransactionChangeDispatcher;
import net.astah.golf.draw.GNode;
import net.astah.golf.model.ChangeObservableTracker;
import net.astah.golf.model.EMFEntityEditUnitTraversalCollector;
import net.astah.golf.model.EMFEntityStore;
import net.astah.golf.model.EntityStoreEvent;
import net.astah.golf.model.IEntityEditUnit;
import net.astah.golf.model.IEntityStore;
import net.astah.jomt.jutil.SwingInvoker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFEntityStoreResourceSetListener
extends TransactionChangeDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFEntityStoreResourceSetListener.class);
    private final EMFEntityEditUnitTraversalCollector collector = new EMFEntityEditUnitTraversalCollector();
    protected final ChangeObservableTracker changeProcessor = new ChangeObservableTracker();
    protected final EMFEntityStore entityStore;

    public EMFEntityStoreResourceSetListener(EMFEntityStore eMFEntityStore) {
        this.entityStore = eMFEntityStore;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceSetChanged(ResourceSetChangeEvent resourceSetChangeEvent) {
        try {
            super.resourceSetChanged(resourceSetChangeEvent);
            Transaction transaction = resourceSetChangeEvent.getTransaction();
            if (transaction == null || !this.isUndoable(transaction)) {
                return;
            }
            assert (((InternalTransaction)transaction).getRoot() == transaction);
            TransactionalEditingDomain transactionalEditingDomain = resourceSetChangeEvent.getEditingDomain();
            IEntityEditUnit[] iEntityEditUnitArray = this.collector.collect(resourceSetChangeEvent.getNotifications());
            TransactionChangeDescription transactionChangeDescription = transaction.getChangeDescription();
            Supplier<Collection<GNode>> supplier = this.changeProcessor.updateViewObservers();
            SwingInvoker.runInEDT(() -> this.lambda$resourceSetChanged$1(transactionalEditingDomain, supplier, iEntityEditUnitArray, (ChangeDescription)transactionChangeDescription));
        }
        finally {
            this.changeProcessor.postcommit();
        }
    }

    protected Map<IChangeProcessor, Collection<Object>> collectProcessors(TransactionalEditingDomain transactionalEditingDomain, List<Notification> list) {
        Map map = super.collectProcessors(transactionalEditingDomain, list);
        map.put(this.changeProcessor, Collections.emptySet());
        return map;
    }

    protected boolean isUndoable(Transaction transaction) {
        if (transaction.isReadOnly() || transaction.getStatus().getSeverity() >= 4) {
            return false;
        }
        Map map = transaction.getOptions();
        if (map != null) {
            Object v = map.get("no_undo");
            if (v instanceof Boolean && ((Boolean)v).booleanValue()) {
                return false;
            }
            Object v2 = map.get("unprotected");
            if (v2 instanceof Boolean && ((Boolean)v2).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    private /* synthetic */ void lambda$resourceSetChanged$1(TransactionalEditingDomain transactionalEditingDomain, Supplier supplier, IEntityEditUnit[] iEntityEditUnitArray, ChangeDescription changeDescription) {
        try {
            Transactions.safeRunExclusive((TransactionalEditingDomain)transactionalEditingDomain, () -> this.lambda$null$0((Supplier)supplier, iEntityEditUnitArray, changeDescription)).get();
        }
        catch (ExecutionException executionException) {
            LOGGER.debug("Failed to update view observers", executionException.getCause());
        }
        catch (InterruptedException | CancellationException exception) {
            LOGGER.info("Update view observers task has been canceled: {}", (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$null$0(Supplier supplier, IEntityEditUnit[] iEntityEditUnitArray, ChangeDescription changeDescription) {
        Collection collection = (Collection)supplier.get();
        EntityStoreEvent entityStoreEvent = new EntityStoreEvent((IEntityStore)this.entityStore, iEntityEditUnitArray, collection);
        this.entityStore.postCommit(changeDescription, entityStoreEvent);
        this.entityStore.fireEntityStoreChanged(entityStoreEvent);
    }
}

