/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.model;

import javax.swing.undo.AbstractUndoableEdit;
import net.astah.golf.model.EMFEntityStore;
import net.astah.golf.model.IEntityStoreEdit;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EMFEntityStoreEdit
extends AbstractUndoableEdit
implements IEntityStoreEdit {
    private static final long serialVersionUID = -7184179953467820608L;
    private ChangeDescription changeDescription;
    private EMFEntityStore entityStore;
    private static final Logger logger = LoggerFactory.getLogger(EMFEntityStoreEdit.class);

    EMFEntityStoreEdit(EMFEntityStore eMFEntityStore, ChangeDescription changeDescription) {
        this.entityStore = eMFEntityStore;
        this.changeDescription = changeDescription;
    }

    @Override
    public void undo() {
        ChangeDescription changeDescription = this.getChangeDescription();
        if (changeDescription == null) {
            throw new IllegalStateException("description is null.");
        }
        this.entityStore.setUndoing(true);
        logger.trace("undo is started.");
        changeDescription.applyAndReverse();
        super.undo();
    }

    @Override
    public void redo() {
        ChangeDescription changeDescription = this.getChangeDescription();
        if (changeDescription == null) {
            throw new IllegalStateException("description is null.");
        }
        this.entityStore.setRedoing(true);
        logger.trace("redo is started.");
        changeDescription.applyAndReverse();
        super.redo();
    }

    private ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }
}

