/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.model;

import com.google.common.collect.Lists;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.domain.AstahTransactionalEditingDomain;
import net.astah.emf.edit.command.Commands;
import net.astah.golf.model.Adaptable;
import net.astah.golf.model.BadEntityException;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.EMFEntityRoot;
import net.astah.golf.model.EMFEntityStoreEdit;
import net.astah.golf.model.EMFEntityStoreResourceSetListener;
import net.astah.golf.model.EntityChangeListener;
import net.astah.golf.model.EntityStoreEvent;
import net.astah.golf.model.EntityStoreListener;
import net.astah.golf.model.IEntityRoot;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.model.IEntityStoreEdit;
import net.astah.golf.model.PermitToAddEntityException;
import net.astah.golf.model.SaveFailedException;
import net.astah.golf.util.CancelException;
import net.astah.golf.util.NonCompatibleException;
import net.astah.golf.widget.CComponent;
import net.astah.jomt.jsystem.ModelVersionInfo;
import net.astah.project.Project;
import net.astah.project.ProjectFactory;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.ProjectPackage;
import net.astah.project.edit.command.LoadedFacetsCommand;
import net.astah.project.edit.command.MigrateFacetsCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.impl.EditingDomainManager;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class EMFEntityStore
implements Adaptable,
IEntityStore,
IDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFEntityStore.class);
    public static final String MODEL_FILENAME = "model.axmi";
    private final INotifyChangedListener modifiedAdapter = new INotifyChangedListener(){

        public void notifyChanged(Notification notification) {
            if (!notification.isTouch() && notification.getFeature() == ProjectPackage.Literals.PROJECT__MODIFIED) {
                EMFEntityStore.this.firePropertyChange("modified", notification.getOldBooleanValue(), notification.getNewBooleanValue());
            }
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(EMFEntityStore.class);
    protected InternalTransactionalEditingDomain domain;
    final CopyOnWriteArrayList<UndoableEditListener> undoableEditListeners = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<EntityStoreListener> entityStoreListeners = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<EntityChangeListener> entityChangeListeners = new CopyOnWriteArrayList();
    private IEntityRoot root;
    private String documentName = "no_title";
    private boolean wasEmpty = false;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private boolean undoing;
    private boolean redoing;
    private boolean transactionOn = true;
    private static final Marker changedEntityMarker = MarkerFactory.getMarker((String)"entityChanged");
    private static final Marker undoMarker = MarkerFactory.getMarker((String)"undo");
    private EMFEntityStoreResourceSetListener emfEntityStoreResourceSetListener;
    private Map<Transaction, EntityStoreEvent> changedAfterTransactionEvents = new WeakHashMap<Transaction, EntityStoreEvent>();

    public EMFEntityStore() {
        this.createTransactionalEditingDomain();
        this.root = this.createEntityRoot(this.domain.getResourceSet());
    }

    private EMFEntityRoot createEntityRoot(ResourceSet resourceSet) {
        Project project = this.createRootProject();
        ProjectManagerAdapter projectManagerAdapter = new ProjectManagerAdapter(resourceSet);
        projectManagerAdapter.addListener(this.modifiedAdapter);
        projectManagerAdapter.setRootProject(project);
        this.domain.getCommandStack().flush();
        project.setModified(false);
        return new EMFEntityRoot(project);
    }

    private Project createRootProject() {
        Project project = ProjectFactory.eINSTANCE.createProject();
        project.setId(EcoreUtil.generateUUID());
        URI uRI = URI.createURI((String)"project.axmp");
        Resource resource = this.domain.getResourceSet().createResource(uRI, "");
        if (resource instanceof XMLResource) {
            ((XMLResource)resource).setID((EObject)project, project.getId());
        }
        CommandStack commandStack = this.domain.getCommandStack();
        commandStack.execute((Command)new AddCommand((EditingDomain)this.domain, resource.getContents(), (Object)project));
        return project;
    }

    private void createTransactionalEditingDomain() {
        AstahTransactionalEditingDomain.FACTORY.getClass();
        EditingDomainManager editingDomainManager = EditingDomainManager.getInstance();
        this.domain = (InternalTransactionalEditingDomain)editingDomainManager.createEditingDomain("net.astah.emf.project");
        editingDomainManager.configureListeners("net.astah.emf.project", (TransactionalEditingDomain)this.domain);
        this.emfEntityStoreResourceSetListener = new EMFEntityStoreResourceSetListener(this);
        this.domain.addResourceSetListener((ResourceSetListener)this.emfEntityStoreResourceSetListener);
        ((TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)this.domain, TransactionalEditingDomain.Lifecycle.class)).addTransactionalEditingDomainListener((TransactionalEditingDomainListener)new TransactionalEditingDomainListenerImpl(){

            public void transactionStarted(TransactionalEditingDomainEvent transactionalEditingDomainEvent) {
                Transaction transaction = transactionalEditingDomainEvent.getTransaction();
                if (!transaction.isReadOnly() && transaction.getParent() == null) {
                    EMFEntityStore.this.wasEmpty = EMFEntityStore.this.isEmpty();
                }
            }

            public void transactionClosed(TransactionalEditingDomainEvent transactionalEditingDomainEvent) {
                EntityStoreEvent entityStoreEvent;
                if (transactionalEditingDomainEvent.getTransaction().getStatus().matches(12) && EMFEntityStore.this.emfEntityStoreResourceSetListener != null) {
                    EMFEntityStore.this.emfEntityStoreResourceSetListener.resourceSetChanged(new ResourceSetChangeEvent((TransactionalEditingDomain)EMFEntityStore.this.domain, null, null));
                }
                if ((entityStoreEvent = (EntityStoreEvent)EMFEntityStore.this.changedAfterTransactionEvents.remove(transactionalEditingDomainEvent.getTransaction())) != null) {
                    EMFEntityStore.this.entityStoreChangedAfterTransaction(entityStoreEvent);
                }
            }
        });
        this.domain.getCommandStack().addCommandStackListener(eventObject -> {
            CommandStack commandStack = (CommandStack)eventObject.getSource();
            if (commandStack.canUndo() || commandStack.canRedo()) {
                commandStack.flush();
            }
        });
        if (CacheAdapter.getCacheAdapter((Notifier)this.domain.getResourceSet()) == null) {
            this.domain.getResourceSet().eAdapters().add((Object)CacheAdapter.getInstance());
        }
    }

    @Deprecated
    public void empty() throws BadTransactionException {
        InternalTransaction internalTransaction = this.domain.getActiveTransaction();
        if (internalTransaction != null && internalTransaction.isActive()) {
            throw new BadTransactionException();
        }
        this.root.empty();
        this.fireEntityStoreChanged(new EntityStoreEvent((IEntityStore)this, 1));
    }

    @Deprecated
    public boolean isEmpty() {
        return this.root == null || this.root.isEmpty();
    }

    public void setIsProgress(boolean bl) {
    }

    public void open(String string) throws IOException, ClassNotFoundException, BadTransactionException, CancelException, NonCompatibleException {
        this.openProject(string, null);
        this.loadProject(null);
    }

    public void open(String string, IProgressMonitor iProgressMonitor) throws IOException, ClassNotFoundException, BadTransactionException, CancelException, NonCompatibleException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        subMonitor.beginTask("Opening project", 10);
        this.openProject(string, (IProgressMonitor)subMonitor.newChild(1));
        this.loadProject((IProgressMonitor)subMonitor.newChild(9));
    }

    public void openProject(String string, IProgressMonitor iProgressMonitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        subMonitor.beginTask("Opening project", 10);
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter((ResourceSet)this.domain.getResourceSet());
        URI uRI = URI.createFileURI((String)string);
        Project project = projectManagerAdapter.getRootProject();
        if (project != null) {
            project.close();
        }
        this.preOpen();
        subMonitor.worked(4);
        Map<String, SubMonitor> map = iProgressMonitor == null ? null : Collections.singletonMap("MONITOR", subMonitor.newChild(5));
        Project project2 = projectManagerAdapter.open(uRI, map);
        projectManagerAdapter.setRootProject(project2);
        this.documentName = string;
        subMonitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject(IProgressMonitor iProgressMonitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        subMonitor.beginTask("Loading project", 10);
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter((ResourceSet)this.domain.getResourceSet());
        Project project = projectManagerAdapter.getRootProject();
        Map<String, SubMonitor> map = iProgressMonitor == null ? null : Collections.singletonMap("MONITOR", subMonitor.newChild(9));
        project.load(map);
        String string = ModelVersionInfo.getVersionWithEdition();
        MigrateFacetsCommand migrateFacetsCommand = new MigrateFacetsCommand((EditingDomain)this.domain, project, string);
        LoadedFacetsCommand loadedFacetsCommand = new LoadedFacetsCommand((EditingDomain)this.domain, project);
        if (migrateFacetsCommand.canExecute() || loadedFacetsCommand.canExecute()) {
            this.beginTransaction();
            try {
                Commands.execute((Command)migrateFacetsCommand);
                Commands.execute((Command)loadedFacetsCommand);
            }
            finally {
                this.commitTransaction();
            }
        }
        this.root = new EMFEntityRoot(project);
        this.postOpen();
        this.setModified(false);
        this.fireEntityStoreChanged(new EntityStoreEvent((IEntityStore)this, 2));
        subMonitor.done();
    }

    protected void preOpen() {
    }

    protected void postOpen() {
    }

    public void open(InputStream inputStream) throws IOException, ClassNotFoundException, BadTransactionException, CancelException, NonCompatibleException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public void save() throws IOException, BadTransactionException, SaveFailedException {
        this.saveAs(this.documentName);
    }

    public void saveAs(String string, boolean bl) throws IOException, BadTransactionException, SaveFailedException {
        this.setName(string);
        Project project = ProjectManagerAdapter.getRootProject((Notifier)this.domain.getResourceSet());
        URI uRI = URI.createFileURI((String)string);
        project.saveAs(uRI, Collections.singletonMap("SAVE_UNMODIFIED", true));
        if (bl && this.isModified()) {
            this.setModified(false);
            this.firePropertyChange("modified", true, false);
        }
    }

    public void saveAs(String string) throws IOException, BadTransactionException, SaveFailedException {
        this.saveAs(string, true);
    }

    public void setName(String string) {
        String string2 = this.documentName;
        this.documentName = string;
        this.firePropertyChange("documentName", string2, string);
    }

    public boolean isMerged() {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public void setMerged(boolean bl) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public boolean isModified() {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)this.domain.getResourceSet());
        return project != null && project.isModified();
    }

    public void setModified(boolean bl) {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)this.domain.getResourceSet());
        if (project != null) {
            project.setModified(bl);
        }
    }

    @Deprecated
    public void addEntity(EObject eObject) throws BadTransactionException, BadEntityException {
        if (eObject instanceof EObject) {
            Resource resource;
            Command command;
            EObject eObject2 = eObject;
            if (eObject2.eContainer() != null) {
                String string = String.format("This object has container.%s EntityStore can't have containment elements.", eObject2);
                throw new PermitToAddEntityException(string);
            }
            ResourceSet resourceSet = this.domain.getResourceSet();
            Project project = ProjectManagerAdapter.getRootProject((Notifier)resourceSet);
            if (project.getResources().isEmpty()) {
                LOGGER.warn("The project has no resources, create it for backward compatibility");
                resourceSet.createResource(project.createResourceURI(MODEL_FILENAME), "");
            }
            if ((command = AddCommand.create((EditingDomain)this.domain, (Object)(resource = (Resource)project.getResources().get(0)), null, (Object)eObject2)).canExecute()) {
                command.execute();
            }
            if (logger.isTraceEnabled(changedEntityMarker)) {
                logger.trace("added:{}", eObject.getClass());
            }
        }
    }

    @Deprecated
    public void removeEntity(EObject eObject) throws BadTransactionException {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)this.domain.getResourceSet());
        Resource resource = (Resource)project.getResources().get(0);
        resource.getContents().remove((Object)eObject);
        if (logger.isTraceEnabled(changedEntityMarker)) {
            logger.trace("removed:{}", eObject.getClass());
        }
    }

    @Deprecated
    public boolean contains(EObject eObject) {
        if (!EObjects.isAttachedTo((EditingDomain)this.domain, (EObject)eObject)) {
            return false;
        }
        URI uRI = EcoreUtil.getURI((EObject)eObject);
        return uRI != null && "project".equals(uRI.scheme());
    }

    public void enableTransaction(boolean bl) {
        this.transactionOn = bl;
    }

    public void beginTransaction() throws BadTransactionException {
        try {
            this.domain.startTransaction(false, null);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    public boolean isInTransaction() {
        InternalTransaction internalTransaction = this.domain.getActiveTransaction();
        return internalTransaction != null && internalTransaction.isActive();
    }

    public boolean commitTransaction() throws BadTransactionException {
        try {
            InternalTransaction internalTransaction = this.domain.getActiveTransaction();
            internalTransaction.commit();
            return true;
        }
        catch (RollbackException rollbackException) {
            if (!Transactions.isConstraintViolation((RollbackException)rollbackException)) {
                logger.error("A transaction was automatically rolled back on attempting to commit.", (Throwable)rollbackException);
            }
            return false;
        }
    }

    protected void postCommit(ChangeDescription changeDescription, EntityStoreEvent entityStoreEvent) {
        EMFEntityStoreEdit eMFEntityStoreEdit = new EMFEntityStoreEdit(this, changeDescription);
        if (!this.undoing && !this.redoing && this.transactionOn) {
            if (logger.isTraceEnabled(undoMarker)) {
                logger.trace("undoable event happend. {}", (Object[])entityStoreEvent.getEntityEditUnit());
            }
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, eMFEntityStoreEdit);
            for (UndoableEditListener undoableEditListener : this.undoableEditListeners) {
                undoableEditListener.undoableEditHappened(undoableEditEvent);
            }
        }
        this.undoing = false;
        this.redoing = false;
        if (this.wasEmpty != this.isEmpty()) {
            this.firePropertyChange("empty", this.wasEmpty, !this.wasEmpty);
        }
        this.changedAfterTransactionEvents.put((Transaction)this.domain.getActiveTransaction(), entityStoreEvent);
    }

    private void entityStoreChangedAfterTransaction(EntityStoreEvent entityStoreEvent) {
        try {
            for (EntityChangeListener entityChangeListener : this.entityChangeListeners) {
                entityChangeListener.entityStoreChangedAfterTransaction(entityStoreEvent);
            }
        }
        catch (Exception exception) {
            logger.error("An exception has occurred during processing EntityChangeListener", (Throwable)exception);
        }
    }

    protected void fireEntityStoreChanged(EntityStoreEvent entityStoreEvent) {
        try {
            for (EntityStoreListener entityStoreListener : this.entityStoreListeners) {
                entityStoreListener.entityStoreChanged(entityStoreEvent);
            }
        }
        catch (Exception exception) {
            logger.error("An exception has occurred during processing EntityStoreListener", (Throwable)exception);
        }
    }

    public boolean isEnableReadOnlyElements() {
        return false;
    }

    public void abortTransaction() throws BadTransactionException {
        InternalTransaction internalTransaction = this.domain.getActiveTransaction();
        if (internalTransaction == null || !internalTransaction.isActive()) {
            return;
        }
        internalTransaction.rollback();
    }

    public String getName() {
        return this.documentName;
    }

    @Deprecated
    public void setEntry(String string, EObject eObject) {
        this.root.setEntry(string, eObject);
    }

    @Deprecated
    public EObject getEntry(String string) {
        return this.root.getEntry(string);
    }

    public EObject getEntity(int n) {
        return this.root.getEntity(n);
    }

    public int getId(EObject eObject) {
        return this.root.getId(eObject);
    }

    @Deprecated
    public Iterator<EObject> entityIterator() {
        return this.root.entityIterator();
    }

    public Iterator<String> entryIterator() {
        return this.root.entryIterator();
    }

    public void addEntityStoreListener(EntityStoreListener entityStoreListener) {
        if (!this.entityStoreListeners.contains(Objects.requireNonNull(entityStoreListener, "listener"))) {
            this.entityStoreListeners.add(0, entityStoreListener);
        }
    }

    public void addEntityChangeListener(EntityChangeListener entityChangeListener) {
        if (!this.entityChangeListeners.contains(Objects.requireNonNull(entityChangeListener, "listener"))) {
            this.entityChangeListeners.add(entityChangeListener);
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (!this.undoableEditListeners.contains(Objects.requireNonNull(undoableEditListener, "listener"))) {
            this.undoableEditListeners.add(undoableEditListener);
        }
    }

    public void removeEntityStoreListener(EntityStoreListener entityStoreListener) {
        this.entityStoreListeners.remove(entityStoreListener);
    }

    public void removeEntityChangeListener(EntityChangeListener entityChangeListener) {
        this.entityChangeListeners.remove(entityChangeListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditListeners.remove(undoableEditListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        Objects.requireNonNull(string, "propertyName");
        Objects.requireNonNull(propertyChangeListener, "listener");
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public int size() {
        Iterator<EObject> iterator = this.entityIterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public IEntityRoot getRoot() {
        return this.root;
    }

    public void setRoot(IEntityRoot iEntityRoot) {
        this.root = iEntityRoot;
    }

    public IEntityRoot createEntityRootFromFile(String string) throws ClassNotFoundException, IOException, CancelException, NonCompatibleException {
        this.open(string);
        return this.root;
    }

    public Object getHeaderInfoFromFile(String string) throws ClassNotFoundException, IOException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public void setParentComponent(CComponent cComponent) {
    }

    public void removeAllEntityStoreListenerList() {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public void removeAllEntityChangeListenerList() {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public List<EObject> getAllEntities() {
        return Lists.newArrayList((Iterator)this.root.entityIterator());
    }

    @Deprecated
    public IEntityStoreEdit getCurrentEdit() {
        throw new IllegalStateException("NOT SUPPORTED THIS IMPLEMENTATION");
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null && object != object2) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void setUndoing(boolean bl) {
        this.undoing = bl;
    }

    public void setRedoing(boolean bl) {
        this.redoing = bl;
    }

    public CComponent getParentComponent() {
        return null;
    }

    public Object adapt(Object object, Object object2) {
        ResourceSet resourceSet = this.domain.getResourceSet();
        EList eList = resourceSet.getAdapterFactories();
        for (AdapterFactory adapterFactory : eList) {
            if (!adapterFactory.isFactoryForType(object2)) continue;
            return adapterFactory.adapt(object, object2);
        }
        return null;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public void dispose() {
        if (this.domain != null) {
            try {
                EditingDomainManager.getInstance().deconfigureListeners("net.astah.emf.project", (TransactionalEditingDomain)this.domain);
                this.domain.runExclusive(() -> ResourceSets.dispose((ResourceSet)this.domain.getResourceSet()));
            }
            catch (InterruptedException interruptedException) {
                logger.warn("Interrupted", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
            this.domain.dispose();
        }
    }
}

