/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.astah.golf.model.BadEntityException;
import net.astah.golf.model.IEntityRoot;
import net.astah.project.Facet;
import net.astah.project.IFacetActivator;
import net.astah.project.Project;
import net.astah.project.ProjectFactory;
import net.astah.project.VersionHistory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFEntityRoot
implements IEntityRoot {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFEntityRoot.class);
    private Project project;
    protected Map<String, EObject> entries = new HashMap<String, EObject>();

    public EMFEntityRoot(Project project) {
        this.project = project;
    }

    public void empty() {
        this.project.getResources().forEach(Resource::unload);
    }

    public boolean isEmpty() {
        return this.project.getResources().stream().allMatch(resource -> resource.getContents().isEmpty());
    }

    public void addEntity(EObject eObject) {
        ((Resource)this.project.getResources().get(0)).getContents().add((Object)eObject);
    }

    public void removeEntity(EObject eObject) throws BadEntityException {
        ((Resource)this.project.getResources().get(0)).getContents().remove((Object)eObject);
    }

    public boolean contains(EObject eObject) {
        return ((Resource)this.project.getResources().get(0)).getContents().contains((Object)eObject);
    }

    public void setEntry(String string, EObject eObject) throws BadEntityException {
        EList eList;
        if (!this.contains(eObject)) {
            throw new BadEntityException("No such entity for setting entry");
        }
        if ("ProjectModel".equals(string) && !(eList = this.prepareUMLFacet().getContents()).contains((Object)eObject)) {
            if (eList.isEmpty()) {
                eList.add((Object)eObject);
            } else {
                eList.set(0, (Object)eObject);
            }
        }
        this.entries.put(string, eObject);
    }

    @Deprecated
    protected Facet prepareUMLFacet() {
        Facet facet = this.project.getFacet("net.astah.uml2.uml");
        if (facet != null) {
            return facet;
        }
        LOGGER.warn("The project has no UML facet, create it for backward compatibility");
        facet = ProjectFactory.eINSTANCE.createFacet();
        facet.setSymbolicName("net.astah.uml2.uml");
        Object object = IFacetActivator.Registry.INSTANCE.get((Object)"net.astah.uml2.uml");
        if (object instanceof IFacetActivator.Descriptor) {
            IFacetActivator.Descriptor descriptor = (IFacetActivator.Descriptor)object;
            VersionHistory versionHistory = ProjectFactory.eINSTANCE.createVersionHistory();
            versionHistory.setModelProducer(this.project.getLastModelProducer());
            versionHistory.setModelVersion(descriptor.getVersion());
            versionHistory.setLastModified(this.project.getLastModified());
            facet.setName(descriptor.getName());
            facet.addVersionHistory(versionHistory);
        }
        this.project.getFacets().add((Object)facet);
        return facet;
    }

    public EObject getEntry(String string) {
        Iterator iterator;
        if ("ProjectModel".equals(string)) {
            iterator = this.project.getFacets().iterator();
            while (iterator.hasNext()) {
                Facet facet = (Facet)iterator.next();
                Iterator iterator2 = facet.getContents().iterator();
                if (!iterator2.hasNext()) continue;
                EObject eObject = (EObject)iterator2.next();
                return eObject;
            }
        }
        if ((iterator = this.entries.get(string)) == null) {
            throw new BadEntityException("No such entity for setting entry");
        }
        return iterator;
    }

    public EObject getEntity(int n) {
        for (EObject eObject : ((Resource)this.project.getResources().get(0)).getContents()) {
            EObject eObject2;
            if (!(eObject instanceof EObject) || this.getId(eObject2 = eObject) != n) continue;
            return eObject2;
        }
        return null;
    }

    public int getId(EObject eObject) {
        return System.identityHashCode(eObject);
    }

    public Iterator<EObject> entityIterator() {
        Iterable iterable = Iterables.transform((Iterable)this.project.getResources(), resource -> EcoreUtil.getAllContents((Resource)resource, (boolean)true));
        return Iterators.concat(iterable.iterator());
    }

    public EObject[] getStoreArray() {
        return (EObject[])((Resource)this.project.getResources().get(0)).getContents().toArray((Object[])new EObject[0]);
    }

    public Iterator<String> entryIterator() {
        return this.entries.keySet().iterator();
    }
}

