/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.astah.dd.di.edit.command.SetSizeCommand;
import net.astah.emf.edit.provider.IChangeProcessor;
import net.astah.golf.draw.GNode;
import net.astah.golf.model.IExObserver;
import net.astah.golf.model.Observables;
import net.astah.golf.model.Presentation;
import net.astah.jmodel.ProjectPropertyUtil;
import net.astah.notation.GraphicalShape;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.provider.ProjectProviders;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ChangeObservableTracker
implements IChangeProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeObservableTracker.class);
    private static final Marker MARKER = MarkerFactory.getMarker((String)"notificationDetail");
    protected final Set<Notifier> notifiers = new LinkedHashSet<Notifier>();
    protected final Set<Notifier> notifiedObservables = new HashSet<Notifier>();
    protected final Set<Notifier> followedObservables = new HashSet<Notifier>();
    protected final Map<IExObserver, Notifier> viewObservers = new LinkedHashMap<IExObserver, Notifier>();

    public Command processChange(EditingDomain editingDomain, Collection<?> collection, List<Notification> list) {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)editingDomain.getResourceSet());
        PrecommitCommand precommitCommand = new PrecommitCommand((TransactionalEditingDomain)editingDomain);
        if (list.stream().anyMatch(notification -> this.isPreferencesChange((Notification)notification, project))) {
            for (Resource resource : project.getResources()) {
                TreeIterator treeIterator = resource.getAllContents();
                while (treeIterator.hasNext()) {
                    EObject eObject = (EObject)treeIterator.next();
                    if (eObject instanceof Presentation) {
                        this.addNotifier((Notifier)eObject);
                        continue;
                    }
                    if (!(eObject instanceof GraphicalShape)) continue;
                    precommitCommand = precommitCommand.chain(SetSizeCommand.create((EditingDomain)editingDomain, null, (Object)eObject, (Object)SetSizeCommand.AUTOMATIC_VALUE));
                }
            }
            Iterator iterator = ProjectPropertyUtil.getPreferences();
            if (iterator != null) {
                this.addNotifier((Notifier)iterator);
            }
        } else {
            list.forEach(this::processNotification);
            if (this.notifiers.isEmpty()) {
                return null;
            }
        }
        return precommitCommand;
    }

    public void postcommit() {
        this.notifiedObservables.clear();
        this.followedObservables.clear();
        this.viewObservers.clear();
    }

    public Supplier<Collection<GNode>> updateViewObservers() {
        LinkedHashMap<IExObserver, Notifier> linkedHashMap = new LinkedHashMap<IExObserver, Notifier>(this.viewObservers);
        this.viewObservers.clear();
        return () -> {
            ArrayList arrayList = new ArrayList();
            linkedHashMap.forEach((iExObserver, notifier) -> {
                if (iExObserver instanceof GNode) {
                    arrayList.add((GNode)iExObserver);
                    iExObserver.update(notifier, (Object)0L);
                } else {
                    iExObserver.update(notifier, null);
                }
            });
            this.viewObservers.clear();
            return arrayList;
        };
    }

    protected void addNotifier(Notifier notifier) {
        if (!this.notifiedObservables.contains(notifier) && this.notifiers.add(notifier)) {
            LOGGER.trace(MARKER, "Add changed notifier: {}", (Object)notifier);
        }
    }

    protected void processNotification(Notification notification) {
        Object object;
        if (LOGGER.isTraceEnabled(MARKER)) {
            LOGGER.trace(MARKER, "notification: {}", (Object)notification);
        }
        if ((object = notification instanceof IViewerNotification ? ((IViewerNotification)notification).getElement() : notification.getNotifier()) instanceof Notifier) {
            this.addNotifier((Notifier)object);
        }
    }

    protected boolean isPreferencesChange(Notification notification, Project project) {
        if (notification instanceof IViewerNotification) {
            IViewerNotification iViewerNotification = (IViewerNotification)notification;
            return ProjectProviders.isPreferencesChange((IViewerNotification)iViewerNotification, (EObject)project);
        }
        return false;
    }

    protected class PrecommitCommand
    extends RecordingCommand {
        protected final TransactionalEditingDomain domain;

        public PrecommitCommand(TransactionalEditingDomain transactionalEditingDomain) {
            super(transactionalEditingDomain, "EMFEntityStore Precommit");
            this.domain = transactionalEditingDomain;
        }

        protected void doExecute() {
            try {
                for (Notifier object : new ArrayList<Notifier>(ChangeObservableTracker.this.notifiers)) {
                    if (!(object instanceof IExObserver)) continue;
                    this.notifyObserver((IExObserver)object, object);
                }
                while (!ChangeObservableTracker.this.notifiers.isEmpty()) {
                    ArrayList<Notifier> arrayList = new ArrayList<Notifier>(ChangeObservableTracker.this.notifiers);
                    ChangeObservableTracker.this.notifiers.clear();
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        Notifier notifier = (Notifier)iterator.next();
                        if (!ChangeObservableTracker.this.notifiedObservables.add(notifier)) continue;
                        this.notifyObservers(notifier);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("An exception has occurred during precommit phase", (Throwable)runtimeException);
                throw runtimeException;
            }
        }

        protected void notifyObservers(Notifier notifier) {
            for (IExObserver iExObserver : new ArrayList(Observables.getObservers((Notifier)notifier))) {
                if (Observables.MODEL_PREDICATE.apply((Object)iExObserver)) {
                    this.notifyObserver(iExObserver, notifier);
                    continue;
                }
                ChangeObservableTracker.this.viewObservers.putIfAbsent(iExObserver, notifier);
            }
        }

        protected void notifyObserver(IExObserver iExObserver, Notifier notifier) {
            if (TransactionUtil.getEditingDomain((Object)iExObserver) == this.domain) {
                iExObserver.update(notifier, null);
                this.collectViewObservers(iExObserver);
            }
        }

        protected void collectViewObservers(IExObserver iExObserver) {
            Notifier notifier;
            if (iExObserver instanceof Notifier && ChangeObservableTracker.this.followedObservables.add(notifier = (Notifier)iExObserver)) {
                for (IExObserver iExObserver2 : Observables.getObservers((Notifier)notifier)) {
                    if (Observables.MODEL_PREDICATE.apply((Object)iExObserver2)) {
                        this.collectViewObservers(iExObserver2);
                        continue;
                    }
                    ChangeObservableTracker.this.viewObservers.putIfAbsent(iExObserver2, notifier);
                }
            }
        }
    }
}

