/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CPeerSurfaceData;
import apple.awt.ContainerModel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public class StrategyBufferImage
extends Image {
    ContainerModel fPeer;
    CPeerSurfaceData fSurfaceData;
    int fWidth;
    int fHeight;

    public StrategyBufferImage(ContainerModel containerModel) {
        this.fPeer = containerModel;
        this.fSurfaceData = (CPeerSurfaceData)this.fPeer.getSurface();
        Rectangle rectangle = containerModel.getBounds();
        this.fWidth = rectangle.width;
        this.fHeight = rectangle.height;
    }

    public int getWidth(ImageObserver imageObserver) {
        return this.fWidth;
    }

    public int getHeight(ImageObserver imageObserver) {
        return this.fHeight;
    }

    public ImageProducer getSource() {
        BufferedImage bufferedImage = this.fSurfaceData.copyArea((SunGraphics2D)this.getGraphics(), 0, 0, this.fWidth, this.fHeight, null);
        return bufferedImage.getSource();
    }

    public Graphics getGraphics() {
        Component component = this.fPeer.fTarget;
        return new SunGraphics2D(this.fSurfaceData, component.getForeground(), component.getBackground(), component.getFont());
    }

    public SurfaceData getSurfaceData() {
        return this.fSurfaceData;
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        return UndefinedProperty;
    }

    public void show() {
        this.flush();
        this.fSurfaceData.show();
    }

    public void flush() {
        this.fSurfaceData.finishLazyDrawing();
    }
}

