/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CColorPaint;
import apple.awt.CComponent;
import apple.awt.CGlobalCursorManager;
import apple.awt.CPeerSurfaceData;
import apple.awt.CPrinterSurfaceData;
import apple.awt.CToolkit;
import apple.awt.CWindow;
import apple.awt.OSXVolatileImage;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.PaintEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.reflect.InvocationTargetException;
import sun.awt.RepaintArea;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.TextPipe;

public abstract class ComponentModel
extends CComponent {
    static Font sDefaultFont = new Font("Lucida Grande", 0, 13);
    static Color sDefaultFColor = Color.black;
    static Color sDefaultBColor = Color.white;
    boolean isLayouting = false;
    boolean paintPending = false;
    int oldWidth = -1;
    int oldHeight = -1;
    protected RepaintArea paintArea;
    protected GraphicsConfiguration fGraphicsConfiguration;
    protected long fModelPtr;
    long fNSView;
    protected SurfaceData fSurfaceData;
    Color fLastFColor = null;
    Color fLastBColor = null;
    final Runnable doCocoaPaint = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SurfaceData surfaceData = ComponentModel.this.getSurface();
            if (surfaceData != null && surfaceData instanceof CPeerSurfaceData) {
                CPeerSurfaceData cPeerSurfaceData = (CPeerSurfaceData)surfaceData;
                Object object = cPeerSurfaceData.getLockObject();
                synchronized (object) {
                    cPeerSurfaceData.canDrawDuringLiveResize(true);
                    cPeerSurfaceData.disableFlushing();
                    try {
                        ComponentModel.this.fTarget.update(ComponentModel.this.getGraphics());
                    }
                    finally {
                        cPeerSurfaceData.enableFlushing();
                        cPeerSurfaceData.canDrawDuringLiveResize(false);
                    }
                }
            }
        }
    };
    long fPrintingContext;
    final Runnable doCocoaPrinting = new Runnable(){

        public void run() {
            ComponentModel.this.fTarget.update(ComponentModel.this.getCocoaPrintingGraphics(ComponentModel.this.fPrintingContext));
        }
    };

    public ComponentModel(Component component) {
        this.fTarget = component;
        this.fGraphicsConfiguration = this.fTarget.getGraphicsConfiguration();
        this.paintArea = new RepaintArea();
    }

    protected void initPeer() {
        long l = this.initZOrderPosition();
        this.fModelPtr = this.initPeer(ComponentModel.findParentModel(this.fTarget), l);
    }

    protected abstract long initPeer(long var1, long var3);

    protected void disposeImpl() {
        CToolkit.targetDisposedPeer(this.fTarget, this);
        long l = this.fModelPtr;
        this.fModelPtr = 0L;
        this._disposeImpl(l);
    }

    private native void _disposeImpl(long var1);

    static long findParentModel(Component component) {
        for (component = component.getParent(); component != null; component = component.getParent()) {
            ComponentPeer componentPeer = component.getPeer();
            if (!(componentPeer instanceof ComponentModel)) continue;
            return ((ComponentModel)componentPeer).fModelPtr;
        }
        return 0L;
    }

    long getModelPtr() {
        return this.fModelPtr;
    }

    public long initZOrderPosition() {
        Container container = this.fTarget.getParent();
        ComponentModel componentModel = null;
        if (container != null) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length && componentArray[i] != this.fTarget; ++i) {
                Object object = CToolkit.targetToPeer(componentArray[i]);
                if (object == null || object instanceof LightweightPeer) continue;
                componentModel = (ComponentModel)object;
            }
        }
        long l = 0L;
        if (componentModel != null) {
            l = componentModel.getModelPtr();
        }
        return l;
    }

    public final GraphicsConfiguration getGraphicsConfiguration() {
        return this.fGraphicsConfiguration;
    }

    public final VolatileImage createVolatileImage(int n, int n2) {
        return new OSXVolatileImage(this.fTarget, n, n2);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.fTarget.getSize();
            this.oldHeight = dimension.height;
            this.oldWidth = dimension.width;
        }
        this._setVisible(this.fModelPtr, bl);
    }

    protected native void _setVisible(long var1, boolean var3);

    public void setEnabled(boolean bl) {
        this._setEnabled(this.fModelPtr, bl);
    }

    private native void _setEnabled(long var1, boolean var3);

    public void setBounds(int n, int n2, int n3, int n4) {
        this.paintPending = n3 != this.oldWidth || n4 != this.oldHeight;
        this._setBounds(this.fModelPtr, n, n2, n3, n4);
        if (n3 != this.oldWidth || n4 != this.oldHeight) {
            this.oldWidth = n3;
            this.oldHeight = n4;
        }
    }

    private native void _setBounds(long var1, int var3, int var4, int var5, int var6);

    public void updateCursorImmediately() {
        CGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    public Point getLocationOnScreen() {
        CWindow cWindow = this.getCWindowContainer();
        Point point = cWindow.getLocationOnScreen();
        Component component = this.fTarget;
        while (component.getPeer() != cWindow) {
            Rectangle rectangle = component.getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            component = component.getParent();
        }
        return point;
    }

    public void setForeground(Color color) {
        boolean bl = false;
        if (this.fLastFColor == null && color != null) {
            bl = true;
        } else if (color instanceof CColorPaint || color instanceof SystemColor) {
            if (this.fLastFColor != color) {
                bl = true;
            }
        } else if (color instanceof Color) {
            if (this.fLastFColor.getRGB() != color.getRGB()) {
                bl = true;
            }
        } else if (this.fLastFColor != color) {
            bl = true;
        }
        if (bl) {
            this.fLastFColor = color;
            this._setForeground(this.fModelPtr, color);
        }
    }

    public void setBackground(Color color) {
        boolean bl = false;
        if (this.fLastBColor == null && color != null) {
            bl = true;
        } else if (color instanceof CColorPaint || color instanceof SystemColor) {
            if (this.fLastBColor != color) {
                bl = true;
            }
        } else if (color instanceof Color) {
            if (this.fLastBColor.getRGB() != color.getRGB()) {
                bl = true;
            }
        } else if (this.fLastBColor != color) {
            bl = true;
        }
        if (bl) {
            this.fLastBColor = color;
            this._setBackground(this.fModelPtr, color);
        }
    }

    private native void _setForeground(long var1, Color var3);

    private native void _setBackground(long var1, Color var3);

    public void setFont(Font font) {
        this._setFont(this.fModelPtr, font);
    }

    private native void _setFont(long var1, Font var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 102: {
                this.fTarget.repaint();
                try {
                    this.getCWindowContainer().disableFlushing();
                    this.paintArea.add(this.getBounds(), 801);
                    this.paintArea.paint(this.fTarget, this.shouldClearRectBeforePaint());
                    break;
                }
                finally {
                    this.finishLazyDrawing();
                    this.getCWindowContainer().enableFlushing();
                }
            }
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (this.isLayouting || this.paintPending) break;
                try {
                    this.getCWindowContainer().disableFlushing();
                    this.paintArea.paint(this.fTarget, this.shouldClearRectBeforePaint());
                    break;
                }
                finally {
                    this.finishLazyDrawing();
                    this.getCWindowContainer().enableFlushing();
                }
            }
            default: {
                this._handleEvent(this.fModelPtr, aWTEvent);
            }
        }
    }

    private native void _handleEvent(long var1, AWTEvent var3);

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintArea.isEmpty() || this.paintPending || this.fTarget.getIgnoreRepaint())) {
            this.postEvent(new PaintEvent(this.fTarget, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    public final void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.paintArea.add(rectangle, paintEvent.getID());
    }

    void handlePaint(boolean bl, int n, int n2, int n3, int n4) {
        if (!this.fTarget.getIgnoreRepaint()) {
            this.paintPending = true;
            if (bl) {
                try {
                    CToolkit.invokeAndWait(this.doCocoaPaint, this.fTarget);
                    this.paintPending = false;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            } else {
                this.postEvent(new PaintEvent(this.fTarget, 800, new Rectangle(n, n2, n3, n4)));
            }
        }
    }

    void handlePrinting(long l, int n, int n2, int n3, int n4) {
        this.fPrintingContext = l;
        try {
            CToolkit.invokeAndWait(this.doCocoaPrinting, this.fTarget);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void finishLazyDrawing() {
        if (this.fSurfaceData != null) {
            this.fSurfaceData.finishLazyDrawing();
        }
    }

    protected Rectangle getSurfaceBounds() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    public long getViewPtr() {
        if (this.fNSView <= 0L) {
            this.fNSView = this._getViewPtr(this.fModelPtr);
        }
        return this.fNSView;
    }

    private native long _getViewPtr(long var1);

    public synchronized Graphics getGraphicsForSurface(SurfaceData surfaceData) {
        Font font = this.fTarget.getFont();
        Color color = this.fTarget.getForeground();
        Color color2 = this.fTarget.getBackground();
        SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData, color != null ? color : sDefaultFColor, color2 != null ? color2 : sDefaultBColor, font != null ? font : sDefaultFont);
        return sunGraphics2D;
    }

    public synchronized Graphics getGraphics() {
        return this.getGraphicsForSurface(this.getSurface());
    }

    public synchronized SurfaceData getSurface() {
        if (this.fSurfaceData == null) {
            this.fSurfaceData = this.getViewPtr() > 0L ? CPeerSurfaceData.createData(this, this.getSurfaceBounds()) : new TemporarySurfaceData(this);
        } else {
            Rectangle rectangle = this.getSurfaceBounds();
            Rectangle rectangle2 = this.fSurfaceData.getBounds();
            if (rectangle.width != rectangle2.width || rectangle.height != rectangle2.height) {
                this.fSurfaceData = this.fSurfaceData.getReplacement();
            }
        }
        return this.fSurfaceData;
    }

    public synchronized Graphics getCocoaPrintingGraphics(long l) {
        return this.getGraphicsForSurface(this.getCocoaPrintingSurface(l));
    }

    public synchronized SurfaceData getCocoaPrintingSurface(long l) {
        return new CPrinterSurfaceData(this.getGraphicsConfiguration(), l);
    }

    class TemporarySurfaceData
    extends SurfaceData {
        private ComponentModel model;

        private TemporarySurfaceData(ComponentModel componentModel2) {
            super(SurfaceType.Any, ColorModel.getRGBdefault());
            this.model = componentModel2;
        }

        public void invalidate() {
        }

        public SurfaceData getReplacement() {
            if (this.model.getViewPtr() > 0L) {
                return CPeerSurfaceData.createData(this.model, ComponentModel.this.getSurfaceBounds());
            }
            return this;
        }

        public void validatePipe(SunGraphics2D sunGraphics2D) {
            TempPipe tempPipe = new TempPipe(this.model);
            sunGraphics2D.drawpipe = tempPipe;
            sunGraphics2D.fillpipe = tempPipe;
            sunGraphics2D.shapepipe = tempPipe;
            sunGraphics2D.textpipe = tempPipe;
            sunGraphics2D.imagepipe = tempPipe;
        }

        public void lock() throws InvalidPipeException {
        }

        public void unlock() {
        }

        public GraphicsConfiguration getDeviceConfiguration() {
            return null;
        }

        public Raster getRaster(int n, int n2, int n3, int n4) {
            throw new InternalError("obsolete interface used");
        }

        public boolean useTightBBoxes() {
            return false;
        }

        public int pixelFor(int n) {
            return n;
        }

        public int rgbFor(int n) {
            return n;
        }

        public Rectangle getBounds() {
            return new Rectangle();
        }

        protected void checkCustomComposite() {
        }

        public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            return true;
        }
    }

    class TempPipe
    implements PixelDrawPipe,
    PixelFillPipe,
    ShapeDrawPipe,
    TextPipe,
    DrawImagePipe {
        private ComponentModel model;

        public TempPipe(ComponentModel componentModel2) {
            this.model = componentModel2;
        }

        void validate() {
            if (this.model.getViewPtr() > 0L) {
                throw new InvalidPipeException();
            }
        }

        public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            this.validate();
        }

        public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            this.validate();
        }

        public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            this.validate();
        }

        public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            this.validate();
        }

        public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
            this.validate();
        }

        public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
            this.validate();
        }

        public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
            this.validate();
        }

        public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
            this.validate();
        }

        public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
            this.validate();
        }

        public void drawString(SunGraphics2D sunGraphics2D, String string, double d, double d2) {
            this.validate();
        }

        public void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
            this.validate();
        }

        public void drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4) {
            this.validate();
        }

        public void drawBytes(SunGraphics2D sunGraphics2D, byte[] byArray, int n, int n2, int n3, int n4) {
            this.validate();
        }

        public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
            this.validate();
        }
    }
}

