/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CButton;
import apple.awt.CCanvas;
import apple.awt.CCheckbox;
import apple.awt.CCheckboxMenuItem;
import apple.awt.CChoice;
import apple.awt.CClipboard;
import apple.awt.CComponent;
import apple.awt.CCustomCursor;
import apple.awt.CDragSourceContextPeer;
import apple.awt.CEmbedded;
import apple.awt.CEmbeddedFrame;
import apple.awt.CFileDialog;
import apple.awt.CFrame;
import apple.awt.CGraphicsDevice;
import apple.awt.CGraphicsEnvironment;
import apple.awt.CInputMethod;
import apple.awt.CInputMethodDescriptor;
import apple.awt.CLabel;
import apple.awt.CList;
import apple.awt.CMenu;
import apple.awt.CMenuBar;
import apple.awt.CMenuItem;
import apple.awt.CMouseDragGestureRecognizer;
import apple.awt.CPanel;
import apple.awt.CPeerSurfaceData;
import apple.awt.CPopupMenu;
import apple.awt.CPrintJob2D;
import apple.awt.CPrinterDialog;
import apple.awt.CPrinterDialogPeer;
import apple.awt.CRobot;
import apple.awt.CScrollPane;
import apple.awt.CScrollbar;
import apple.awt.CTextArea;
import apple.awt.CTextField;
import apple.awt.CWindow;
import apple.awt.OSXImage;
import apple.awt.RuntimeOptions;
import com.apple.eawt.CocoaComponent;
import com.sun.imageio.plugins.tiff.TIFFImageReaderSpi;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.SunToolkitSubclass;
import sun.awt.font.FontDesignMetrics;
import sun.awt.image.ImageRepresentation;

public class CToolkit
extends SunToolkit {
    private static LookAndFeelChangeListener sLAFListener;
    static FontMetrics[] lastMetrics;
    static FontRenderContext sDefaultFrc;
    protected static CToolkit sToolkit;
    protected static CInputMethodDescriptor sInputMethodDescriptor;
    private static Object sInitLock;
    public static final String DATA_TRANSFERER_CLASS_NAME = "apple.awt.CDataTransferer";
    private static long sMessageNumber;
    static Clipboard sClipboard;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CToolkit() {
        Object object = sInitLock;
        synchronized (object) {
            if (sToolkit == null) {
                sToolkit = this;
            }
            if (CToolkit.getSystemProperty("sun.awt.exception.handler", null) == null) {
                CToolkit.setSystemProperty("sun.awt.exception.handler", EventQueueExceptionHandler.class.getName());
            }
            SunToolkit.setDataTransfererClassName((String)DATA_TRANSFERER_CLASS_NAME);
            this.init();
        }
        this.registerDefaultServices();
    }

    public static void notImplemented() {
        Thread.dumpStack();
    }

    private native void init();

    protected native void loadSystemColors(int[] var1);

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public static boolean allowKeyboardNavigation() {
        return true;
    }

    public static native int getCFPreferencesNumber(String var0, int var1, int var2);

    static String getSystemProperty(final String string, final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string, string2);
            }
        });
    }

    static String setSystemProperty(final String string, final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.setProperty(string, string2);
            }
        });
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.equals("awt.dynamicLayoutSupported")) {
            return new Boolean(true);
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    static boolean isHeadless() {
        String string = CToolkit.getSystemProperty("java.awt.headless", "false");
        return string.equals("true");
    }

    public int getMenuShortcutKeyMask() {
        return 4;
    }

    public Dimension getBestCursorSize(int n, int n2) throws HeadlessException {
        return CCustomCursor.getBestCursorSize(n, n2);
    }

    public int getMaximumCursorColors() throws HeadlessException {
        return Integer.MAX_VALUE;
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException, HeadlessException {
        return new CCustomCursor(image, point, string);
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createScrollbar")) {
            throw new AssertionError();
        }
        CScrollbar cScrollbar = CScrollbar.create(scrollbar);
        CToolkit.targetCreatedPeer(scrollbar, cScrollbar);
        return cScrollbar;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createTextArea")) {
            throw new AssertionError();
        }
        CTextArea cTextArea = CTextArea.create(textArea);
        CToolkit.targetCreatedPeer(textArea, cTextArea);
        return cTextArea;
    }

    public ButtonPeer createButton(Button button) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createButton")) {
            throw new AssertionError();
        }
        CButton cButton = CButton.create(button);
        CToolkit.targetCreatedPeer(button, cButton);
        return cButton;
    }

    public ChoicePeer createChoice(Choice choice) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createChoice")) {
            throw new AssertionError();
        }
        CChoice cChoice = CChoice.create(choice);
        CToolkit.targetCreatedPeer(choice, cChoice);
        return cChoice;
    }

    public PanelPeer createPanel(Panel panel) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createPanel")) {
            throw new AssertionError();
        }
        CPanel cPanel = CPanel.create(panel);
        CToolkit.targetCreatedPeer(panel, cPanel);
        return cPanel;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createCanvas")) {
            throw new AssertionError();
        }
        long l = canvas instanceof CocoaComponent ? ((CocoaComponent)canvas).createNSViewLong() : 0L;
        CCanvas cCanvas = CCanvas.create(canvas, l);
        CToolkit.targetCreatedPeer(canvas, cCanvas);
        return cCanvas;
    }

    public static void sendMessage(CocoaComponent cocoaComponent, int n, Object object) {
        CToolkit.sendMessage(((CCanvas)cocoaComponent.getPeer()).fInnerView, n, object);
    }

    static native void sendMessage(long var0, int var2, Object var3);

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createScrollPane")) {
            throw new AssertionError();
        }
        CScrollPane cScrollPane = CScrollPane.create(scrollPane);
        CToolkit.targetCreatedPeer(scrollPane, cScrollPane);
        return cScrollPane;
    }

    public TextFieldPeer createTextField(TextField textField) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createTextField")) {
            throw new AssertionError();
        }
        CTextField cTextField = CTextField.create(textField);
        CToolkit.targetCreatedPeer(textField, cTextField);
        return cTextField;
    }

    public LabelPeer createLabel(Label label) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createLabel")) {
            throw new AssertionError();
        }
        CLabel cLabel = CLabel.create(label);
        CToolkit.targetCreatedPeer(label, cLabel);
        return cLabel;
    }

    public ListPeer createList(List list) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createList")) {
            throw new AssertionError();
        }
        CList cList = CList.create(list);
        CToolkit.targetCreatedPeer(list, cList);
        return cList;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createCheckbox")) {
            throw new AssertionError();
        }
        CCheckbox cCheckbox = CCheckbox.create(checkbox);
        CToolkit.targetCreatedPeer(checkbox, cCheckbox);
        return cCheckbox;
    }

    public FramePeer createFrame(Frame frame) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createFrame")) {
            throw new AssertionError();
        }
        CFrame cFrame = CFrame.create(frame);
        CToolkit.targetCreatedPeer(frame, cFrame);
        return cFrame;
    }

    public CEmbedded createEmbeddedFrame(CEmbeddedFrame cEmbeddedFrame) {
        CEmbedded cEmbedded = CEmbedded.create(cEmbeddedFrame);
        CToolkit.targetCreatedPeer(cEmbeddedFrame, cEmbedded);
        return cEmbedded;
    }

    public WindowPeer createWindow(Window window) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createWindow")) {
            throw new AssertionError();
        }
        CWindow cWindow = CWindow.create(window);
        CToolkit.targetCreatedPeer(window, cWindow);
        return cWindow;
    }

    public DialogPeer createDialog(Dialog dialog) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createDialog")) {
            throw new AssertionError();
        }
        if (dialog instanceof CPrinterDialog) {
            return this.createCPrinterDialog((CPrinterDialog)dialog);
        }
        CFrame cFrame = CFrame.create(dialog);
        CToolkit.targetCreatedPeer(dialog, cFrame);
        return cFrame;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createFileDialog")) {
            throw new AssertionError();
        }
        CFileDialog cFileDialog = new CFileDialog(fileDialog);
        CToolkit.targetCreatedPeer(fileDialog, cFileDialog);
        return cFileDialog;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createMenuBar")) {
            throw new AssertionError();
        }
        CMenuBar cMenuBar = new CMenuBar(menuBar);
        CToolkit.targetCreatedPeer(menuBar, cMenuBar);
        return cMenuBar;
    }

    public MenuPeer createMenu(Menu menu) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createMenu")) {
            throw new AssertionError();
        }
        CMenu cMenu = new CMenu(menu);
        CToolkit.targetCreatedPeer(menu, cMenu);
        return cMenu;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createPopupMenu")) {
            throw new AssertionError();
        }
        CPopupMenu cPopupMenu = new CPopupMenu(popupMenu);
        CToolkit.targetCreatedPeer(popupMenu, cPopupMenu);
        return cPopupMenu;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createMenuItem")) {
            throw new AssertionError();
        }
        CMenuItem cMenuItem = new CMenuItem(menuItem);
        CToolkit.targetCreatedPeer(menuItem, cMenuItem);
        return cMenuItem;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.createCheckboxMenuItem")) {
            throw new AssertionError();
        }
        CCheckboxMenuItem cCheckboxMenuItem = new CCheckboxMenuItem(checkboxMenuItem);
        CToolkit.targetCreatedPeer(checkboxMenuItem, cCheckboxMenuItem);
        return cCheckboxMenuItem;
    }

    public FontPeer getFontPeer(String string, int n) {
        CToolkit.notImplemented();
        return null;
    }

    CPrinterDialogPeer createCPrinterDialog(CPrinterDialog cPrinterDialog) {
        CPrinterDialogPeer cPrinterDialogPeer = new CPrinterDialogPeer(cPrinterDialog);
        CToolkit.targetCreatedPeer(cPrinterDialog, cPrinterDialogPeer);
        return cPrinterDialogPeer;
    }

    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
        this.desktopProperties.put("DnD.isDragImageSupported", new Boolean(true));
        this.desktopProperties.put("DnD.Cursor.CopyDrop", new NamedCursor("DnD.Cursor.CopyDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveDrop", new NamedCursor("DnD.Cursor.MoveDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkDrop", new NamedCursor("DnD.Cursor.LinkDrop"));
        this.desktopProperties.put("DnD.Cursor.CopyNoDrop", new NamedCursor("DnD.Cursor.CopyNoDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveNoDrop", new NamedCursor("DnD.Cursor.MoveNoDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkNoDrop", new NamedCursor("DnD.Cursor.LinkNoDrop"));
    }

    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new CRobot(robot, (CGraphicsDevice)graphicsDevice);
    }

    public int getScreenWidth() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        return rectangle.width;
    }

    public int getScreenHeight() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        return rectangle.height;
    }

    public int getScreenResolution() {
        return ((CGraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()).getScreenResolution();
    }

    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) throws HeadlessException {
        return ((CGraphicsDevice)graphicsConfiguration.getDevice()).getScreenInsets();
    }

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        CDragSourceContextPeer cDragSourceContextPeer = CDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
        return cDragSourceContextPeer;
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        CMouseDragGestureRecognizer cMouseDragGestureRecognizer = null;
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            cMouseDragGestureRecognizer = new CMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return cMouseDragGestureRecognizer;
    }

    public ColorModel getColorModel() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
    }

    public void sync() {
        CPeerSurfaceData.finishLazyDrawingForAllSurfaces();
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof OSXImage) {
            OSXImage oSXImage = (OSXImage)((Object)image);
            if (n == 0 || n2 == 0) {
                return true;
            }
            if (oSXImage.hasError()) {
                if (imageObserver != null) {
                    imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
                }
                return false;
            }
            ImageRepresentation imageRepresentation = oSXImage.getImageRep();
            return imageRepresentation.prepare(imageObserver);
        }
        return true;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof OSXImage) {
            OSXImage oSXImage = (OSXImage)((Object)image);
            int n3 = n == 0 || n2 == 0 ? 32 : oSXImage.getImageRep().check(imageObserver);
            return oSXImage.check(imageObserver) | n3;
        }
        return 32;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new OSXImage(imageProducer);
    }

    public native void beep();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clipboard getSystemClipboard() {
        if (!$assertionsDisabled && !CToolkit.stdio("CToolkit.getSystemClipboard")) {
            throw new AssertionError();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        Object object = sInitLock;
        synchronized (object) {
            if (sClipboard == null) {
                sClipboard = new CClipboard();
            }
        }
        return sClipboard;
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return this.getPrintJob(frame, string, null, null);
    }

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        CPrintJob2D cPrintJob2D = new CPrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!cPrintJob2D.printDialog()) {
            cPrintJob2D = null;
        }
        return cPrintJob2D;
    }

    public Locale getDefaultKeyboardLocale() {
        Locale locale = CInputMethod.getNativeLocale();
        if (locale == null) {
            return super.getDefaultKeyboardLocale();
        }
        return locale;
    }

    public InputMethodDescriptor getInputMethodAdapterDescriptor() {
        if (sInputMethodDescriptor == null) {
            sInputMethodDescriptor = new CInputMethodDescriptor();
        }
        return sInputMethodDescriptor;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return CInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    public boolean isFrameStateSupported(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static void postEvent(CComponent cComponent, AWTEvent aWTEvent) {
        CToolkit.postEvent(CToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    public static void postEvent(AWTEvent aWTEvent) {
        CToolkit.postEvent(CToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    public static void invokeAndWait(Runnable runnable, Component component) throws InterruptedException, InvocationTargetException {
        CToolkit.invokeAndWait(runnable, component, true);
    }

    public static void invokeAndWait(Runnable runnable, Component component, boolean bl) throws InterruptedException, InvocationTargetException {
        Object object;
        long l = CToolkit.createAWTRunLoopMediator();
        CPeerEvent cPeerEvent = new CPeerEvent(runnable, l);
        if (component != null) {
            object = SunToolkit.targetToAppContext(component);
            SunToolkit.postEvent((AppContext)object, cPeerEvent);
            SunToolkitSubclass.flushPendingEvents((AppContext)object);
        } else {
            ((CToolkit)Toolkit.getDefaultToolkit()).getSystemEventQueueForInvokeAndWait().postEvent(cPeerEvent);
        }
        CToolkit.doAWTRunLoop(l, true, bl);
        object = cPeerEvent.getException();
        if (object != null) {
            if (object instanceof UndeclaredThrowableException) {
                object = ((UndeclaredThrowableException)object).getUndeclaredThrowable();
            }
            throw new InvocationTargetException((Throwable)object);
        }
    }

    public static void invokeLater(Runnable runnable, Component component) throws InvocationTargetException {
        Object object;
        CPeerEvent cPeerEvent = new CPeerEvent(runnable, 0L);
        if (component != null) {
            object = SunToolkit.targetToAppContext(component);
            SunToolkit.postEvent((AppContext)object, cPeerEvent);
            SunToolkitSubclass.flushPendingEvents((AppContext)object);
        } else {
            ((CToolkit)Toolkit.getDefaultToolkit()).getSystemEventQueueForInvokeAndWait().postEvent(cPeerEvent);
        }
        object = cPeerEvent.getException();
        if (object != null) {
            if (object instanceof UndeclaredThrowableException) {
                object = ((UndeclaredThrowableException)object).getUndeclaredThrowable();
            }
            throw new InvocationTargetException((Throwable)object);
        }
    }

    EventQueue getSystemEventQueueForInvokeAndWait() {
        return this.getSystemEventQueueImpl();
    }

    public static native long createAWTRunLoopMediator();

    public static void doAWTRunLoop(long l, boolean bl) {
        CToolkit.doAWTRunLoop(l, bl, true);
    }

    public static native void doAWTRunLoop(long var0, boolean var2, boolean var3);

    public static void doAWTRunLoop(long l) {
        CToolkit.doAWTRunLoop(l, true);
    }

    public static native void stopAWTRunLoop(long var0);

    private static void dumpObject(Object object) {
        if (object != null) {
            System.err.println("Printing object of type : " + object.getClass());
            System.err.println(object.toString());
        } else {
            System.err.println("Printing object of type : <null>");
        }
    }

    public String[] getFontList() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FontRenderContext createDefaultFrcUsingRuntimeOptions() {
        LookAndFeelChangeListener lookAndFeelChangeListener = sLAFListener;
        synchronized (lookAndFeelChangeListener) {
            if (sDefaultFrc == null) {
                AffineTransform affineTransform = GraphicsEnvironment.isHeadless() ? new AffineTransform() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                RuntimeOptions runtimeOptions = RuntimeOptions.getCurrentOptions();
                sDefaultFrc = new FontRenderContext(affineTransform, runtimeOptions.TextAntialiasing == 2, runtimeOptions.FractionalMetrics == 2);
            }
            return sDefaultFrc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getFontMetrics(Font font) {
        LookAndFeelChangeListener lookAndFeelChangeListener = sLAFListener;
        synchronized (lookAndFeelChangeListener) {
            FontMetrics fontMetrics;
            for (int i = 0; i < lastMetrics.length && (fontMetrics = lastMetrics[i]) != null; ++i) {
                if (fontMetrics.getFont() != font) continue;
                return fontMetrics;
            }
            FontDesignMetrics fontDesignMetrics = new FontDesignMetrics(font, CToolkit.createDefaultFrcUsingRuntimeOptions());
            System.arraycopy(lastMetrics, 0, lastMetrics, 1, lastMetrics.length - 1);
            CToolkit.lastMetrics[0] = fontDesignMetrics;
            return fontDesignMetrics;
        }
    }

    void registerDefaultServices() {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        iIORegistry.registerServiceProvider(new TIFFImageReaderSpi(), ImageReaderSpi.class);
    }

    void screenParametersChanged() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CGraphicsEnvironment cGraphicsEnvironment = (CGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
                cGraphicsEnvironment.displayChanged();
                cGraphicsEnvironment.paletteChanged();
            }
        });
    }

    static boolean stdio(String string) {
        System.out.println("[AWT-" + sMessageNumber++ + "]:" + string);
        return true;
    }

    static boolean stderr(String string) {
        System.err.println("[AWT-" + sMessageNumber++ + "]:" + string);
        return true;
    }

    static {
        $assertionsDisabled = !CToolkit.class.desiredAssertionStatus();
        sLAFListener = new LookAndFeelChangeListener();
        lastMetrics = new FontMetrics[5];
        sDefaultFrc = null;
        sInitLock = new Object();
        sMessageNumber = 0L;
        sClipboard = null;
    }

    public static class CPeerEvent
    extends PeerEvent {
        private long _mediator = 0L;

        public CPeerEvent(Runnable runnable, long l) {
            super((Object)Toolkit.getDefaultToolkit(), runnable, null, true, 0L);
            this._mediator = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            try {
                super.dispatch();
            }
            finally {
                if (this._mediator != 0L) {
                    CToolkit.stopAWTRunLoop(this._mediator);
                }
            }
        }
    }

    public static class EventQueueExceptionHandler {
        static final /* synthetic */ boolean $assertionsDisabled;

        public void handle(Throwable throwable) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            System.err.println("apple.awt.EventQueueExceptionHandler Caught Throwable : " + throwable);
            throwable.printStackTrace();
        }

        static {
            $assertionsDisabled = !(class$apple$awt$CToolkit == null ? (class$apple$awt$CToolkit = CToolkit.class$("apple.awt.CToolkit")) : class$apple$awt$CToolkit).desiredAssertionStatus();
        }
    }

    static class NamedCursor
    extends Cursor {
        NamedCursor(String string) {
            super(string);
        }
    }

    static class LookAndFeelChangeListener
    implements PropertyChangeListener {
        public LookAndFeelChangeListener() {
            RuntimeOptions.getCurrentOptions().addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("apple.awt.RuntimeOptions")) {
                LookAndFeelChangeListener lookAndFeelChangeListener = this;
                synchronized (lookAndFeelChangeListener) {
                    sDefaultFrc = null;
                    lastMetrics = new FontMetrics[5];
                }
            }
        }
    }
}

