/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsDevice;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.peer.RobotPeer;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class CRobot
implements RobotPeer {
    static final int MOUSE_LOCATION_UNKNOWN = -1;
    static final int BUTTON_STATE_UNKNOWN = 0;
    static final int BUTTON_STATE_DOWN = 1;
    static final int BUTTON_STATE_UP = 2;
    static final int MODIFIER_PREVIOUSLY_UNKNOWN = 0;
    static final int MODIFIER_PREVIOUSLY_UP = 1;
    static final int MODIFIER_PREVIOUSLY_DOWN = 2;
    Robot fRobot;
    CGraphicsDevice fDevice;
    int fMouseLastX = -1;
    int fMouseLastY = -1;
    int fMouse1DesiredState = 0;
    int fMouse2DesiredState = 0;
    int fMouse3DesiredState = 0;
    int fMouse2KeyModifierState = 0;
    int fMouse3KeyModifierState = 0;
    boolean fMouseMoveAction;

    public CRobot(Robot robot, CGraphicsDevice cGraphicsDevice) {
        this.fRobot = robot;
        this.fDevice = cGraphicsDevice;
        this.initRobot();
    }

    private native void initRobot();

    public void mouseMove(int n, int n2) {
        this.fMouseLastX = n;
        this.fMouseLastY = n2;
        this.fMouseMoveAction = true;
        this.mouseEvent(this.fDevice, this.fMouseLastX, this.fMouseLastY, this.fMouse1DesiredState, this.fMouse2DesiredState, this.fMouse3DesiredState, this.fMouseMoveAction);
    }

    public void mousePress(int n) {
        this.fMouse1DesiredState = (n & 0x10) != 0 ? 1 : 0;
        this.fMouse2DesiredState = (n & 8) != 0 ? 1 : 0;
        this.fMouse3DesiredState = (n & 4) != 0 ? 1 : 0;
        this.fMouseMoveAction = false;
        this.mouseEvent(this.fDevice, this.fMouseLastX, this.fMouseLastY, this.fMouse1DesiredState, this.fMouse2DesiredState, this.fMouse3DesiredState, this.fMouseMoveAction);
    }

    public void mouseRelease(int n) {
        this.fMouse1DesiredState = (n & 0x10) != 0 ? 2 : 0;
        this.fMouse2DesiredState = (n & 8) != 0 ? 2 : 0;
        this.fMouse3DesiredState = (n & 4) != 0 ? 2 : 0;
        this.fMouseMoveAction = false;
        this.mouseEvent(this.fDevice, this.fMouseLastX, this.fMouseLastY, this.fMouse1DesiredState, this.fMouse2DesiredState, this.fMouse3DesiredState, this.fMouseMoveAction);
    }

    private native void mouseEvent(CGraphicsDevice var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    public native void mouseWheel(int var1);

    public void keyPress(int n) {
        this.keyEvent(n, true);
    }

    public void keyRelease(int n) {
        this.keyEvent(n, false);
    }

    private native void keyEvent(int var1, boolean var2);

    public int getRGBPixel(int n, int n2) {
        int[] nArray = new int[1];
        this.getScreenPixels(this.fDevice, new Rectangle(n, n2, 1, 1), nArray);
        return nArray[0];
    }

    public int[] getRGBPixels(Rectangle rectangle) {
        int[] nArray = new int[rectangle.width * rectangle.height];
        this.getScreenPixels(this.fDevice, rectangle, nArray);
        return nArray;
    }

    private native void getScreenPixels(CGraphicsDevice var1, Rectangle var2, int[] var3);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

