/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CPrinterGraphics;
import apple.awt.CPrinterJobDialog;
import apple.awt.CPrinterPageDialog;
import apple.awt.CPrinterSurfaceData;
import apple.awt.CToolkit;
import apple.awt.EventDispatchAccess;
import apple.awt.NSPrintInfo;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.print.PeekGraphics;
import sun.print.RasterPrinterJob;
import sun.print.SunPrinterJobService;

public class CPrinterJob
extends RasterPrinterJob {
    private static String sShouldNotReachHere = "Should not reach here.";
    private boolean noDefaultPrinter = false;
    private static Font defaultFont;
    private long fNSPrintInfo = -1L;
    private Object fNSPrintInfoLock = new Object();
    Object waitLock = new Object();
    Object postLock = new Object();
    Runnable runnable = null;
    volatile boolean onEventThread;

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return false;
        }
        return this.jobSetup(this.getPageable(), this.checkAllowedToPrintToFile());
    }

    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.noDefaultPrinter) {
            return pageFormat;
        }
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        boolean bl = this.pageSetup(pageFormat2, null);
        return bl ? pageFormat2 : pageFormat;
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        this.getDefaultPage(pageFormat2);
        return pageFormat2;
    }

    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        super.setAttributes(printRequestAttributeSet);
        if (printRequestAttributeSet == null) {
            return;
        }
        NSPrintInfo nSPrintInfo = (NSPrintInfo)printRequestAttributeSet.get(NSPrintInfo.class);
        if (nSPrintInfo != null) {
            this.fNSPrintInfo = nSPrintInfo.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWaitAndSpin() {
        Object object = this.waitLock;
        synchronized (object) {
            while (this.performingPrinting) {
                try {
                    this.waitLock.wait();
                    this.runnable.run();
                    this.runnable = null;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostAndWait(final Runnable runnable) throws InterruptedException {
        final long l = CToolkit.createAWTRunLoopMediator();
        Object object = this.waitLock;
        synchronized (object) {
            this.runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        runnable.run();
                    }
                    finally {
                        CToolkit.stopAWTRunLoop(l);
                    }
                }
            };
            this.waitLock.notifyAll();
        }
        CToolkit.doAWTRunLoop(l);
    }

    private void completePrintLoop() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    CPrinterJob.this.performingPrinting = false;
                }
            }
        };
        if (this.onEventThread) {
            try {
                CToolkit.invokeAndWait(runnable, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                this.doPostAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        CPrinterJob cPrinterJob;
        int n;
        PrintService printService = this.getPrintService();
        if (printService == null) {
            throw new PrinterException("No print service found.");
        }
        if (!(printService instanceof SunPrinterJobService) || !((SunPrinterJobService)((Object)printService)).usesClass(this.getClass())) {
            this.spoolToService(printRequestAttributeSet);
            return;
        }
        this.setAttributes(printRequestAttributeSet);
        int n2 = this.mDocument.getNumberOfPages();
        int n3 = this.getFirstPage();
        int n4 = this.getLastPage();
        if (n4 == -1 && (n = this.mDocument.getNumberOfPages()) != -1) {
            n4 = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            CPrinterJob cPrinterJob2 = this;
            synchronized (cPrinterJob2) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            if (EventQueue.isDispatchThread()) {
                this.onEventThread = true;
                try {
                    if (this.printLoop(false, n3, n4)) {
                        new EventDispatchAccess(){

                            public boolean evaluate() {
                                return CPrinterJob.this.performingPrinting;
                            }
                        }.pumpEventsAndWait();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.onEventThread = false;
                try {
                    if (this.printLoop(false, n3, n4)) {
                        this.doWaitAndSpin();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Object var9_11 = null;
            cPrinterJob = this;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            CPrinterJob cPrinterJob3 = this;
            synchronized (cPrinterJob3) {
                this.performingPrinting = false;
                this.notify();
            }
            throw throwable;
        }
        synchronized (cPrinterJob) {
            this.performingPrinting = false;
            this.notify();
        }
    }

    protected double getXRes() {
        return 0.0;
    }

    protected double getYRes() {
        return 0.0;
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPageHeight(Paper paper) {
        return 0.0;
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected void printBand(byte[] byArray, int n, int n2, int n3, int n4) throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected void startDoc() throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected void endDoc() throws PrinterException {
        throw new PrinterException(sShouldNotReachHere);
    }

    protected native void abortDoc();

    public boolean pageSetup(PageFormat pageFormat, Printable printable) {
        CPrinterPageDialog cPrinterPageDialog = new CPrinterPageDialog(new Frame(), this, pageFormat, printable);
        cPrinterPageDialog.setVisible(true);
        boolean bl = cPrinterPageDialog.getRetVal();
        cPrinterPageDialog.dispose();
        return bl;
    }

    private boolean jobSetup(Pageable pageable, boolean bl) {
        CPrinterJobDialog cPrinterJobDialog = new CPrinterJobDialog(new Frame(), this, pageable, bl);
        cPrinterJobDialog.setVisible(true);
        boolean bl2 = cPrinterJobDialog.getRetVal();
        cPrinterJobDialog.dispose();
        return bl2;
    }

    private native void getDefaultPage(PageFormat var1);

    protected native void validatePaper(Paper var1, Paper var2);

    protected void finalize() {
        if (this.fNSPrintInfo != -1L) {
            this.dispose(this.fNSPrintInfo);
        }
    }

    private native long createNSPrintInfo();

    private native void dispose(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNSPrintInfo() {
        Object object = this.fNSPrintInfoLock;
        synchronized (object) {
            if (this.fNSPrintInfo == -1L) {
                this.fNSPrintInfo = this.createNSPrintInfo();
            }
            return this.fNSPrintInfo;
        }
    }

    private native boolean printLoop(boolean var1, int var2, int var3) throws PrinterException;

    private PageFormat getPageFormat(int n) {
        PageFormat pageFormat;
        try {
            pageFormat = this.getPageable().getPageFormat(n);
        }
        catch (Exception exception) {
            return null;
        }
        return pageFormat;
    }

    private Printable getPrintable(int n) {
        Printable printable;
        try {
            printable = this.getPageable().getPrintable(n);
        }
        catch (Exception exception) {
            return null;
        }
        return printable;
    }

    private String getPrinterName() {
        PrintService printService = this.getPrintService();
        if (printService == null) {
            return null;
        }
        return printService.getName();
    }

    private Rectangle2D getPageFormatArea(PageFormat pageFormat) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        return double_;
    }

    private boolean cancelCheck() {
        boolean bl;
        boolean bl2 = bl = this.performingPrinting && this.userCancelled;
        if (bl) {
            try {
                CToolkit.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            CPrinterJob.this.cancelDoc();
                        }
                        catch (PrinterAbortException printerAbortException) {
                            // empty catch block
                        }
                    }
                }, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return bl;
    }

    private PeekGraphics createFirstPassGraphics(PrinterJob printerJob, PageFormat pageFormat) {
        BufferedImage bufferedImage = new BufferedImage((int)Math.round(pageFormat.getWidth()), (int)Math.round(pageFormat.getHeight()), 3);
        PeekGraphics peekGraphics = this.createPeekGraphics(bufferedImage.createGraphics(), printerJob);
        Rectangle2D rectangle2D = this.getPageFormatArea(pageFormat);
        this.initPrinterGraphics(peekGraphics, rectangle2D);
        return peekGraphics;
    }

    private void printToPathGraphics(PeekGraphics peekGraphics, final PrinterJob printerJob, final Printable printable, final PageFormat pageFormat, final int n, final long l) throws PrinterException {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    SurfaceData surfaceData = CPrinterSurfaceData.createData(pageFormat, l);
                    if (defaultFont == null) {
                        defaultFont = new Font("Dialog", 0, 12);
                    }
                    SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData, Color.black, Color.white, defaultFont);
                    CPrinterGraphics cPrinterGraphics = new CPrinterGraphics(sunGraphics2D, printerJob);
                    Rectangle2D rectangle2D = CPrinterJob.this.getPageFormatArea(pageFormat);
                    CPrinterJob.this.initPrinterGraphics(cPrinterGraphics, rectangle2D);
                    printable.print(cPrinterGraphics, pageFormat, n);
                    ((Graphics)sunGraphics2D).dispose();
                    sunGraphics2D = null;
                }
                catch (PrinterException printerException) {
                    throw new UndeclaredThrowableException(printerException);
                }
            }
        };
        if (this.onEventThread) {
            try {
                CToolkit.invokeAndWait(runnable, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof PrinterException) {
                    throw (PrinterException)throwable;
                }
                throwable.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                this.doPostAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getPageformatPrintablePeekgraphics(final int n) {
        final Object[] objectArray = new Object[3];
        final CPrinterJob cPrinterJob = this;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object[] objectArray2 = objectArray;
                synchronized (objectArray) {
                    try {
                        Printable printable;
                        Pageable pageable = CPrinterJob.this.getPageable();
                        PageFormat pageFormat = pageable.getPageFormat(n);
                        if (pageFormat != null && (printable = pageable.getPrintable(n)) != null) {
                            BufferedImage bufferedImage = new BufferedImage((int)Math.round(pageFormat.getWidth()), (int)Math.round(pageFormat.getHeight()), 3);
                            PeekGraphics peekGraphics = CPrinterJob.this.createPeekGraphics(bufferedImage.createGraphics(), cPrinterJob);
                            Rectangle2D rectangle2D = CPrinterJob.this.getPageFormatArea(pageFormat);
                            CPrinterJob.this.initPrinterGraphics(peekGraphics, rectangle2D);
                            objectArray[0] = pageFormat;
                            objectArray[1] = printable;
                            objectArray[2] = peekGraphics;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        };
        if (this.onEventThread) {
            try {
                CToolkit.invokeAndWait(runnable, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                this.doPostAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Object[] objectArray2 = objectArray;
        synchronized (objectArray) {
            if (objectArray[2] != null) {
                // ** MonitorExit[var5_7] (shouldn't be in output)
                return objectArray;
            }
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle2D printAndGetPageFormatArea(final Printable printable, final Graphics graphics, final PageFormat pageFormat, final int n) {
        final Rectangle2D[] rectangle2DArray = new Rectangle2D[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Rectangle2D[] rectangle2DArray2 = rectangle2DArray;
                synchronized (rectangle2DArray) {
                    try {
                        int n2 = printable.print(graphics, pageFormat, n);
                        if (n2 != 1) {
                            rectangle2DArray[0] = CPrinterJob.this.getPageFormatArea(pageFormat);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
        };
        if (this.onEventThread) {
            try {
                CToolkit.invokeAndWait(runnable, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                this.doPostAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Rectangle2D[] rectangle2DArray2 = rectangle2DArray;
        synchronized (rectangle2DArray) {
            // ** MonitorExit[var7_9] (shouldn't be in output)
            return rectangle2DArray[0];
        }
    }

    static {
        Toolkit.getDefaultToolkit();
    }
}

