/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CWindow;
import apple.awt.ComponentModel;
import apple.awt.OSXSurfaceData;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;

public class CPeerSurfaceData
extends OSXSurfaceData {
    private ComponentModel fPeer;
    private CWindow fCWindow;
    private Object fPeerDrawingLock;
    private Object fLockObject;
    private static final ArrayList sDirtySurfaces = new ArrayList();
    private static WeakReference fMostRecentlyUsedSurface = null;
    private static ReferenceQueue fReferenceQueue = new ReferenceQueue();
    private boolean fIsDirtySurface = false;
    private WeakReference fWeakReference = null;
    public static final String DESC_INT_ARGB_PRE_Q = "Integer ARGB_PRE 32 bit Display Quartz";
    public static final SurfaceType IntArgbPreQ = SurfaceType.IntArgbPre.deriveSubType("Integer ARGB_PRE 32 bit Display Quartz");
    Object fFlushingLock = new SurfaceFlushingLock();
    int fFlushCountDepth = 0;

    public static CPeerSurfaceData createData(ComponentModel componentModel, Rectangle rectangle) {
        return new CPeerSurfaceData(componentModel, rectangle);
    }

    public static SurfaceType getSurfaceType(ColorModel colorModel, boolean bl) {
        return IntArgbPreQ;
    }

    private CPeerSurfaceData(ComponentModel componentModel, Rectangle rectangle) {
        super(CPeerSurfaceData.getSurfaceType(componentModel.getColorModel(), false), componentModel.getColorModel(), componentModel.getGraphicsConfiguration(), rectangle);
        this.fPeer = componentModel;
        this.fWeakReference = new WeakReference<CPeerSurfaceData>(this, fReferenceQueue);
        this.fCWindow = this.fPeer.getCWindowContainer();
        this.fPeerDrawingLock = this.fCWindow.fPeerDrawingLock;
        this.fLockObject = new Object();
        this.initOps(componentModel.getViewPtr(), this.fGraphicsStates, this.fGraphicsStatesObject);
    }

    private native void initOps(long var1, ByteBuffer var3, Object[] var4);

    ComponentModel getPeer() {
        return this.fPeer;
    }

    public SurfaceData getReplacement() {
        Rectangle rectangle = this.fPeer.getSurfaceBounds();
        this.fBounds.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return this;
    }

    public Object getLockObject() {
        return this.fLockObject;
    }

    void setupGraphicsState(SunGraphics2D sunGraphics2D, int n, Font font, int n2, int n3, int n4, int n5) {
        if (this.fCWindow.fClient != this.fPeer) {
            this.fCWindow.fClient.finishLazyDrawing();
            this.fCWindow.fClient = this.fPeer;
        }
        super.setupGraphicsState(sunGraphics2D, n, font, n2, n3, n4, n5);
    }

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (sunGraphics2D.transformState == 0 || sunGraphics2D.transformState == 1) {
            this.finishLazyDrawing();
            this.setupGraphicsState(sunGraphics2D, 3);
            Rectangle rectangle = this.clipCopyArea(sunGraphics2D, n, n2, n3, n4, n5, n6);
            if (rectangle == null) {
                return true;
            }
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.width;
            n4 = rectangle.height;
            return fCRenderer.doCopyAreaInWindow(this, n, n2, n3, n4, n5, n6);
        }
        return false;
    }

    public BufferedImage copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, BufferedImage bufferedImage) {
        this.finishLazyDrawing();
        this.setupGraphicsState(sunGraphics2D, 3);
        if (bufferedImage == null) {
            bufferedImage = this.getDeviceConfiguration().createCompatibleImage(n3, n4);
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)BufImgSurfaceData.createData(bufferedImage);
        oSXSurfaceData.finishLazyDrawing();
        Graphics graphics = bufferedImage.getGraphics();
        oSXSurfaceData.setupGraphicsState((SunGraphics2D)graphics, 3);
        fCRenderer.doCopyAreaFromWindow(this, oSXSurfaceData, n, n2, n3, n4);
        graphics.dispose();
        return bufferedImage;
    }

    public boolean xorSurfacePixels(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5) {
        this.finishLazyDrawing();
        this.setupGraphicsState(sunGraphics2D, 3);
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)BufImgSurfaceData.createData(bufferedImage);
        oSXSurfaceData.finishLazyDrawing();
        return fCRenderer.xorSurfacePixels(this, oSXSurfaceData, n, n2, n3, n4, n5);
    }

    public void finishLazyDrawing() {
        if (!this.fPeer.isDisposed()) {
            super.finishLazyDrawing();
        }
    }

    void finishLazyDrawing(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, Object[] objectArray, int n2) {
        if (!this.fPeer.isDisposed()) {
            this._finishLazyDrawing(byteBuffer, byteBuffer2, n, objectArray, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishLazyDrawingForAllSurfaces() {
        WeakReference[] weakReferenceArray = null;
        int n = 0;
        ArrayList arrayList = sDirtySurfaces;
        synchronized (arrayList) {
            if (fMostRecentlyUsedSurface != null) {
                sDirtySurfaces.add(fMostRecentlyUsedSurface);
                fMostRecentlyUsedSurface = null;
            }
            n = sDirtySurfaces.size();
            weakReferenceArray = new WeakReference[n];
            sDirtySurfaces.toArray(weakReferenceArray);
            sDirtySurfaces.clear();
        }
        for (int i = 0; i < n; ++i) {
            SurfaceData surfaceData = (SurfaceData)weakReferenceArray[i].get();
            if (surfaceData == null) continue;
            surfaceData.finishLazyDrawing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markDirty(boolean bl) {
        if (bl == this.fIsDirtySurface) {
            return;
        }
        this.fCWindow.markDirty(bl);
        if (bl) {
            this.fIsDirtySurface = true;
            ArrayList arrayList = sDirtySurfaces;
            synchronized (arrayList) {
                if (fMostRecentlyUsedSurface == null) {
                    fMostRecentlyUsedSurface = this.fWeakReference;
                } else {
                    sDirtySurfaces.add(fMostRecentlyUsedSurface);
                    fMostRecentlyUsedSurface = this.fWeakReference;
                }
                this.deleteStaleReferences();
            }
        }
        this.fIsDirtySurface = false;
        ArrayList arrayList = sDirtySurfaces;
        synchronized (arrayList) {
            if (fMostRecentlyUsedSurface == this.fWeakReference) {
                fMostRecentlyUsedSurface = null;
            } else {
                sDirtySurfaces.remove(this.fWeakReference);
            }
        }
    }

    private void deleteStaleReferences() {
        ArrayList arrayList = null;
        Reference reference = null;
        while ((reference = fReferenceQueue.poll()) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.add(reference);
        }
        if (arrayList != null) {
            sDirtySurfaces.removeAll(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFlushing() {
        Object object = this.fFlushingLock;
        synchronized (object) {
            --this.fFlushCountDepth;
        }
        this.fCWindow.disableFlushing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFlushing() {
        Object object = this.fFlushingLock;
        synchronized (object) {
            ++this.fFlushCountDepth;
            if (this.fFlushCountDepth == 0) {
                this.fPeer.finishLazyDrawing();
            }
        }
        this.fCWindow.enableFlushing();
    }

    public native void show();

    public void canDrawDuringLiveResize(boolean bl) {
        this.fGraphicsStatesInt.put(49, bl ? 1 : 0);
    }

    class SurfaceFlushingLock {
        SurfaceFlushingLock() {
        }
    }
}

