/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CInputMethodDescriptor;
import apple.awt.CToolkit;
import apple.awt.ComponentModel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.reflect.InvocationTargetException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.JTextComponent;
import sun.awt.im.InputMethodAdapter;

public class CInputMethod
extends InputMethodAdapter {
    private InputMethodContext fIMContext;
    private Component fAwtFocussedComponent;
    private ComponentModel fAwtFocussedComponentPeer;
    private boolean isActive;
    private Locale currentLocale = CInputMethod.getNativeLocale();
    private static Map[] sHighlightStyles;
    private AttributedString fCurrentText = null;
    private int fCurrentTextLength = 0;
    private static final int kCaretPosition = 0;
    private static final int kRawText = 1;
    private static final int kSelectedRawText = 2;
    private static final int kConvertedText = 3;
    private static final int kSelectedConvertedText = 4;

    public CInputMethod() {
        if (this.currentLocale == null) {
            this.currentLocale = Locale.getDefault();
        }
    }

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.fIMContext = inputMethodContext;
    }

    public boolean setLocale(Locale locale) {
        return this.setLocale(locale, false);
    }

    private boolean setLocale(Locale locale, boolean bl) {
        Object[] objectArray = CInputMethodDescriptor.getAvailableLocalesInternal();
        for (int i = 0; i < objectArray.length; ++i) {
            Locale locale2 = (Locale)objectArray[i];
            if (!locale.equals(locale2) && (!locale2.equals(Locale.JAPAN) || !locale.equals(Locale.JAPANESE)) && (!locale2.equals(Locale.KOREA) || !locale.equals(Locale.KOREAN))) continue;
            CInputMethod.setNativeLocale(locale2.toString(), bl);
            this.currentLocale = locale2;
            return true;
        }
        return false;
    }

    public Locale getLocale() {
        this.currentLocale = CInputMethod.getNativeLocale();
        if (this.currentLocale == null) {
            this.currentLocale = Locale.getDefault();
        }
        return this.currentLocale;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public void setCompositionEnabled(boolean bl) {
        throw new UnsupportedOperationException("Can't adjust composition mode on Mac OS X.");
    }

    public boolean isCompositionEnabled() {
        throw new UnsupportedOperationException("Can't adjust composition mode on Mac OS X.");
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    public void activate() {
    }

    public void deactivate(boolean bl) {
        this.getLocale();
        this.isActive = false;
    }

    public void hideWindows() {
    }

    public void removeNotify() {
        if (this.fAwtFocussedComponentPeer != null) {
            this.nativeEndComposition(this.fAwtFocussedComponentPeer.getModelPtr());
        }
        this.fAwtFocussedComponent = null;
        this.fAwtFocussedComponentPeer = null;
    }

    protected void setAWTFocussedComponent(Component component) {
        if (component == null) {
            return;
        }
        ComponentModel componentModel = this.getNearestNativePeer(component);
        if (componentModel != null) {
            this.nativeNotifyPeer(componentModel.getModelPtr(), this);
        }
        this.fAwtFocussedComponent = component;
        this.fAwtFocussedComponentPeer = componentModel;
    }

    public static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n;
        int n2 = inputMethodHighlight.getState();
        if (n2 == 0) {
            n = 0;
        } else if (n2 == 1) {
            n = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n;
        }
        return sHighlightStyles[n];
    }

    public void endComposition() {
        if (this.fAwtFocussedComponentPeer != null) {
            this.nativeEndComposition(this.fAwtFocussedComponentPeer.getModelPtr());
        }
    }

    public void dispose() {
        this.fIMContext = null;
        this.fAwtFocussedComponent = null;
        this.fAwtFocussedComponentPeer = null;
        this.currentLocale = null;
    }

    public Object getControlObject() {
        return null;
    }

    private ComponentModel getNearestNativePeer(Component component) {
        if (component == null) {
            return null;
        }
        ComponentPeer componentPeer = component.getPeer();
        if (componentPeer == null) {
            return null;
        }
        while (componentPeer instanceof LightweightPeer) {
            if ((component = component.getParent()) == null) {
                return null;
            }
            componentPeer = component.getPeer();
            if (componentPeer != null) continue;
            return null;
        }
        if (componentPeer instanceof ComponentModel) {
            return (ComponentModel)componentPeer;
        }
        return null;
    }

    private synchronized void insertText(String string) {
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(AttributedCharacterIterator.Attribute.LANGUAGE, this.getLocale(), 0, string.length());
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(string.length() - 1);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, attributedString.getIterator(), string.length(), textHitInfo, textHitInfo);
        CToolkit.postEvent(CToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
        this.fCurrentText = null;
        this.fCurrentTextLength = 0;
    }

    private void startIMUpdate(String string) {
        this.fCurrentText = new AttributedString(string);
        this.fCurrentTextLength = string.length();
    }

    private void addAttribute(boolean bl, boolean bl2, int n, int n2) {
        InputMethodHighlight inputMethodHighlight;
        int n3 = n;
        int n4 = n + n2;
        int n5 = 1;
        if (bl && bl2) {
            n5 = 1;
        } else if (!bl && bl2) {
            n5 = 1;
        } else if (bl && !bl2) {
            n5 = 4;
        } else if (!bl && !bl2) {
            n5 = 3;
        }
        switch (n5) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 3: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        this.fCurrentText.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, n3, n4);
    }

    private void dispatchText(int n, int n2) {
        TextHitInfo textHitInfo;
        if (this.fCurrentText == null) {
            return;
        }
        TextHitInfo textHitInfo2 = textHitInfo = TextHitInfo.afterOffset(this.fCurrentTextLength);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, this.fCurrentText.getIterator(), 0, textHitInfo, textHitInfo2);
        CToolkit.postEvent(CToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
    }

    private synchronized void unmarkText() {
        TextHitInfo textHitInfo;
        if (this.fCurrentText == null) {
            return;
        }
        TextHitInfo textHitInfo2 = textHitInfo = TextHitInfo.afterOffset(this.fCurrentTextLength);
        InputMethodEvent inputMethodEvent = new InputMethodEvent(this.fAwtFocussedComponent, 1100, this.fCurrentText.getIterator(), this.fCurrentTextLength, textHitInfo, textHitInfo2);
        CToolkit.postEvent(CToolkit.targetToAppContext(this.fAwtFocussedComponent), inputMethodEvent);
        this.fCurrentText = null;
        this.fCurrentTextLength = 0;
    }

    private synchronized boolean hasMarkedText() {
        return this.fCurrentText != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String attributedSubstringFromRange(final int n, final int n2) {
        final String[] stringArray = new String[1];
        try {
            CToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String[] stringArray2 = stringArray;
                    synchronized (stringArray) {
                        int n5;
                        int n22 = n;
                        int n3 = n2;
                        if (n22 + n3 > CInputMethod.this.fIMContext.getCommittedTextLength() + CInputMethod.this.fCurrentTextLength) {
                            n3 = CInputMethod.this.fIMContext.getCommittedTextLength() - n22;
                        }
                        AttributedCharacterIterator attributedCharacterIterator = null;
                        attributedCharacterIterator = CInputMethod.this.fCurrentText == null ? CInputMethod.this.fIMContext.getCommittedText(n22, n22 + n3, null) : (n22 < (n5 = CInputMethod.this.fIMContext.getInsertPositionOffset()) ? CInputMethod.this.fIMContext.getCommittedText(n22, n22 + n3, null) : (n22 >= n5 && n22 < n5 + CInputMethod.this.fCurrentTextLength ? CInputMethod.this.fCurrentText.getIterator(null, n22 - n5, n22 - n5 + n3) : CInputMethod.this.fIMContext.getCommittedText(n22 - CInputMethod.this.fCurrentTextLength, n22 - CInputMethod.this.fCurrentTextLength + n3, null)));
                        char[] cArray = new char[attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()];
                        char c = attributedCharacterIterator.first();
                        int n4 = 0;
                        while (c != '\uffff') {
                            cArray[n4++] = c;
                            c = attributedCharacterIterator.next();
                        }
                        stringArray[0] = new String(cArray);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var4_6] (shouldn't be in output)
            return stringArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] selectedRange() {
        final int[] nArray = new int[2];
        try {
            CToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int[] nArray2 = nArray;
                    synchronized (nArray) {
                        AttributedCharacterIterator attributedCharacterIterator = CInputMethod.this.fIMContext.getSelectedText(null);
                        if (attributedCharacterIterator != null) {
                            int n;
                            if (CInputMethod.this.fAwtFocussedComponent instanceof JTextComponent) {
                                JTextComponent jTextComponent = (JTextComponent)CInputMethod.this.fAwtFocussedComponent;
                                n = jTextComponent.getSelectionStart();
                            } else if (CInputMethod.this.fAwtFocussedComponent instanceof TextComponent) {
                                TextComponent textComponent = (TextComponent)CInputMethod.this.fAwtFocussedComponent;
                                n = textComponent.getSelectionStart();
                            } else {
                                n = CInputMethod.this.fIMContext.getInsertPositionOffset() - (attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
                                if (n < 0) {
                                    n = CInputMethod.this.fIMContext.getInsertPositionOffset() + (attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
                                }
                            }
                            nArray[0] = n;
                            nArray[1] = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var2_4] (shouldn't be in output)
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] markedRange() {
        if (this.fCurrentText == null) {
            return null;
        }
        final int[] nArray = new int[2];
        try {
            CToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int[] nArray2 = nArray;
                    synchronized (nArray) {
                        nArray[0] = CInputMethod.this.fIMContext.getInsertPositionOffset();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        nArray[1] = this.fCurrentTextLength;
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var2_4] (shouldn't be in output)
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int[] firstRectForCharacterRange() {
        final int[] nArray = new int[4];
        try {
            CToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int[] nArray2 = nArray;
                    synchronized (nArray) {
                        Rectangle rectangle = CInputMethod.this.fIMContext.getTextLocation(TextHitInfo.beforeOffset(0));
                        nArray[0] = rectangle.x;
                        nArray[1] = rectangle.y;
                        nArray[2] = rectangle.width;
                        nArray[3] = rectangle.height;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var2_4] (shouldn't be in output)
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int characterIndexForPoint(final int n, final int n2) {
        final TextHitInfo[] textHitInfoArray = new TextHitInfo[1];
        try {
            CToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    TextHitInfo[] textHitInfoArray2 = textHitInfoArray;
                    synchronized (textHitInfoArray) {
                        textHitInfoArray[0] = CInputMethod.this.fIMContext.getLocationOffset(n, n2);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, this.fAwtFocussedComponent);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (textHitInfoArray[0] == null) {
            textHitInfoArray[0] = TextHitInfo.beforeOffset(0);
        }
        TextHitInfo[] textHitInfoArray2 = textHitInfoArray;
        synchronized (textHitInfoArray) {
            // ** MonitorExit[var4_6] (shouldn't be in output)
            return textHitInfoArray[0].getCharIndex();
        }
    }

    private native void nativeNotifyPeer(long var1, CInputMethod var3);

    private native void nativeEndComposition(long var1);

    private native void nativeHandleEvent(ComponentModel var1, AWTEvent var2);

    static native Locale getNativeLocale();

    static native boolean setNativeLocale(String var0, boolean var1);

    static native void nativeInit();

    static {
        Map[] mapArray = new Map[4];
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        sHighlightStyles = mapArray;
        CInputMethod.nativeInit();
    }
}

