/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.OSXOffScreenSurfaceData;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class CImage
extends Image {
    int w = -1;
    int h = -1;
    long fNSImage = 0L;
    BufferedImage fConvertedBI = null;

    public CImage(long l) {
        this.setNSImage(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CImage(Image image) {
        if (image != null) {
            BufferedImage bufferedImage = null;
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
            } else {
                Canvas canvas = new Canvas();
                MediaTracker mediaTracker = new MediaTracker(canvas);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("ImageTracker interrupted.");
                    Thread.dumpStack();
                    return;
                }
                int n = Math.max(image.getWidth(canvas), 1);
                int n2 = Math.max(image.getHeight(canvas), 1);
                bufferedImage = new BufferedImage(n, n2, 3);
                Graphics graphics = bufferedImage.getGraphics();
                try {
                    graphics.drawImage(image, 0, 0, n, n2, null);
                }
                finally {
                    graphics.dispose();
                }
            }
            this.setNSImage(bufferedImage);
        }
    }

    public CImage(String string) {
        long l = this.icon(string);
        this.setNSImage(l);
    }

    public CImage(int n) {
        long l = this.imageFromIconSelector(n);
        this.setNSImage(l);
    }

    private void setNSImage(BufferedImage bufferedImage) {
        long l = this.makeNSImage(bufferedImage);
        this.setNSImage(l);
    }

    private synchronized void setNSImage(long l) {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
        }
        this.fNSImage = l;
    }

    public synchronized void dispose() {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
            this.fNSImage = 0L;
        }
    }

    private native void _release(long var1);

    synchronized long getNSImage() {
        return this.fNSImage;
    }

    protected void finalize() {
        this.dispose();
    }

    private native int width(long var1);

    private native int height(long var1);

    private native long icon(String var1);

    private native long imageFromIconSelector(int var1);

    public synchronized int getWidth(ImageObserver imageObserver) {
        if (this.w == -1) {
            this.w = this.width(this.fNSImage);
        }
        return this.w;
    }

    public synchronized int getHeight(ImageObserver imageObserver) {
        if (this.h == -1) {
            this.h = this.height(this.fNSImage);
        }
        return this.h;
    }

    public ImageProducer getSource() {
        throw new IllegalAccessError("getSource() not valid for CImage");
    }

    public Graphics getGraphics() {
        throw new IllegalAccessError("getGraphics() not valid for CImage");
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        return Image.UndefinedProperty;
    }

    public void flush() {
    }

    private long makeNSImage(BufferedImage bufferedImage) {
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = (OSXOffScreenSurfaceData)OSXOffScreenSurfaceData.createData(bufferedImage);
        return oSXOffScreenSurfaceData.makeNSImage();
    }

    synchronized BufferedImage getBufferedImage() {
        if (this.fConvertedBI == null) {
            int n = this.getWidth(null);
            int n2 = this.getHeight(null);
            this.fConvertedBI = new BufferedImage(n, n2, 3);
            OSXOffScreenSurfaceData oSXOffScreenSurfaceData = (OSXOffScreenSurfaceData)OSXOffScreenSurfaceData.createData(this.fConvertedBI);
            oSXOffScreenSurfaceData.copyNSImagePixels(this.fNSImage);
        }
        return this.fConvertedBI;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

