/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsConfig;
import apple.awt.CWindow;
import apple.awt.RuntimeOptions;
import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Window;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.java2d.SurfaceData;

public class CGraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    private static AWTPermission fullScreenExclusivePermission;
    GraphicsConfiguration[] configs;
    int screenIndex;
    int displayID;
    int fadeToken;

    public CGraphicsDevice(int n) {
        this.screenIndex = n;
    }

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        return ((CGraphicsConfig)this.getDefaultConfiguration()).getIDString();
    }

    public GraphicsConfiguration[] getConfigurations() {
        GraphicsConfiguration[] graphicsConfigurationArray = this.configs;
        if (graphicsConfigurationArray == null) {
            graphicsConfigurationArray = new GraphicsConfiguration[]{new CGraphicsConfig(this)};
            this.configs = graphicsConfigurationArray;
        }
        return graphicsConfigurationArray;
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        return this.getConfigurations()[0];
    }

    public int getScreen() {
        return this.screenIndex;
    }

    public void displayChanged() {
        this.configs = null;
        this.topLevels.notifyListeners();
    }

    public void paletteChanged() {
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.remove(displayChangedListener);
    }

    public boolean isOffscreenAccelerationEnabled() {
        return true;
    }

    public boolean isDisplayChangeSupported() {
        return true;
    }

    public boolean isFullScreenSupported() {
        return true;
    }

    public void setFullScreenWindow(Window window) {
        CWindow cWindow;
        Window window2 = this.getFullScreenWindow();
        if (window2 == window) {
            return;
        }
        if (window2 != null) {
            cWindow = (CWindow)window2.getPeer();
            this.exitFullScreen(cWindow);
        }
        super.setFullScreenWindow(window);
        if (window != null) {
            this.checkFullScreenPermission();
            cWindow = (CWindow)window.getPeer();
            this.enterFullScreen(cWindow);
        }
    }

    void fullScreenWindowDisposed(CWindow cWindow) {
        super.setFullScreenWindow(null);
        this.exitFullScreen(cWindow);
    }

    private void checkFullScreenPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            securityManager.checkPermission(fullScreenExclusivePermission);
        }
    }

    private void enterFullScreen(CWindow cWindow) {
        if (!RuntimeOptions.getCurrentOptions().FakeFullScreen) {
            this.enterFullScreen(cWindow.getSurface());
        }
    }

    private void exitFullScreen(CWindow cWindow) {
        if (!RuntimeOptions.getCurrentOptions().FakeFullScreen && cWindow != null) {
            cWindow.destroyBuffers();
            this.exitFullScreen(cWindow.getSurface());
        }
    }

    public void setDisplayMode(DisplayMode displayMode) {
        Window window;
        boolean bl = false;
        String string = null;
        if (displayMode != null) {
            window = this.getFullScreenWindow();
            if (window != null) {
                if (displayMode.getBitDepth() == 8) {
                    string = "Full Screen doesn't support 8- bit DisplayMode";
                } else {
                    bl = true;
                }
            } else {
                string = "Cannot change DisplayMode when not in Full Screen";
            }
        }
        if (bl) {
            if (!this._setDisplayMode(displayMode)) {
                string = "Unable to change DisplayMode";
            } else {
                window = this.getFullScreenWindow();
                window.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
            }
        }
        if (string != null) {
            throw new IllegalArgumentException("Invalid DisplayMode: " + string);
        }
    }

    private native boolean _setDisplayMode(DisplayMode var1);

    public native DisplayMode getDisplayMode();

    public native DisplayMode[] getDisplayModes();

    native long getNSScreen();

    native int getScreenResolution();

    native Insets getScreenInsets();

    public native void enterFullScreen(SurfaceData var1);

    public native void exitFullScreen(SurfaceData var1);
}

