/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import sun.awt.AppContext;
import sun.security.action.LoadLibraryAction;

class CAccessibility
implements PropertyChangeListener {
    private static Set ignoredRoles;
    private static Accessible fFocusOwner;
    private static AccessibleRole fFocusOwnerRole;
    private static int fFocusOwnerIndexInParent;
    private static AppContext fFocusOwnerContext;
    static CAccessibility sAccessibility;
    static final int JAVA_AX_ALL_CHILDREN = -1;
    static final int JAVA_AX_SELECTED_CHILDREN = -2;
    static final int JAVA_AX_VISIBLE_CHILDREN = -3;

    static synchronized CAccessibility getAccessibility(String[] stringArray) {
        if (sAccessibility == null) {
            sAccessibility = new CAccessibility();
            if (stringArray != null) {
                ignoredRoles = new HashSet(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    ignoredRoles.add(stringArray[i]);
                }
            } else {
                ignoredRoles = new HashSet();
            }
        }
        return sAccessibility;
    }

    private CAccessibility() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() != null) {
            this.focusChanged();
        }
    }

    private native void focusChanged();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccessibleActionDescription(final AccessibleAction accessibleAction, final int n, Component component) {
        final String[] stringArray = new String[1];
        if (accessibleAction != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String[] stringArray2 = stringArray;
                        synchronized (stringArray) {
                            stringArray[0] = accessibleAction.getAccessibleActionDescription(n);
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return stringArray[0];
        }
    }

    public static void doAccessibleAction(final AccessibleAction accessibleAction, final int n, Component component) {
        if (accessibleAction != null) {
            try {
                CToolkit.invokeLater(new Runnable(){

                    public void run() {
                        accessibleAction.doAccessibleAction(n);
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getSize(final AccessibleComponent accessibleComponent, Component component) {
        final Dimension[] dimensionArray = new Dimension[1];
        if (accessibleComponent != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Dimension[] dimensionArray2 = dimensionArray;
                        synchronized (dimensionArray) {
                            dimensionArray[0] = accessibleComponent.getSize();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Dimension[] dimensionArray2 = dimensionArray;
        synchronized (dimensionArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return dimensionArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleSelection getAccessibleSelection(final AccessibleContext accessibleContext, Component component) {
        final AccessibleSelection[] accessibleSelectionArray = new AccessibleSelection[1];
        if (accessibleContext != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleSelection[] accessibleSelectionArray2 = accessibleSelectionArray;
                        synchronized (accessibleSelectionArray) {
                            accessibleSelectionArray[0] = accessibleContext.getAccessibleSelection();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleSelection[] accessibleSelectionArray2 = accessibleSelectionArray;
        synchronized (accessibleSelectionArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleSelectionArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Accessible ax_getAccessibleSelection(final AccessibleContext accessibleContext, final int n, Component component) {
        final Accessible[] accessibleArray = new Accessible[1];
        if (accessibleContext != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Accessible[] accessibleArray2 = accessibleArray;
                        synchronized (accessibleArray) {
                            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
                            if (accessibleSelection != null) {
                                accessibleArray[0] = accessibleSelection.getAccessibleSelection(n);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Accessible[] accessibleArray2 = accessibleArray;
        synchronized (accessibleArray) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return accessibleArray[0];
        }
    }

    public static void addAccessibleSelection(final AccessibleContext accessibleContext, final int n, Component component) {
        if (accessibleContext != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    public void run() {
                        AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
                        if (accessibleSelection != null) {
                            accessibleSelection.addAccessibleSelection(n);
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleContext getAccessibleContext(final Accessible accessible, Component component) {
        final AccessibleContext[] accessibleContextArray = new AccessibleContext[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleContext[] accessibleContextArray2 = accessibleContextArray;
                        synchronized (accessibleContextArray) {
                            accessibleContextArray[0] = accessible.getAccessibleContext();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleContext[] accessibleContextArray2 = accessibleContextArray;
        synchronized (accessibleContextArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleContextArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAccessibleChildSelected(final Accessible accessible, final int n, Component component) {
        final boolean[] blArray = new boolean[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean[] blArray2 = blArray;
                        synchronized (blArray) {
                            AccessibleSelection accessibleSelection;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                                blArray[0] = accessibleSelection.isAccessibleChildSelected(n);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return blArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleStateSet getAccessibleStateSet(final AccessibleContext accessibleContext, Component component) {
        final AccessibleStateSet[] accessibleStateSetArray = new AccessibleStateSet[1];
        if (accessibleContext != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleStateSet[] accessibleStateSetArray2 = accessibleStateSetArray;
                        synchronized (accessibleStateSetArray) {
                            accessibleStateSetArray[0] = accessibleContext.getAccessibleStateSet();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleStateSet[] accessibleStateSetArray2 = accessibleStateSetArray;
        synchronized (accessibleStateSetArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleStateSetArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(final AccessibleContext accessibleContext, final AccessibleState accessibleState, Component component) {
        final boolean[] blArray = new boolean[1];
        if (accessibleContext != null && accessibleState != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean[] blArray2 = blArray;
                        synchronized (blArray) {
                            AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
                            if (accessibleStateSet != null) {
                                blArray[0] = accessibleStateSet.contains(accessibleState);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return blArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleRole getAccessibleRole(final Accessible accessible, Component component) {
        final AccessibleRole[] accessibleRoleArray = new AccessibleRole[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleRole[] accessibleRoleArray2 = accessibleRoleArray;
                        synchronized (accessibleRoleArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                accessibleRoleArray[0] = accessibleContext.getAccessibleRole();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleRole[] accessibleRoleArray2 = accessibleRoleArray;
        synchronized (accessibleRoleArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleRoleArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getLocationOnScreen(final AccessibleComponent accessibleComponent, Component component) {
        final Point[] pointArray = new Point[1];
        if (accessibleComponent != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Point[] pointArray2 = pointArray;
                        synchronized (pointArray) {
                            pointArray[0] = accessibleComponent.getLocationOnScreen();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Point[] pointArray2 = pointArray;
        synchronized (pointArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return pointArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCharCount(final AccessibleText accessibleText, Component component) {
        final int[] nArray = new int[1];
        if (accessibleText != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int[] nArray2 = nArray;
                        synchronized (nArray) {
                            nArray[0] = accessibleText.getCharCount();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return nArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Accessible getAccessibleParent(final Accessible accessible, Component component) {
        final Accessible[] accessibleArray = new Accessible[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Accessible[] accessibleArray2 = accessibleArray;
                        synchronized (accessibleArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                Accessible accessible2;
                                accessibleArray[0] = accessible2 = accessibleContext.getAccessibleParent();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Accessible[] accessibleArray2 = accessibleArray;
        synchronized (accessibleArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAccessibleIndexInParent(final Accessible accessible, Component component) {
        final int[] nArray = new int[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int[] nArray2 = nArray;
                        synchronized (nArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                nArray[0] = accessibleContext.getAccessibleIndexInParent();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return nArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleComponent getAccessibleComponent(final Accessible accessible, Component component) {
        final AccessibleComponent[] accessibleComponentArray = new AccessibleComponent[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleComponent[] accessibleComponentArray2 = accessibleComponentArray;
                        synchronized (accessibleComponentArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                accessibleComponentArray[0] = accessibleContext.getAccessibleComponent();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleComponent[] accessibleComponentArray2 = accessibleComponentArray;
        synchronized (accessibleComponentArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleComponentArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleValue getAccessibleValue(final Accessible accessible, Component component) {
        final AccessibleValue[] accessibleValueArray = new AccessibleValue[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleValue[] accessibleValueArray2 = accessibleValueArray;
                        synchronized (accessibleValueArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                accessibleValueArray[0] = accessibleContext.getAccessibleValue();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleValue[] accessibleValueArray2 = accessibleValueArray;
        synchronized (accessibleValueArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleValueArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccessibleName(final Accessible accessible, Component component) {
        final String[] stringArray = new String[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String[] stringArray2 = stringArray;
                        synchronized (stringArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                stringArray[0] = accessibleContext.getAccessibleName();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return stringArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleText getAccessibleText(final Accessible accessible, Component component) {
        final AccessibleText[] accessibleTextArray = new AccessibleText[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleText[] accessibleTextArray2 = accessibleTextArray;
                        synchronized (accessibleTextArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                accessibleTextArray[0] = accessibleContext.getAccessibleText();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleText[] accessibleTextArray2 = accessibleTextArray;
        synchronized (accessibleTextArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleTextArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccessibleDescription(final Accessible accessible, Component component) {
        final String[] stringArray = new String[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String[] stringArray2 = stringArray;
                        synchronized (stringArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                stringArray[0] = accessibleContext.getAccessibleDescription();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return stringArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleEditableText getAccessibleEditableText(final Accessible accessible, Component component) {
        final AccessibleEditableText[] accessibleEditableTextArray = new AccessibleEditableText[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleEditableText[] accessibleEditableTextArray2 = accessibleEditableTextArray;
                        synchronized (accessibleEditableTextArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                accessibleEditableTextArray[0] = accessibleContext.getAccessibleEditableText();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleEditableText[] accessibleEditableTextArray2 = accessibleEditableTextArray;
        synchronized (accessibleEditableTextArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleEditableTextArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFocusTraversable(final Accessible accessible, Component component) {
        final boolean[] blArray = new boolean[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean[] blArray2 = blArray;
                        synchronized (blArray) {
                            AccessibleComponent accessibleComponent;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null) {
                                blArray[0] = accessibleComponent.isFocusTraversable();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return blArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Accessible accessibilityHitTest(final Container container, final float f, final float f2) {
        final Accessible[] accessibleArray = new Accessible[1];
        if (container != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Accessible[] accessibleArray2 = accessibleArray;
                        synchronized (accessibleArray) {
                            AccessibleComponent accessibleComponent;
                            AccessibleContext accessibleContext;
                            Point point = container.getLocationOnScreen();
                            Point point2 = new Point((int)((double)f - point.getX()), (int)((double)f2 - point.getY()));
                            Component component = container.findComponentAt(point2);
                            if (component != null && (accessibleContext = component.getAccessibleContext()) != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null) {
                                int n = accessibleContext.getAccessibleChildrenCount();
                                if (accessibleContext.getAccessibleText() != null) {
                                    accessibleArray[0] = (Accessible)((Object)component);
                                } else if (n > 0) {
                                    Point point3 = accessibleComponent.getLocationOnScreen();
                                    Point point4 = new Point((int)((double)f - point3.getX()), (int)((double)f2 - point3.getY()));
                                    accessibleArray[0] = accessibleComponent.getAccessibleAt(point4);
                                } else if (component instanceof Accessible) {
                                    accessibleArray[0] = (Accessible)((Object)component);
                                }
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, container);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Accessible[] accessibleArray2 = accessibleArray;
        synchronized (accessibleArray) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return accessibleArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibleAction getAccessibleAction(final Accessible accessible, Component component) {
        final AccessibleAction[] accessibleActionArray = new AccessibleAction[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        AccessibleAction[] accessibleActionArray2 = accessibleActionArray;
                        synchronized (accessibleActionArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                accessibleActionArray[0] = accessibleContext.getAccessibleAction();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AccessibleAction[] accessibleActionArray2 = accessibleActionArray;
        synchronized (accessibleActionArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return accessibleActionArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled(final Accessible accessible, Component component) {
        final boolean[] blArray = new boolean[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean[] blArray2 = blArray;
                        synchronized (blArray) {
                            AccessibleComponent accessibleComponent;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null) {
                                blArray[0] = accessibleComponent.isEnabled();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return blArray[0];
        }
    }

    public static void requestFocus(final Accessible accessible, Component component) {
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    public void run() {
                        AccessibleComponent accessibleComponent;
                        AccessibleContext accessibleContext = accessible.getAccessibleContext();
                        if (accessibleContext != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null) {
                            accessibleComponent.requestFocus();
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number getMaximumAccessibleValue(final Accessible accessible, Component component) {
        final Number[] numberArray = new Number[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Number[] numberArray2 = numberArray;
                        synchronized (numberArray) {
                            AccessibleValue accessibleValue;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleValue = accessibleContext.getAccessibleValue()) != null) {
                                numberArray[0] = accessibleValue.getMaximumAccessibleValue();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Number[] numberArray2 = numberArray;
        synchronized (numberArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return numberArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number getMinimumAccessibleValue(final Accessible accessible, Component component) {
        final Number[] numberArray = new Number[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Number[] numberArray2 = numberArray;
                        synchronized (numberArray) {
                            AccessibleValue accessibleValue;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleValue = accessibleContext.getAccessibleValue()) != null) {
                                numberArray[0] = accessibleValue.getMinimumAccessibleValue();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Number[] numberArray2 = numberArray;
        synchronized (numberArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return numberArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccessibleRoleDisplayString(final Accessible accessible, Component component) {
        final String[] stringArray = new String[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String[] stringArray2 = stringArray;
                        synchronized (stringArray) {
                            AccessibleRole accessibleRole;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleRole = accessibleContext.getAccessibleRole()) != null) {
                                stringArray[0] = accessibleRole.toDisplayString();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return stringArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSelectedText(final Accessible accessible, Component component) {
        final String[] stringArray = new String[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String[] stringArray2 = stringArray;
                        synchronized (stringArray) {
                            AccessibleText accessibleText;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleText = accessibleContext.getAccessibleText()) != null) {
                                stringArray[0] = accessibleText.getSelectedText();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return stringArray[0];
        }
    }

    public static void setSelectedText(final Accessible accessible, Component component, final String string) {
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    public void run() {
                        AccessibleEditableText accessibleEditableText;
                        AccessibleContext accessibleContext = accessible.getAccessibleContext();
                        if (accessibleContext != null && (accessibleEditableText = accessibleContext.getAccessibleEditableText()) != null) {
                            int n = accessibleEditableText.getSelectionStart();
                            int n2 = accessibleEditableText.getSelectionEnd();
                            accessibleEditableText.replaceText(n, n2, string);
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void setSelectedTextRange(final Accessible accessible, Component component, final int n, final int n2) {
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    public void run() {
                        AccessibleEditableText accessibleEditableText;
                        AccessibleContext accessibleContext = accessible.getAccessibleContext();
                        if (accessibleContext != null && (accessibleEditableText = accessibleContext.getAccessibleEditableText()) != null) {
                            boolean bl;
                            boolean bl2 = bl = n >= 0 && n2 >= n && n2 <= accessibleEditableText.getCharCount();
                            if (bl) {
                                accessibleEditableText.selectText(n, n2);
                            }
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number getCurrentAccessibleValue(final AccessibleValue accessibleValue, Component component) {
        final Number[] numberArray = new Number[1];
        if (accessibleValue != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Number[] numberArray2 = numberArray;
                        synchronized (numberArray) {
                            numberArray[0] = accessibleValue.getCurrentAccessibleValue();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Number[] numberArray2 = numberArray;
        synchronized (numberArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return numberArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextRange(final AccessibleEditableText accessibleEditableText, final int n, final int n2, Component component) {
        final String[] stringArray = new String[1];
        if (accessibleEditableText != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String[] stringArray2 = stringArray;
                        synchronized (stringArray) {
                            stringArray[0] = accessibleEditableText.getTextRange(n, n2);
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return stringArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getFocusOwner(Component component) {
        final Component[] componentArray = new Component[1];
        try {
            CToolkit.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Component[] componentArray2 = componentArray;
                    synchronized (componentArray) {
                        componentArray[0] = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Component[] componentArray2 = componentArray;
        synchronized (componentArray) {
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return componentArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCharacterIndexAtPosition(final Accessible accessible, Component component, final int n, final int n2) {
        final int[] nArray = new int[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int[] nArray2 = nArray;
                        synchronized (nArray) {
                            AccessibleText accessibleText;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleText = accessibleContext.getAccessibleText()) != null) {
                                Point point = accessibleContext.getAccessibleComponent().getLocationOnScreen();
                                int n3 = n - (int)point.getX();
                                int n22 = n2 - (int)point.getY();
                                nArray[0] = accessibleText.getIndexAtPoint(new Point(n3, n22));
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return nArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getSelectedTextRange(final Accessible accessible, Component component) {
        final int[] nArray = new int[2];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int[] nArray2 = nArray;
                        synchronized (nArray) {
                            AccessibleText accessibleText;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleText = accessibleContext.getAccessibleText()) != null) {
                                nArray[0] = accessibleText.getSelectionStart();
                                nArray[1] = accessibleText.getSelectionEnd();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getRangeForIndex(final Accessible accessible, Component component, final int n) {
        final int[] nArray = new int[2];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int[] nArray2 = nArray;
                        synchronized (nArray) {
                            int n4;
                            AccessibleEditableText accessibleEditableText;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleEditableText = accessibleContext.getAccessibleEditableText()) != null && n < (n4 = accessibleEditableText.getCharCount())) {
                                String string = accessibleEditableText.getAtIndex(2, n);
                                int n2 = string.length();
                                String string2 = accessibleEditableText.getTextRange(0, n4 - 1);
                                int n3 = -1;
                                for (int i = 0; n3 == -1 && i < n2; ++i) {
                                    if (string2.regionMatches(true, n - i, string, 0, n2)) {
                                        n3 = n - i;
                                    }
                                    if (!string2.regionMatches(true, n + i, string, 0, n2)) continue;
                                    n3 = n + i;
                                }
                                nArray[0] = n3;
                                nArray[1] = n2;
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int[] nArray2 = nArray;
        synchronized (nArray) {
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] getBoundsForRange(final Accessible accessible, Component component, final int n, final int n2) {
        final double[] dArray = new double[4];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        double[] dArray2 = dArray;
                        synchronized (dArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                                if (accessibleText != null) {
                                    Rectangle rectangle;
                                    Rectangle rectangle2 = accessibleText.getCharacterBounds(n);
                                    Rectangle2D rectangle2D = ((Rectangle2D)rectangle2).createUnion(rectangle = accessibleText.getCharacterBounds(n + n2 - 1));
                                    if (rectangle2D.isEmpty()) {
                                        dArray[3] = 0.0;
                                        dArray[2] = 0.0;
                                        dArray[1] = 0.0;
                                        dArray[0] = 0.0;
                                    } else {
                                        double d = rectangle2D.getX();
                                        double d2 = rectangle2D.getY();
                                        Point point = accessibleContext.getAccessibleComponent().getLocationOnScreen();
                                        double d3 = point.getX() + d;
                                        double d4 = point.getY() + d2;
                                        dArray[0] = d3;
                                        dArray[1] = d4;
                                        dArray[2] = rectangle2D.getWidth();
                                        dArray[3] = rectangle2D.getHeight();
                                    }
                                } else {
                                    String string = accessibleContext.getAccessibleName();
                                    AccessibleEditableText accessibleEditableText = accessibleContext.getAccessibleEditableText();
                                }
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        double[] dArray2 = dArray;
        synchronized (dArray) {
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringForRange(final Accessible accessible, Component component, final int n, final int n2) {
        final String[] stringArray = new String[1];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String[] stringArray2 = stringArray;
                        synchronized (stringArray) {
                            AccessibleEditableText accessibleEditableText;
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null && (accessibleEditableText = accessibleContext.getAccessibleEditableText()) != null) {
                                stringArray[0] = accessibleEditableText.getTextRange(n, n + n2);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String[] stringArray2 = stringArray;
        synchronized (stringArray) {
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return stringArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] getInitialAttributeStates(final Accessible accessible, Component component) {
        final boolean[] blArray = new boolean[7];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean[] blArray2 = blArray;
                        synchronized (blArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            if (accessibleContext != null) {
                                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                                blArray[0] = accessibleComponent != null;
                                blArray[1] = accessibleComponent != null && accessibleComponent.isFocusTraversable();
                                blArray[2] = accessibleContext.getAccessibleValue() != null;
                                blArray[3] = accessibleContext.getAccessibleText() != null;
                                AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
                                blArray[4] = accessibleStateSet.contains(AccessibleState.HORIZONTAL) || accessibleStateSet.contains(AccessibleState.VERTICAL);
                                blArray[5] = accessibleContext.getAccessibleName() != null;
                                blArray[6] = accessibleContext.getAccessibleChildrenCount() > 0;
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return blArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getChildrenAndRoles(final Accessible accessible, Component component, final int n, final boolean bl) {
        final Object[][] objectArray = new Object[1][];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object[][] objectArray2 = objectArray;
                        synchronized (objectArray) {
                            ArrayList arrayList = new ArrayList();
                            CAccessibility._addChildren(accessible, n, bl, arrayList);
                            objectArray[0] = n >= 0 && n * 2 < arrayList.size() ? new Object[]{arrayList.get(n * 2), arrayList.get(n * 2 + 1)} : arrayList.toArray();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Object[][] objectArray2 = objectArray;
        synchronized (objectArray) {
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return objectArray[0];
        }
    }

    private static void _addChildren(Accessible accessible, int n, boolean bl, ArrayList arrayList) {
        AccessibleContext accessibleContext;
        if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
            int n2 = accessibleContext.getAccessibleChildrenCount();
            for (int i = 0; i < n2; ++i) {
                Accessible accessible2 = accessibleContext.getAccessibleChild(i);
                boolean bl2 = true;
                if (n == -3) {
                    bl2 = accessible2.getAccessibleContext().getAccessibleComponent().isVisible();
                } else if (n == -2) {
                    bl2 = accessibleContext.getAccessibleSelection().isAccessibleChildSelected(i);
                }
                if (!bl2) continue;
                if (!bl && ignoredRoles.contains(CAccessibility.roleKey(accessible2.getAccessibleContext().getAccessibleRole()))) {
                    CAccessibility._addChildren(accessible2, n, false, arrayList);
                } else {
                    arrayList.add(accessible2);
                    arrayList.add(accessible2.getAccessibleContext().getAccessibleRole());
                }
                if (n < 0 || arrayList.size() / 2 < n + 1) continue;
                return;
            }
        }
    }

    private static native String roleKey(AccessibleRole var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getChildren(final Accessible accessible, Component component) {
        final Object[][] objectArray = new Object[1][];
        if (accessible != null) {
            try {
                CToolkit.invokeAndWait(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object[][] objectArray3 = objectArray;
                        synchronized (objectArray) {
                            AccessibleContext accessibleContext = accessible.getAccessibleContext();
                            int n = 0;
                            if (accessibleContext != null) {
                                n = accessibleContext.getAccessibleChildrenCount();
                            }
                            Object[] objectArray2 = new Object[n];
                            for (int i = 0; i < n; ++i) {
                                objectArray2[i] = accessibleContext.getAccessibleChild(i);
                            }
                            objectArray[0] = objectArray2;
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, component);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Object[][] objectArray2 = objectArray;
        synchronized (objectArray) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return objectArray[0];
        }
    }

    static {
        fFocusOwner = null;
        fFocusOwnerRole = null;
        fFocusOwnerIndexInParent = -1;
        fFocusOwnerContext = null;
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

