/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare.postprocessor;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class CircularDependencyDetector
implements IPostProcessor {
    private static final Logger a = LoggerFactory.getLogger(CircularDependencyDetector.class);
    private static final Marker b = MarkerFactory.getMarker((String)"circularDependency");
    protected final IMerger.Registry registry;
    protected final boolean mergeRightToLeft;

    public CircularDependencyDetector(@NonNull IMerger.Registry registry, boolean bl) {
        if (registry == null) {
            throw new NullPointerException("registry");
        }
        this.registry = registry;
        this.mergeRightToLeft = bl;
    }

    public static CircularDependencyDetector create(@NonNull IMerger.Registry registry, boolean bl) {
        if (registry == null) {
            throw new NullPointerException("registry");
        }
        return a.isDebugEnabled(b) ? new CircularDependencyDetector(registry, bl) : null;
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        EList eList = comparison.getDifferences();
        for (List<Diff> list : this.detect((EList<Diff>)eList)) {
            a.warn("Found circular merge dependency: {}", (Object)Lists.transform(list, diff -> eList.indexOf(diff) + 1));
        }
    }

    protected List<List<Diff>> detect(EList<Diff> eList) {
        Object object;
        Object object22;
        LinkedHashMap<Diff, Set<Diff>> linkedHashMap = new LinkedHashMap<Diff, Set<Diff>>();
        for (Object object22 : eList) {
            object = this.registry.getHighestRankingMerger(object22);
            if (!(object instanceof IMerger2)) continue;
            IMerger2 iMerger2 = (IMerger2)object;
            linkedHashMap.put((Diff)object22, iMerger2.getDirectMergeDependencies(object22, this.mergeRightToLeft));
        }
        ArrayList arrayList = new ArrayList();
        object22 = new ArrayDeque();
        object = new HashSet();
        for (Diff diff : linkedHashMap.keySet()) {
            this.detect(linkedHashMap, diff, (Deque<Diff>)object22, arrayList, (Set<Diff>)object);
            object.clear();
        }
        return arrayList;
    }

    protected void detect(Map<Diff, Set<Diff>> map, Diff diff, Deque<Diff> deque, List<List<Diff>> list, Set<Diff> set) {
        if (set.add(diff)) {
            deque.addLast(diff);
            for (Diff diff2 : map.getOrDefault(diff, Collections.emptySet())) {
                if (deque.size() > 1 && diff2 == deque.getFirst()) {
                    deque.addLast(diff2);
                    this.addPath(list, new ArrayList<Diff>(deque));
                    deque.removeLast();
                    continue;
                }
                this.detect(map, diff2, deque, list, set);
            }
            deque.removeLast();
        }
    }

    protected boolean addPath(List<List<Diff>> list, List<Diff> list2) {
        if (list2.stream().filter(diff -> !diff.eIsSet((EStructuralFeature)ComparePackage.Literals.DIFF__REFINED_BY)).count() < 2L) {
            return false;
        }
        if (!list.isEmpty()) {
            ArrayList<Diff> arrayList = new ArrayList<Diff>(list2);
            for (int i = 1; i < list2.size(); ++i) {
                Collections.rotate(arrayList, 1);
                if (!list.contains(arrayList)) continue;
                return false;
            }
        }
        return list.add(list2);
    }
}

