/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare.merge;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public enum MergeDirection {
    FORWARD,
    REVERSE{

        @Override
        public boolean ofKind(Diff diff, DifferenceKind differenceKind) {
            if (differenceKind == DifferenceKind.ADD) {
                return diff.getKind() == DifferenceKind.DELETE;
            }
            if (differenceKind == DifferenceKind.DELETE) {
                return diff.getKind() == DifferenceKind.ADD;
            }
            return diff.getKind() == differenceKind;
        }

        @Override
        public boolean isAddOrSetDiff(Diff diff) {
            return ComparisonUtil.isDeleteOrUnsetDiff((Diff)diff);
        }

        @Override
        public boolean isDeleteOrUnsetDiff(Diff diff) {
            return ComparisonUtil.isAddOrSetDiff((Diff)diff);
        }

        @Override
        public EList<Diff> getRequires(Diff diff) {
            return diff.getRequiredBy();
        }

        @Override
        public EList<Diff> getRequiredBy(Diff diff) {
            return diff.getRequires();
        }

        @Override
        public EList<Diff> getImplies(Diff diff) {
            return diff.getImpliedBy();
        }

        @Override
        public EList<Diff> getImpliedBy(Diff diff) {
            return diff.getImplies();
        }
    };


    public static MergeDirection of(Diff diff, boolean bl) {
        return diff.getSource() == DifferenceSource.LEFT != bl ? FORWARD : REVERSE;
    }

    public boolean ofKind(Diff diff, DifferenceKind differenceKind) {
        return diff.getKind() == differenceKind;
    }

    public boolean isAddOrSetDiff(Diff diff) {
        return ComparisonUtil.isAddOrSetDiff((Diff)diff);
    }

    public boolean isDeleteOrUnsetDiff(Diff diff) {
        return ComparisonUtil.isDeleteOrUnsetDiff((Diff)diff);
    }

    public EList<Diff> getRequires(Diff diff) {
        return diff.getRequires();
    }

    public EList<Diff> getRequiredBy(Diff diff) {
        return diff.getRequiredBy();
    }

    public EList<Diff> getImplies(Diff diff) {
        return diff.getImplies();
    }

    public EList<Diff> getImpliedBy(Diff diff) {
        return diff.getImpliedBy();
    }
}

