/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare.merge;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.astah.emf.compare.CompareBuilder;
import net.astah.emf.compare.ComparisonSource;
import net.astah.emf.compare.merge.AbstractGroupingMerger;
import net.astah.emf.compare.merge.a;
import net.astah.emf.compare.merge.b;
import net.astah.emf.edit.provider.ItemProviders;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.ViewerNotification;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class DiffGroup
extends AdapterImpl {
    public static final int DIFF_GROUP__DECISION = 0;
    public static final int DIFF_GROUP__SELECTED = 1;
    private final EList<Diff> b = new BasicEList.FastCompare();
    private final Set<DiffGroup> c = new HashSet<DiffGroup>();
    private final Set<DiffGroup> d = new HashSet<DiffGroup>();
    private Set<Match> e;
    private ComparisonSource f;
    private boolean g;

    public boolean isAdapterForType(Object object) {
        return object == DiffGroup.class;
    }

    private DiffGroup() {
    }

    public static void build(Comparison comparison, Monitor monitor) {
        if (monitor == null) {
            monitor = new BasicMonitor();
        }
        EList eList = comparison.getDifferences();
        monitor.beginTask("Analyzing comparison result", eList.size());
        for (Diff diff : eList) {
            DiffGroup.get(diff);
            monitor.worked(1);
        }
        monitor.done();
    }

    public static DiffGroup get(Diff diff) {
        return DiffGroup.get(diff, true);
    }

    public static DiffGroup get(Diff diff, boolean bl) {
        EList eList = diff.eAdapters();
        DiffGroup diffGroup = DiffGroup.findGroup((EList<Adapter>)eList);
        if (diffGroup != null || !bl) {
            return diffGroup;
        }
        DiffGroup diffGroup2 = new DiffGroup();
        eList.add((Object)diffGroup2);
        return diffGroup2;
    }

    public static boolean isVisible(Diff diff) {
        return !diff.eIsSet((EStructuralFeature)ComparePackage.Literals.DIFF__REFINES);
    }

    public EList<Diff> getDifferences() {
        return this.b;
    }

    public Stream<Diff> getAllDifferences() {
        return Stream.concat(this.getDifferences().stream(), this.getAllRequires().stream().flatMap(diffGroup -> diffGroup.getDifferences().stream()));
    }

    public Stream<Conflict> getConflicts() {
        return DiffGroup.a(this.getDifferences().stream());
    }

    public Stream<Conflict> getAllConflicts() {
        return DiffGroup.a(this.getAllDifferences());
    }

    static Stream<Conflict> a(Stream<Diff> stream) {
        return stream.map(Diff::getConflict).filter(Objects::nonNull).distinct();
    }

    public Set<Match> getMatches() {
        if (this.e == null) {
            Set set = Sets.newIdentityHashSet();
            for (Diff diff : this.b) {
                Match match = diff.getMatch();
                while (match instanceof Match && set.add(match)) {
                    match = match.eContainer();
                }
            }
            this.e = Collections.unmodifiableSet(set);
        }
        return this.e;
    }

    public Set<DiffGroup> getRequires() {
        return Collections.unmodifiableSet(this.c);
    }

    public Set<DiffGroup> getAllRequires() {
        HashSet<DiffGroup> hashSet = new HashSet<DiffGroup>();
        this.addAllRequires(hashSet);
        hashSet.remove((Object)this);
        return Collections.unmodifiableSet(hashSet);
    }

    protected void addAllRequires(Set<DiffGroup> set) {
        for (DiffGroup diffGroup : this.getRequires()) {
            if (!set.add(diffGroup)) continue;
            diffGroup.addAllRequires(set);
        }
    }

    public Set<DiffGroup> getRequiredBy() {
        return Collections.unmodifiableSet(this.d);
    }

    public Set<DiffGroup> getAllRequiredBy() {
        HashSet<DiffGroup> hashSet = new HashSet<DiffGroup>();
        this.addAllRequiredBy(hashSet);
        hashSet.remove((Object)this);
        return Collections.unmodifiableSet(hashSet);
    }

    protected void addAllRequiredBy(Set<DiffGroup> set) {
        for (DiffGroup diffGroup : this.getRequiredBy()) {
            if (!set.add(diffGroup)) continue;
            diffGroup.addAllRequiredBy(set);
        }
    }

    public ComparisonSource getDecision() {
        return this.f;
    }

    public void setDecision(ComparisonSource comparisonSource) {
        ComparisonSource comparisonSource2 = this.f;
        this.f = comparisonSource;
        if (comparisonSource2 != comparisonSource) {
            this.a((Notification)new a(this, 1, (Object)comparisonSource2, (Object)comparisonSource));
        }
    }

    public boolean isSelected() {
        return this.g;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.g;
        this.g = bl;
        if (bl2 != bl) {
            this.a((Notification)new b(this, 1, bl2, bl));
        }
    }

    public void setTarget(Notifier notifier) {
        super.setTarget(notifier);
        if (notifier instanceof Diff) {
            this.attach((Diff)notifier);
        }
    }

    public void unsetTarget(Notifier notifier) {
        if (notifier instanceof Diff) {
            this.detach((Diff)notifier);
        }
        super.unsetTarget(notifier);
    }

    protected void attach(Diff diff) {
        this.b.add((Object)diff);
        this.collectMembers(diff);
        this.collectDependencies(diff);
        this.invalidateCache();
    }

    protected void detach(Diff diff) {
        this.b.remove((Object)diff);
        this.invalidateCache();
    }

    protected static DiffGroup findGroup(EList<Adapter> eList) {
        for (Adapter adapter : eList) {
            if (!adapter.isAdapterForType(DiffGroup.class)) continue;
            return (DiffGroup)adapter;
        }
        return null;
    }

    protected void invalidateCache() {
        this.e = null;
    }

    protected void collectMembers(Diff diff) {
        assert (DiffGroup.findGroup((EList<Adapter>)diff.eAdapters()) != null);
        if (diff.eIsSet((EStructuralFeature)ComparePackage.Literals.DIFF__CONFLICT)) {
            this.a((EObject)diff.getConflict(), ComparePackage.Literals.CONFLICT__DIFFERENCES);
        }
    }

    private void a(EObject eObject, EReference eReference) {
        assert (eReference.isMany() && eReference.getEType() == ComparePackage.Literals.DIFF);
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            for (Object e : (List)eObject.eGet((EStructuralFeature)eReference)) {
                if (!(e instanceof Diff)) continue;
                Diff diff = (Diff)e;
                EList eList = diff.eAdapters();
                DiffGroup diffGroup = DiffGroup.findGroup((EList<Adapter>)eList);
                if (diffGroup == null) {
                    eList.add((Object)this);
                    continue;
                }
                assert (diffGroup == this);
            }
        }
    }

    protected void collectDependencies(Diff diff) {
        this.getAllDirectDependencies(diff, true).forEach(this::addDependency);
    }

    protected Set<Diff> getAllDirectDependencies(Diff diff, boolean bl) {
        IMerger iMerger = CompareBuilder.MERGER_REGISTRY.getHighestRankingMerger(diff);
        return AbstractGroupingMerger.a(iMerger, diff, bl);
    }

    protected void addDependency(Diff diff) {
        DiffGroup diffGroup = DiffGroup.get(diff);
        if (diffGroup != this && this.c.add(diffGroup)) {
            diffGroup.d.add(this);
        }
    }

    private void a(Notification notification) {
        for (Match match : this.getMatches()) {
            AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EObject)match);
            if (!(adapterFactory instanceof IChangeNotifier)) continue;
            ((IChangeNotifier)adapterFactory).fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)match, false, true));
        }
    }
}

