/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare.merge;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.astah.emf.compare.merge.IDependencyCollector;
import net.astah.emf.compare.merge.MergeDirection;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class DefaultDependencyCollector
implements IDependencyCollector {
    protected final Set<Diff> dependencies = new HashSet<Diff>();
    protected final boolean mergeRightToLeft;

    public DefaultDependencyCollector(boolean bl) {
        this.mergeRightToLeft = bl;
    }

    @Override
    public Set<Diff> collectDependencies(Diff diff) {
        Comparison comparison = diff.getMatch().getComparison();
        this.addRelationDependencies(diff);
        if (diff instanceof ReferenceChange) {
            ReferenceChange referenceChange = (ReferenceChange)diff;
            this.addReferenceChangeDependencies(comparison, referenceChange);
        } else if (diff instanceof AttributeChange) {
            AttributeChange attributeChange = (AttributeChange)diff;
            this.addAttributeChangeDependencies(comparison, attributeChange);
        }
        return this.dependencies;
    }

    protected void addRelationDependencies(Diff diff) {
        if (diff.eIsSet((EStructuralFeature)ComparePackage.Literals.DIFF__REFINES)) {
            this.dependencies.addAll((Collection<Diff>)diff.getRefines());
        }
        if (MergeDirection.of(diff, this.mergeRightToLeft) == MergeDirection.FORWARD) {
            if (diff.eIsSet((EStructuralFeature)ComparePackage.Literals.DIFF__IMPLIES)) {
                this.dependencies.addAll((Collection<Diff>)diff.getImplies());
            }
        } else if (diff.eIsSet((EStructuralFeature)ComparePackage.Literals.DIFF__IMPLIED_BY)) {
            this.dependencies.addAll((Collection<Diff>)diff.getImpliedBy());
        }
    }

    protected void addReferenceChangeDependencies(Comparison comparison, ReferenceChange referenceChange) {
        this.addContainmentRequiredDependencies(comparison, referenceChange);
        this.addSingleFeatureChangeDependencies(comparison, (Diff)referenceChange, (EStructuralFeature)referenceChange.getReference());
    }

    protected void addAttributeChangeDependencies(Comparison comparison, AttributeChange attributeChange) {
        this.addSingleFeatureChangeDependencies(comparison, (Diff)attributeChange, (EStructuralFeature)attributeChange.getAttribute());
    }

    protected void addContainmentRequiredDependencies(Comparison comparison, ReferenceChange referenceChange) {
        MergeDirection mergeDirection;
        EObject eObject = this.getContainmentValue(comparison, referenceChange);
        Match match = comparison.getMatch(eObject);
        if (match != null && (mergeDirection = MergeDirection.of((Diff)referenceChange, this.mergeRightToLeft)).isAddOrSetDiff((Diff)referenceChange)) {
            for (Diff diff2 : Iterables.filter((Iterable)match.getDifferences(), diff -> diff.getSource() == referenceChange.getSource() && mergeDirection.isAddOrSetDiff((Diff)diff) && diff instanceof ReferenceChange && this.a((EStructuralFeature)((ReferenceChange)diff).getReference()))) {
                EObject eObject2 = ((ReferenceChange)diff2).getValue();
                this.dependencies.add(diff2);
                Iterables.addAll(this.dependencies, (Iterable)Iterables.filter((Iterable)comparison.getDifferences(eObject2), diff -> diff.getSource() == referenceChange.getSource() && mergeDirection.isAddOrSetDiff((Diff)diff) && diff instanceof ReferenceChange && this.getContainmentValue(comparison, (ReferenceChange)diff) == eObject2));
            }
        }
    }

    protected void addSingleFeatureChangeDependencies(Comparison comparison, Diff diff, EStructuralFeature eStructuralFeature) {
        MergeDirection mergeDirection = MergeDirection.of(diff, this.mergeRightToLeft);
        if (!this.isMany(eStructuralFeature)) {
            if (mergeDirection.isAddOrSetDiff(diff)) {
                Iterables.addAll(this.dependencies, (Iterable)Iterables.filter((Iterable)diff.getMatch().getDifferences(), diff2 -> diff2 != diff && mergeDirection.isDeleteOrUnsetDiff((Diff)diff2) && diff2.getSource() == diff.getSource() && MatchUtil.getStructuralFeature((Diff)diff2) == eStructuralFeature));
            } else if (mergeDirection.isDeleteOrUnsetDiff(diff) && this.isRequired(eStructuralFeature)) {
                Iterator iterator = Iterables.filter((Iterable)diff.getMatch().getDifferences(), diff2 -> diff2 != diff && mergeDirection.isAddOrSetDiff((Diff)diff2) && diff2.getSource() == diff.getSource() && MatchUtil.getStructuralFeature((Diff)diff2) == eStructuralFeature).iterator();
                if (iterator.hasNext()) {
                    Iterators.addAll(this.dependencies, iterator);
                } else {
                    EObject eObject = MatchUtil.getContainer((Comparison)comparison, (Diff)diff);
                    Iterables.addAll(this.dependencies, (Iterable)Iterables.filter((Iterable)comparison.getDifferences(eObject), diff2 -> diff2.getSource() == diff.getSource() && mergeDirection.isDeleteOrUnsetDiff((Diff)diff2) && diff2 instanceof ReferenceChange && this.getContainmentValue(comparison, (ReferenceChange)diff2) == eObject));
                }
            }
        }
    }

    protected EObject getContainmentValue(Comparison comparison, ReferenceChange referenceChange) {
        EReference eReference = referenceChange.getReference();
        if (eReference.isContainment()) {
            return referenceChange.getValue();
        }
        return null;
    }

    protected boolean isMany(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.isMany();
    }

    protected boolean isRequired(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.isRequired();
    }

    private boolean a(EStructuralFeature eStructuralFeature) {
        return this.isRequired(eStructuralFeature) && !this.isMany(eStructuralFeature);
    }
}

