/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare.match;

import lombok.NonNull;
import net.astah.emf.compare.match.ComposeableDistanceFunction;
import net.astah.emf.compare.match.ComposedDistanceFunction;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class DistinguishingDistance
implements ComposeableDistanceFunction {
    private static final Logger a = LoggerFactory.getLogger(DistinguishingDistance.class);
    protected final boolean deterministic;
    protected ComposedDistanceFunction parentMeter;

    public DistinguishingDistance() {
        this(true);
    }

    public DistinguishingDistance(boolean bl) {
        this.deterministic = bl;
    }

    public double distance(Comparison comparison, EObject eObject, EObject eObject2) {
        if (this.isDistinguishable(comparison, eObject, eObject2)) {
            if (this.distinguish(comparison, eObject, eObject2)) {
                a.trace("{} and {} are identic", (Object)eObject, (Object)eObject2);
                return 0.0;
            }
            a.trace("{} and {} are not identic", (Object)eObject, (Object)eObject2);
            if (this.parentMeter != null && this.deterministic) {
                return Double.POSITIVE_INFINITY;
            }
        }
        return Double.MAX_VALUE;
    }

    public boolean areIdentic(@NonNull Comparison comparison, EObject eObject, EObject eObject2) {
        if (comparison == null) {
            throw new NullPointerException("inProgress");
        }
        if (this.isDistinguishable(comparison, eObject, eObject2)) {
            if (this.distinguish(comparison, eObject, eObject2)) {
                a.trace("{} and {} are identic", (Object)eObject, (Object)eObject2);
                return true;
            }
            a.trace("{} and {} are not identic", (Object)eObject, (Object)eObject2);
            return false;
        }
        return false;
    }

    @Override
    public void setParentDistanceFunction(ComposedDistanceFunction composedDistanceFunction) {
        this.parentMeter = composedDistanceFunction;
    }

    protected boolean isDistinguishable(Comparison comparison, EObject eObject, EObject eObject2) {
        return this.isDistinguishable(eObject) && this.isDistinguishable(eObject2);
    }

    protected boolean isDistinguishable(EObject eObject) {
        return eObject instanceof InternalEObject && this.getDistinguishableFeature((EObject)eObject.eClass()) != null;
    }

    protected boolean distinguish(Comparison comparison, EObject eObject, EObject eObject2) {
        Object object;
        EObject eObject3;
        EObject eObject4;
        if (!this.isCompatibleWith(eObject, eObject2)) {
            return false;
        }
        EStructuralFeature eStructuralFeature = this.getDistinguishableFeature(eObject);
        if (eStructuralFeature == null || !eStructuralFeature.getEContainingClass().isInstance((Object)eObject2)) {
            return false;
        }
        IEqualityHelper iEqualityHelper = comparison.getEqualityHelper();
        if (!iEqualityHelper.matchingValues((Object)(eObject4 = this.getContainer(eObject)), (Object)(eObject3 = this.getContainer(eObject2)))) {
            return false;
        }
        Object object2 = ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eStructuralFeature);
        return iEqualityHelper.matchingAttributeValues(object2, object = ReferenceUtil.safeEGet((EObject)eObject2, (EStructuralFeature)eStructuralFeature));
    }

    protected EObject getContainer(EObject eObject) {
        return ((InternalEObject)eObject).eInternalContainer();
    }

    protected EStructuralFeature getDistinguishableFeature(EObject eObject) {
        EClassifier eClassifier;
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature("name");
        if (eStructuralFeature != null && (eClassifier = eStructuralFeature.getEType()) != null && eClassifier.getInstanceClass() == String.class) {
            return eStructuralFeature;
        }
        return null;
    }

    protected boolean isCompatibleWith(EObject eObject, EObject eObject2) {
        EClass eClass;
        EClass eClass2 = eObject.eClass();
        return eClass2.isSuperTypeOf(eClass = eObject2.eClass()) || !eClass.isSuperTypeOf(eClass2);
    }

    protected boolean matchingValues(IEqualityHelper iEqualityHelper, EObject eObject, EObject eObject2, EReference eReference) {
        Object object = ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eReference);
        Object object2 = ReferenceUtil.safeEGet((EObject)eObject2, (EStructuralFeature)eReference);
        return iEqualityHelper.matchingValues(object, object2);
    }

    protected boolean matchingValues(IEqualityHelper iEqualityHelper, EObject eObject, EObject eObject2, EAttribute eAttribute) {
        if (!eAttribute.isUnsettable() || ReferenceUtil.safeEIsSet((EObject)eObject, (EStructuralFeature)eAttribute) == ReferenceUtil.safeEIsSet((EObject)eObject2, (EStructuralFeature)eAttribute)) {
            Object object = ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eAttribute);
            Object object2 = ReferenceUtil.safeEGet((EObject)eObject2, (EStructuralFeature)eAttribute);
            return iEqualityHelper.matchingAttributeValues(object, object2);
        }
        return false;
    }
}

