/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare.match;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.astah.emf.compare.match.ComposeableDistanceFunction;
import net.astah.emf.compare.match.DistanceFunctionDescriptor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.ecore.EObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class ComposedDistanceFunction
implements ComposeableDistanceFunction {
    protected List<ProximityEObjectMatcher.DistanceFunction> meters = new ArrayList<ProximityEObjectMatcher.DistanceFunction>();
    protected ComposedDistanceFunction parentMeter;

    public double distance(Comparison comparison, EObject eObject, EObject eObject2) {
        boolean bl = false;
        for (ProximityEObjectMatcher.DistanceFunction distanceFunction : this.meters) {
            if (bl) {
                if (!distanceFunction.areIdentic(comparison, eObject, eObject2)) continue;
                return 0.0;
            }
            double d = distanceFunction.distance(comparison, eObject, eObject2);
            if (d == Double.MAX_VALUE) continue;
            if (Double.isInfinite(d)) {
                bl = true;
                continue;
            }
            return d;
        }
        return Double.MAX_VALUE;
    }

    public boolean areIdentic(Comparison comparison, EObject eObject, EObject eObject2) {
        for (ProximityEObjectMatcher.DistanceFunction distanceFunction : this.meters) {
            if (!distanceFunction.areIdentic(comparison, eObject, eObject2)) continue;
            return true;
        }
        return false;
    }

    public void insertDistanceFunction(@NonNull ProximityEObjectMatcher.DistanceFunction distanceFunction) {
        if (distanceFunction == null) {
            throw new NullPointerException("meter");
        }
        if (!this.meters.contains(distanceFunction)) {
            this.meters.add(0, distanceFunction);
            if (distanceFunction instanceof ComposeableDistanceFunction) {
                ((ComposeableDistanceFunction)distanceFunction).setParentDistanceFunction(this);
            }
        }
    }

    public void addDistanceFunction(@NonNull ProximityEObjectMatcher.DistanceFunction distanceFunction) {
        if (distanceFunction == null) {
            throw new NullPointerException("meter");
        }
        if (!this.meters.contains(distanceFunction)) {
            this.meters.add(distanceFunction);
            if (distanceFunction instanceof ComposeableDistanceFunction) {
                ((ComposeableDistanceFunction)distanceFunction).setParentDistanceFunction(this);
            }
        }
    }

    public void removeDistanceFunction(ProximityEObjectMatcher.DistanceFunction distanceFunction) {
        if (this.meters.contains(distanceFunction)) {
            this.meters.remove(distanceFunction);
            if (distanceFunction instanceof ComposeableDistanceFunction) {
                ((ComposeableDistanceFunction)distanceFunction).setParentDistanceFunction(null);
            }
        }
    }

    public ComposedDistanceFunction getRootDistanceFunction() {
        return this.parentMeter == null ? this : this.parentMeter.getRootDistanceFunction();
    }

    @Override
    public void setParentDistanceFunction(ComposedDistanceFunction composedDistanceFunction) {
        this.parentMeter = composedDistanceFunction;
    }

    public void register(DistanceFunctionDescriptor.Registry registry) {
        registry.getDistanceFunctions().stream().forEach(this::addDistanceFunction);
    }
}

