/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.Objects;
import net.astah.golf.model.IEntityStore;
import net.astah.project.ProjectManagerAdapter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IDisposable;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class ProjectComparisonScope
extends DefaultComparisonScope
implements IDisposable {
    protected final IEntityStore leftProject;
    protected IEntityStore rightProject;
    protected IEntityStore originProject;
    protected File rightFile;
    protected File originFile;

    public ProjectComparisonScope(IEntityStore iEntityStore) {
        super(null, null, null);
        this.leftProject = Objects.requireNonNull(iEntityStore, "entityStore");
    }

    public void open(IProgressMonitor iProgressMonitor) throws Exception {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)((this.rightFile != null ? 1 : 0) + (this.originFile != null ? 1 : 0)));
        if (this.rightFile != null) {
            this.rightProject.open(this.rightFile.getAbsolutePath(), (IProgressMonitor)subMonitor.newChild(1));
        }
        if (this.originFile != null) {
            this.originProject.open(this.originFile.getAbsolutePath(), (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public void dispose() {
        if (this.rightProject instanceof IDisposable) {
            ((IDisposable)this.rightProject).dispose();
        }
        this.rightProject = null;
        this.rightFile = null;
        if (this.originProject instanceof IDisposable) {
            ((IDisposable)this.originProject).dispose();
        }
        this.originProject = null;
        this.originFile = null;
    }

    public IEntityStore getLeftProject() {
        return this.leftProject;
    }

    public IEntityStore getRightProject() {
        return this.rightProject;
    }

    public IEntityStore getOriginProject() {
        return this.originProject;
    }

    public Notifier getLeft() {
        return this.getModelResource(this.leftProject);
    }

    public Notifier getRight() {
        return this.getModelResource(this.rightProject);
    }

    public Notifier getOrigin() {
        return this.getModelResource(this.originProject);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(((Object)((Object)this)).getClass());
        toStringHelper.add("left", (Object)this.leftProject.getName());
        if (this.rightFile != null) {
            toStringHelper.add("right", (Object)this.rightFile);
        }
        if (this.originFile != null) {
            toStringHelper.add("origin", (Object)this.originFile);
        }
        return toStringHelper.toString();
    }

    public void setRight(IEntityStore iEntityStore, File file) {
        Objects.requireNonNull(iEntityStore, "rightProject");
        this.rightProject = iEntityStore;
        this.rightFile = file;
    }

    public void setOrigin(IEntityStore iEntityStore, File file) {
        Objects.requireNonNull(iEntityStore, "originProject");
        this.originProject = iEntityStore;
        this.originFile = file;
    }

    protected Resource getModelResource(IEntityStore iEntityStore) {
        if (iEntityStore != null) {
            ResourceSet resourceSet = iEntityStore.getDomain().getResourceSet();
            ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter((ResourceSet)resourceSet);
            return (Resource)projectManagerAdapter.getRootProject().getResources().get(0);
        }
        return null;
    }
}

