/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.astah.emf.compare.CompareBuilder;
import net.astah.emf.compare.ComparisonSource;
import net.astah.emf.compare.Messages;
import net.astah.emf.edit.job.TransactionalJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class MergeJob
extends TransactionalJob {
    protected final Map<Diff, ComparisonSource> decision;
    protected IMerger.Registry registry = CompareBuilder.MERGER_REGISTRY;

    public MergeJob(TransactionalEditingDomain transactionalEditingDomain, Map<Diff, ComparisonSource> map) {
        super(transactionalEditingDomain, Messages.MergeJob_name);
        this.decision = Objects.requireNonNull(map, "decision");
    }

    public IMerger.Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(IMerger.Registry registry) {
        this.registry = registry;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        try {
            this.runWritable(() -> this.doExecute(iProgressMonitor));
            return Status.OK_STATUS;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        catch (RollbackException rollbackException) {
            IStatus[] iStatusArray = new IStatus[]{rollbackException.getStatus()};
            return new MultiStatus("<N/A>", 0, iStatusArray, Messages.MergeJob_rolledback, (Throwable)rollbackException);
        }
        catch (ExecutionException executionException) {
            return new Status(4, "<N/A>", Messages.MergeJob_unexpectedError, executionException.getCause());
        }
    }

    protected void doExecute(IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)this.decision.size());
        this.decision.forEach((diff, comparisonSource) -> this.doMerge((Diff)diff, (ComparisonSource)((Object)comparisonSource), (IProgressMonitor)subMonitor.newChild(1)));
        subMonitor.done();
    }

    protected void doMerge(Diff diff, ComparisonSource comparisonSource, IProgressMonitor iProgressMonitor) {
        Monitor monitor = BasicMonitor.toMonitor((IProgressMonitor)iProgressMonitor);
        IMerger iMerger = this.registry.getHighestRankingMerger(diff);
        if (comparisonSource == ComparisonSource.RIGHT) {
            iMerger.copyRightToLeft(diff, monitor);
        } else if (comparisonSource == ComparisonSource.LEFT) {
            iMerger.copyLeftToRight(diff, monitor);
        }
    }
}

