/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;

public enum ComparisonSource {
    LEFT(DifferenceSource.LEFT),
    RIGHT(DifferenceSource.RIGHT),
    ORIGIN(null);

    private final DifferenceSource differenceSource;
    private ComparisonSource opposite;

    private ComparisonSource(DifferenceSource differenceSource) {
        this.differenceSource = differenceSource;
    }

    public DifferenceSource differenceSource() {
        return this.differenceSource;
    }

    public ComparisonSource opposite() {
        return this.opposite;
    }

    public EObject get(Match match) {
        switch (this) {
            case LEFT: {
                return match.getLeft();
            }
            case RIGHT: {
                return match.getRight();
            }
            case ORIGIN: {
                return match.getOrigin();
            }
        }
        throw new AssertionError();
    }

    public EObject getOpposite(Match match) {
        switch (this) {
            case LEFT: {
                return match.getRight();
            }
            case RIGHT: {
                return match.getLeft();
            }
            case ORIGIN: {
                return null;
            }
        }
        throw new AssertionError();
    }

    public Notifier get(IComparisonScope iComparisonScope) {
        switch (this) {
            case LEFT: {
                return iComparisonScope.getLeft();
            }
            case RIGHT: {
                return iComparisonScope.getRight();
            }
            case ORIGIN: {
                return iComparisonScope.getOrigin();
            }
        }
        throw new AssertionError();
    }

    public Notifier getOpposite(IComparisonScope iComparisonScope) {
        switch (this) {
            case LEFT: {
                return iComparisonScope.getRight();
            }
            case RIGHT: {
                return iComparisonScope.getLeft();
            }
            case ORIGIN: {
                return null;
            }
        }
        throw new AssertionError();
    }

    static {
        ComparisonSource.LEFT.opposite = RIGHT;
        ComparisonSource.RIGHT.opposite = LEFT;
    }
}

