/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.compare;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import net.astah.emf.compare.CompareBuilder;
import net.astah.emf.compare.Messages;
import net.astah.emf.compare.ProjectComparisonScope;
import net.astah.emf.compare.merge.DiffGroup;
import net.astah.emf.compare.postprocessor.CircularDependencyDetector;
import net.astah.emf.edit.job.TransactionalJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class CompareJob
extends TransactionalJob {
    private static final Logger a = LoggerFactory.getLogger(CompareJob.class);
    private static final Marker b = MarkerFactory.getMarker((String)"compare");
    protected final IComparisonScope scope;
    protected Comparison comparison;

    public CompareJob(TransactionalEditingDomain transactionalEditingDomain, IComparisonScope iComparisonScope) {
        super(transactionalEditingDomain, Messages.CompareJob_name);
        this.setPriority(10);
        this.scope = Objects.requireNonNull(iComparisonScope, "scope");
    }

    public IComparisonScope getScope() {
        return this.scope;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        try {
            this.comparison = (Comparison)this.runExclusive(() -> this.doExecute(iProgressMonitor));
            Diagnostic diagnostic = this.comparison.getDiagnostic();
            if (diagnostic == null) {
                return Status.OK_STATUS;
            }
            return BasicDiagnostic.toIStatus((Diagnostic)diagnostic);
        }
        catch (InterruptedException | CancellationException exception) {
            return Status.CANCEL_STATUS;
        }
        catch (ExecutionException executionException) {
            return new Status(4, "<N/A>", Messages.CompareJob_compareFailed, executionException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Comparison doExecute(IProgressMonitor iProgressMonitor) throws Exception {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)10);
        try {
            this.openProjects((IProgressMonitor)subMonitor.newChild(1));
            Comparison comparison = this.doCompare((IProgressMonitor)subMonitor.newChild(8));
            this.analyzeComparison(comparison, (IProgressMonitor)subMonitor.newChild(1));
            Comparison comparison2 = comparison;
            return comparison2;
        }
        finally {
            subMonitor.done();
        }
    }

    protected void openProjects(IProgressMonitor iProgressMonitor) throws Exception {
        a.debug(b, "Preparing comparison scope: {}", (Object)this.scope);
        if (this.scope instanceof ProjectComparisonScope) {
            ((ProjectComparisonScope)this.scope).open(iProgressMonitor);
        }
        SubMonitor.done((IProgressMonitor)iProgressMonitor);
    }

    protected Comparison doCompare(IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        EMFCompare eMFCompare = new CompareBuilder().build();
        subMonitor.worked(1);
        Comparison comparison = eMFCompare.compare(this.scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(99)));
        if (a.isTraceEnabled(b)) {
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("PROCESS_DANGLING_HREF", "DISCARD");
                hashMap.put("ROOT_OBJECTS", Arrays.asList(comparison));
                StringWriter stringWriter = new StringWriter();
                new XMIResourceImpl(URI.createURI((String)"")).save((Writer)stringWriter, hashMap);
                a.trace(b, "Comparison result: {}", (Object)stringWriter);
            }
            catch (IOException iOException) {
                a.error("Failed to dump comparison to XMI", (Throwable)iOException);
            }
        }
        return comparison;
    }

    protected void analyzeComparison(Comparison comparison, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        DiffGroup.build(comparison, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(95)));
        CircularDependencyDetector circularDependencyDetector = CircularDependencyDetector.create(CompareBuilder.MERGER_REGISTRY, true);
        if (circularDependencyDetector != null) {
            circularDependencyDetector.postComparison(comparison, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(5)));
        }
    }
}

