/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml.provider.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.astah.uml2.uml.InstanceSpecifications;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class SynchronizeInstanceCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected InstanceSpecification owner;

    public SynchronizeInstanceCommand(EditingDomain editingDomain, InstanceSpecification instanceSpecification) {
        this.domain = editingDomain;
        this.owner = instanceSpecification;
    }

    protected boolean prepare() {
        this.prepareCommand();
        return super.prepare();
    }

    protected void prepareCommand() {
        if (this.domain == null || this.owner == null) {
            return;
        }
        if (this.owner.eIsSet((EStructuralFeature)UMLPackage.Literals.INSTANCE_SPECIFICATION__CLASSIFIER)) {
            if (this.synchronizeInstanceSlots(this.owner)) {
                this.synchronizeAssociation(this.owner);
            } else {
                this.clearClassifiers(this.owner);
            }
        } else {
            this.clearSlots(this.owner);
        }
    }

    protected void synchronizeAssociation(InstanceSpecification instanceSpecification) {
        for (Classifier classifier : instanceSpecification.getClassifiers()) {
            if (!(classifier instanceof Association) || !InstanceSpecifications.isLink((InstanceSpecification)instanceSpecification)) continue;
            String string = classifier.getName();
            if (Objects.equals(string, instanceSpecification.getName())) break;
            this.append(SetCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)UMLPackage.Literals.NAMED_ELEMENT__NAME, (Object)string));
            break;
        }
    }

    protected boolean synchronizeInstanceSlots(InstanceSpecification instanceSpecification) {
        BasicEList.FastCompare fastCompare = new BasicEList.FastCompare((Collection)instanceSpecification.getSlots());
        UniqueEList.FastCompare fastCompare2 = new UniqueEList.FastCompare();
        for (Classifier classifier : instanceSpecification.getClassifiers()) {
            for (StructuralFeature structuralFeature : this.a(instanceSpecification, classifier)) {
                int n = fastCompare2.size();
                if (this.a(classifier, structuralFeature) || !fastCompare2.add(structuralFeature)) continue;
                this.synchronizeInstanceSlot(instanceSpecification, (EList<Slot>)fastCompare, classifier, structuralFeature, n);
            }
        }
        if (!fastCompare.isEmpty()) {
            if (fastCompare.stream().anyMatch(InstanceSpecifications::hasInstanceValue)) {
                this.commandList.clear();
                return false;
            }
            this.append(RemoveCommand.create((EditingDomain)this.domain, (Object)instanceSpecification, (Object)UMLPackage.Literals.INSTANCE_SPECIFICATION__SLOT, (Collection)fastCompare));
        }
        return true;
    }

    protected void synchronizeInstanceSlot(InstanceSpecification instanceSpecification, EList<Slot> eList, Classifier classifier, StructuralFeature structuralFeature, int n) {
        int n2 = this.a((List<Slot>)eList, classifier, structuralFeature);
        if (n2 >= 0) {
            Slot slot = (Slot)eList.remove(n2);
            if (slot.getDefiningFeature() != structuralFeature) {
                this.append(SetCommand.create((EditingDomain)this.domain, (Object)slot, (Object)UMLPackage.Literals.SLOT__DEFINING_FEATURE, (Object)structuralFeature));
            }
            if (n2 > 0) {
                this.append(MoveCommand.create((EditingDomain)this.domain, (Object)instanceSpecification, (Object)UMLPackage.Literals.INSTANCE_SPECIFICATION__SLOT, (Object)slot, (int)n));
            }
        } else {
            Slot slot = UMLFactory.eINSTANCE.createSlot();
            slot.setDefiningFeature(structuralFeature);
            this.append(AddCommand.create((EditingDomain)this.domain, (Object)instanceSpecification, (Object)UMLPackage.Literals.INSTANCE_SPECIFICATION__SLOT, (Object)slot));
        }
    }

    protected void clearClassifiers(InstanceSpecification instanceSpecification) {
        this.append(SetCommand.create((EditingDomain)this.domain, (Object)instanceSpecification, (Object)UMLPackage.Literals.NAMED_ELEMENT__NAME, (Object)SetCommand.UNSET_VALUE));
        this.append(RemoveCommand.create((EditingDomain)this.domain, (Object)instanceSpecification, (Object)UMLPackage.Literals.INSTANCE_SPECIFICATION__CLASSIFIER, (Collection)Lists.newArrayList((Iterable)instanceSpecification.getClassifiers())));
        this.clearSlots(instanceSpecification);
    }

    protected void clearSlots(InstanceSpecification instanceSpecification) {
        ArrayList arrayList = Lists.newArrayList((Iterable)instanceSpecification.getSlots());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (!InstanceSpecifications.hasInstanceValue((Slot)slot)) continue;
            if (slot.getDefiningFeature() != null) {
                this.append(SetCommand.create((EditingDomain)this.domain, (Object)slot, (Object)UMLPackage.Literals.SLOT__DEFINING_FEATURE, (Object)SetCommand.UNSET_VALUE));
            }
            iterator.remove();
        }
        if (!arrayList.isEmpty()) {
            this.append(RemoveCommand.create((EditingDomain)this.domain, (Object)instanceSpecification, (Object)UMLPackage.Literals.INSTANCE_SPECIFICATION__SLOT, (Collection)arrayList));
        }
    }

    protected boolean validateSlot(Slot slot, StructuralFeature structuralFeature) {
        if (slot.eIsSet((EStructuralFeature)UMLPackage.Literals.SLOT__VALUE)) {
            Type type = structuralFeature.getType();
            return slot.getValues().stream().allMatch(valueSpecification -> this.validateValue((ValueSpecification)valueSpecification, type));
        }
        return true;
    }

    protected boolean validateValue(ValueSpecification valueSpecification, Type type) {
        return !(valueSpecification instanceof InstanceValue) || this.isInstance(valueSpecification, type);
    }

    protected boolean isInstance(Slot slot, StructuralFeature structuralFeature) {
        Type type = structuralFeature.getType();
        return slot.getValues().stream().allMatch(valueSpecification -> this.isInstance((ValueSpecification)valueSpecification, type));
    }

    protected boolean isInstance(ValueSpecification valueSpecification, Type type) {
        InstanceSpecification instanceSpecification;
        return valueSpecification instanceof InstanceValue && (instanceSpecification = ((InstanceValue)valueSpecification).getInstance()) != null && instanceSpecification.getClassifiers().stream().anyMatch(classifier -> classifier.conformsTo(type));
    }

    private Iterable<? extends StructuralFeature> a(InstanceSpecification instanceSpecification, Classifier classifier) {
        boolean bl = InstanceSpecifications.isLink((InstanceSpecification)instanceSpecification);
        if (bl && classifier instanceof AssociationClass) {
            return ((AssociationClass)classifier).getMemberEnds();
        }
        Comparator<StructuralFeature> comparator = this.a(classifier);
        return () -> classifier.allSlottableFeatures().stream().filter(structuralFeature -> bl || this.a((StructuralFeature)structuralFeature)).sorted(comparator).iterator();
    }

    private boolean a(StructuralFeature structuralFeature) {
        if (structuralFeature instanceof Property) {
            return ((Property)structuralFeature).getAssociation() == null;
        }
        return true;
    }

    private boolean a(Classifier classifier, StructuralFeature structuralFeature) {
        for (EStructuralFeature.Setting setting : UML2Util.getInverseReferences((EObject)structuralFeature)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof StructuralFeature) || !((StructuralFeature)eObject).getRedefinedElements().contains((Object)structuralFeature) || !classifier.allSlottableFeatures().contains((Object)eObject)) continue;
            return true;
        }
        return false;
    }

    private Comparator<StructuralFeature> a(Classifier classifier) {
        EList eList = classifier.allParents();
        return (structuralFeature, structuralFeature2) -> eList.indexOf((Object)structuralFeature2.getOwner()) - eList.indexOf((Object)structuralFeature.getOwner());
    }

    private int a(List<Slot> list, Classifier classifier, StructuralFeature structuralFeature) {
        Property property;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Slot slot = list.get(i);
            if (slot.getDefiningFeature() != structuralFeature) continue;
            return this.validateSlot(slot, structuralFeature) ? i : -1;
        }
        if (structuralFeature instanceof Property && (property = (Property)structuralFeature).getAssociation() == classifier) {
            for (int i = 0; i < n; ++i) {
                if (!this.isInstance(list.get(i), structuralFeature)) continue;
                return i;
            }
        }
        return -1;
    }
}

