/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml.provider;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.astah.emf.common.notify.Notifiers;
import net.astah.emf.common.resource.Resources;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.uml2.UML2Ecore;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class UMLStereotypeApplicationAdapter
extends EContentAdapter {
    private static final Logger a = LoggerFactory.getLogger(UMLStereotypeApplicationAdapter.class);
    private static final Marker b = MarkerFactory.getMarker((String)"notificationDetail");
    private final Map<EClass, Boolean> c = new WeakHashMap<EClass, Boolean>();

    protected void selfAdapt(Notification notification) {
        super.selfAdapt(notification);
        if (!notification.isTouch()) {
            Object object = notification.getNotifier();
            if (object instanceof Resource) {
                this.handleResource((Resource)object, notification);
            } else if (object instanceof EObject) {
                this.handleEObject((EObject)object, notification);
            }
        }
    }

    protected void setTarget(Resource resource) {
        if (this.isTargetResource(resource)) {
            super.setTarget(resource);
        }
    }

    protected boolean isTargetResource(Resource resource) {
        URI uRI = resource.getURI();
        return uRI == null || !"pathmap".equals(uRI.scheme());
    }

    protected void addAdapter(Notifier notifier) {
        InternalEObject internalEObject;
        Resource.Internal internal;
        if (!(!(notifier instanceof InternalEObject) || (internal = (internalEObject = (InternalEObject)notifier).eDirectResource()) != null && this.isTargetResource((Resource)internal) && this.isStereotypeInstance((EObject)internalEObject))) {
            return;
        }
        super.addAdapter(notifier);
    }

    protected void unsetTarget(EObject eObject) {
        super.unsetTarget(eObject);
        Notifiers.removeAdapterIf((Notifier)eObject, ECrossReferenceAdapter.class::isInstance);
    }

    protected void handleResource(Resource resource, Notification notification) {
        if (notification.getFeatureID(Resource.class) == 2 && this.isTargetResource(resource)) {
            switch (notification.getEventType()) {
                case 3: {
                    this.redirectToBaseElement(notification.getNewValue(), notification);
                    break;
                }
                case 5: {
                    for (Object e : (List)notification.getNewValue()) {
                        this.redirectToBaseElement(e, notification);
                    }
                    break;
                }
                case 4: {
                    this.redirectToBaseElement(notification.getOldValue(), notification);
                    break;
                }
                case 6: {
                    for (Object e : (List)notification.getOldValue()) {
                        this.redirectToBaseElement(e, notification);
                    }
                    break;
                }
            }
        }
    }

    protected void handleEObject(EObject eObject, Notification notification) {
        if (this.isMetaclassRoleChange(notification) && !Resources.isLoading((Resource)eObject.eResource())) {
            Object object;
            Object object2 = notification.getOldValue();
            if (object2 instanceof Element) {
                a.debug(b, "Stereotype Application {} is detached from {}.", notification.getNotifier(), object2);
                this.redirectTo((Element)object2, notification);
            }
            if ((object = notification.getNewValue()) instanceof Element) {
                a.debug(b, "Stereotype Application {} is attached to {}.", notification.getNotifier(), object);
                this.redirectTo((Element)object, notification);
            }
        }
    }

    protected void redirectToBaseElement(Object object, Notification notification) {
        Element element;
        if (object instanceof EObject && (element = UML2Ecore.getBaseElement((EObject)((EObject)object))) != null) {
            this.redirectTo(element, notification);
        }
    }

    protected void redirectTo(Element element, Notification notification) {
        IChangeNotifier iChangeNotifier = this.getChangeNotifier((EObject)element);
        if (iChangeNotifier != null) {
            ViewerNotification viewerNotification = new ViewerNotification(notification, (Object)element);
            a.trace(b, "Redirect {} to {}", (Object)viewerNotification, (Object)element);
            iChangeNotifier.fireNotifyChanged((Notification)viewerNotification);
        }
    }

    protected IChangeNotifier getChangeNotifier(EObject eObject) {
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EObject)eObject);
        if (adapterFactory != null) {
            Adapter adapter = adapterFactory.adapt((Notifier)eObject, IEditingDomainItemProvider.class);
            if (adapter instanceof IChangeNotifier) {
                return (IChangeNotifier)adapter;
            }
            if (adapterFactory instanceof IChangeNotifier) {
                return (IChangeNotifier)adapterFactory;
            }
        }
        return null;
    }

    protected boolean isMetaclassRoleChange(Notification notification) {
        EReference eReference;
        Object object;
        if (notification.getEventType() == 1 && (object = notification.getFeature()) instanceof EReference && UMLStereotypeApplicationAdapter.a(eReference = (EReference)object)) {
            return UMLStereotypeApplicationAdapter.a(eReference.getEContainingClass());
        }
        return false;
    }

    protected boolean isStereotypeInstance(EObject eObject) {
        return this.c.computeIfAbsent(eObject.eClass(), eClass -> UMLStereotypeApplicationAdapter.a(eClass) && eClass.getEAllReferences().stream().anyMatch(UMLStereotypeApplicationAdapter::a));
    }

    static boolean a(EClass eClass) {
        EPackage ePackage = eClass.getEPackage();
        return UML2Ecore.isProfileDefinition((EPackage)ePackage);
    }

    static boolean a(EReference eReference) {
        if (eReference.getName().startsWith("base_")) {
            EClass eClass = (EClass)eReference.getEType();
            return UMLPackage.Literals.ELEMENT.isSuperTypeOf(eClass);
        }
        return false;
    }
}

