/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml.provider;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.astah.dd.di.Diagram;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLInteractionDiagram;
import net.astah.jmodel.UMLStateChartDiagram;
import net.astah.model.operations.DiagramOperations;
import net.astah.uml2.uml.Associations;
import net.astah.uml2.uml.Elements;
import net.astah.uml2.uml.NamedElements;
import net.astah.uml2.uml.provider.NamedElementItemProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;

public class NamespaceItemProvider
extends NamedElementItemProvider {
    public NamespaceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory, (ItemProviderAdapter)new org.eclipse.uml2.uml.edit.providers.NamespaceItemProvider(adapterFactory));
    }

    protected NamespaceItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter itemProviderAdapter) {
        super(adapterFactory, itemProviderAdapter);
    }

    @Override
    protected EStructuralFeature getLabelFeature() {
        return UMLPackage.eINSTANCE.getNamedElement_Name();
    }

    protected Command createAddCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Collection<?> collection, int n) {
        Namespace namespace = (Namespace)eObject;
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.append(super.createAddCommand(editingDomain, eObject, eStructuralFeature, collection, n));
        if (eStructuralFeature == UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT || eStructuralFeature == UMLPackage.Literals.CLASS__NESTED_CLASSIFIER || eStructuralFeature == UMLPackage.Literals.INTERFACE__NESTED_CLASSIFIER || eStructuralFeature == UMLPackage.Literals.CLASSIFIER__OWNED_USE_CASE) {
            HashSet<Dependency> hashSet = new HashSet<Dependency>();
            Iterables.filter(collection, NamedElement.class).forEach(namedElement -> hashSet.addAll(NamedElements.getClientDependenciesWithoutOwned((NamedElement)namedElement)));
            hashSet.removeIf(dependency -> namespace == dependency.getNearestPackage());
            if (!hashSet.isEmpty()) {
                compoundCommand.append(AddCommand.create((EditingDomain)editingDomain, (Object)namespace.getNearestPackage(), (Object)UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT, hashSet));
            }
            HashSet<Association> hashSet2 = new HashSet<Association>();
            Iterables.filter(collection, Element.class).forEach(element -> hashSet2.addAll(Associations.getSourceMemberedAssociations((Element)element)));
            hashSet2.removeIf(association -> namespace == association.getNearestPackage());
            if (!hashSet2.isEmpty()) {
                compoundCommand.append(AddCommand.create((EditingDomain)editingDomain, (Object)namespace.getNearestPackage(), (Object)UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT, hashSet2));
            }
        }
        compoundCommand.append(this.a(editingDomain, namespace, eStructuralFeature, collection));
        return compoundCommand;
    }

    private Command a(EditingDomain editingDomain, Namespace namespace, EStructuralFeature eStructuralFeature, Collection<?> collection) {
        String string = eStructuralFeature.getName();
        if (!(string.equals("ownedOperation") || string.equals("nestedClassifier") || string.equals("packagedElement"))) {
            return IdentityCommand.INSTANCE;
        }
        HashSet<UMLDiagram> hashSet = new HashSet<UMLDiagram>();
        for (Object object : collection) {
            hashSet.addAll(this.a(object));
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        for (UMLDiagram uMLDiagram : hashSet) {
            Element element;
            EObject eObject = uMLDiagram.getParent();
            Behavior behavior = this.a((Diagram)uMLDiagram);
            if (eObject == null || behavior == null) continue;
            if (eObject instanceof Operation) {
                BehavioredClassifier behavioredClassifier;
                element = ((Operation)eObject).getOwner();
                if (collection.contains(eObject)) {
                    if (namespace instanceof BehavioredClassifier) {
                        compoundCommand.append(this.a(editingDomain, (Element)namespace, UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR, behavior));
                        continue;
                    }
                    if (namespace instanceof DataType) {
                        compoundCommand.append((Command)UnexecutableCommand.INSTANCE);
                        continue;
                    }
                    behavioredClassifier = (BehavioredClassifier)Elements.getOwningElement((Element)namespace, BehavioredClassifier.class);
                    if (behavioredClassifier != null) {
                        compoundCommand.append(this.a(editingDomain, (Element)behavioredClassifier, UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR, behavior));
                        continue;
                    }
                    compoundCommand.append(this.a(editingDomain, (Element)namespace.getNearestPackage(), UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT, behavior));
                    continue;
                }
                if (element instanceof BehavioredClassifier || this.a(collection, behavior.getOwner()).booleanValue()) continue;
                behavioredClassifier = this.a((Element)namespace);
                if (behavioredClassifier != null) {
                    compoundCommand.append(this.a(editingDomain, (Element)behavioredClassifier, UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR, behavior));
                    continue;
                }
                compoundCommand.append(this.a(editingDomain, (Element)namespace.getNearestPackage(), UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT, behavior));
                continue;
            }
            if (eObject instanceof BehavioredClassifier || this.a(collection, behavior.getOwner()).booleanValue()) continue;
            element = this.a((Element)namespace);
            if (element != null) {
                compoundCommand.append(this.a(editingDomain, element, UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR, behavior));
                continue;
            }
            compoundCommand.append(this.a(editingDomain, (Element)namespace.getNearestPackage(), UMLPackage.Literals.PACKAGE__PACKAGED_ELEMENT, behavior));
        }
        return compoundCommand.isEmpty() ? IdentityCommand.INSTANCE : compoundCommand.unwrap();
    }

    private BehavioredClassifier a(Element element) {
        return element instanceof BehavioredClassifier ? (BehavioredClassifier)element : (BehavioredClassifier)Elements.getOwningElement((Element)element, BehavioredClassifier.class);
    }

    private Command a(EditingDomain editingDomain, Element element, EReference eReference, Behavior behavior) {
        if (behavior.getOwner() == element) {
            return IdentityCommand.INSTANCE;
        }
        Command command = AddCommand.create((EditingDomain)editingDomain, (Object)element, (Object)eReference, (Object)behavior);
        if (UMLPackage.Literals.STATE_MACHINE.isInstance((Object)behavior) && eReference == UMLPackage.Literals.BEHAVIORED_CLASSIFIER__OWNED_BEHAVIOR) {
            command = command.chain(SetCommand.create((EditingDomain)editingDomain, (Object)element, (Object)UMLPackage.Literals.BEHAVIORED_CLASSIFIER__CLASSIFIER_BEHAVIOR, (Object)behavior));
        }
        return command;
    }

    private Boolean a(Collection<?> collection, Element element) {
        if (collection.contains(element)) {
            return true;
        }
        for (Object obj : collection) {
            if (!(obj instanceof Element) || !((Element)obj).allOwnedElements().stream().anyMatch(element2 -> element2 == element)) continue;
            return true;
        }
        return false;
    }

    private Set<UMLDiagram> a(Object object) {
        if (!this.b(object).booleanValue()) {
            return Collections.emptySet();
        }
        NamedElement namedElement = (NamedElement)object;
        HashSet<UMLDiagram> hashSet = new HashSet<UMLDiagram>();
        hashSet.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)DiagramOperations.getOwningDiagrams((NamedElement)namedElement), UMLDiagram.class), uMLDiagram -> this.a((Diagram)uMLDiagram) != null)));
        for (NamedElement namedElement2 : Iterables.filter((Iterable)namedElement.getOwnedElements(), NamedElement.class)) {
            hashSet.addAll(this.a(namedElement2));
        }
        return hashSet;
    }

    private Boolean b(Object object) {
        if (object instanceof BehavioredClassifier && !(object instanceof Behavior)) {
            return true;
        }
        if (object instanceof Interface) {
            return true;
        }
        if (object instanceof Operation) {
            return true;
        }
        return false;
    }

    private Behavior a(Diagram diagram) {
        if (diagram instanceof UMLActivityDiagram) {
            return ((UMLActivityDiagram)diagram).getActivityGraph();
        }
        if (diagram instanceof UMLInteractionDiagram) {
            return ((UMLInteractionDiagram)diagram).getInteraction();
        }
        if (diagram instanceof UMLStateChartDiagram) {
            return ((UMLStateChartDiagram)diagram).getStateMachine();
        }
        return null;
    }
}

