/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml.provider;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.astah.emf.edit.provider.IChangeProcessor;
import net.astah.uml2.uml.provider.command.SynchronizeInstanceCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;

public class InstanceSynchronizer
implements IChangeProcessor {
    public static InstanceSynchronizer INSTANCE = new InstanceSynchronizer();

    public Command processChange(EditingDomain editingDomain, Collection<?> collection, List<Notification> list) {
        CompoundCommand compoundCommand = new CompoundCommand();
        Set set = Sets.newIdentityHashSet();
        for (Object obj : collection) {
            Association association;
            Classifier classifier;
            if (obj instanceof Classifier) {
                classifier = (Classifier)obj;
                this.processClassifier(editingDomain, compoundCommand, classifier, set);
                continue;
            }
            if (obj instanceof Property) {
                classifier = (Property)obj;
                association = classifier.getAssociation();
                this.processClassifier(editingDomain, compoundCommand, (Classifier)association, set);
                continue;
            }
            if (obj instanceof Generalization) {
                classifier = ((Generalization)obj).getGeneral();
                this.processClassifier(editingDomain, compoundCommand, classifier, set);
                continue;
            }
            if (obj instanceof InstanceSpecification) {
                classifier = (InstanceSpecification)obj;
                this.processInstanceSpecification(editingDomain, compoundCommand, (InstanceSpecification)classifier, set);
                this.processInstanceLinks(editingDomain, compoundCommand, (InstanceSpecification)classifier, set);
                continue;
            }
            if (obj instanceof Slot) {
                classifier = (Slot)obj;
                association = classifier.getOwningInstance();
                this.processInstanceSpecification(editingDomain, compoundCommand, (InstanceSpecification)association, set);
                continue;
            }
            if (!(obj instanceof InstanceValue) || !((association = (classifier = (InstanceValue)obj).getOwner()) instanceof Slot)) continue;
            InstanceSpecification instanceSpecification = ((Slot)association).getOwningInstance();
            this.processInstanceSpecification(editingDomain, compoundCommand, instanceSpecification, set);
        }
        return compoundCommand.isEmpty() ? null : compoundCommand.unwrap();
    }

    protected void processClassifier(EditingDomain editingDomain, CompoundCommand compoundCommand, Classifier classifier, Set<EObject> set) {
        if (classifier != null && set.add((EObject)classifier)) {
            for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)classifier)) {
                InstanceSpecification instanceSpecification;
                EObject eObject;
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                if (eStructuralFeature == UMLPackage.Literals.INSTANCE_SPECIFICATION__CLASSIFIER) {
                    eObject = setting.getEObject();
                    instanceSpecification = (InstanceSpecification)eObject;
                    this.processInstanceSpecification(editingDomain, compoundCommand, instanceSpecification, set);
                    continue;
                }
                if (eStructuralFeature != UMLPackage.Literals.GENERALIZATION__GENERAL || (instanceSpecification = ((Generalization)(eObject = setting.getEObject())).getSpecific()) == null) continue;
                this.processClassifier(editingDomain, compoundCommand, (Classifier)instanceSpecification, set);
            }
        }
    }

    protected void processInstanceSpecification(EditingDomain editingDomain, CompoundCommand compoundCommand, InstanceSpecification instanceSpecification, Set<EObject> set) {
        if (instanceSpecification != null && set.add((EObject)instanceSpecification)) {
            compoundCommand.appendIfCanExecute((Command)new SynchronizeInstanceCommand(editingDomain, instanceSpecification));
        }
    }

    protected void processInstanceLinks(EditingDomain editingDomain, CompoundCommand compoundCommand, InstanceSpecification instanceSpecification, Set<EObject> set) {
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)instanceSpecification)) {
            Element element;
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            if (eStructuralFeature != UMLPackage.Literals.INSTANCE_VALUE__INSTANCE || !((element = ((InstanceValue)setting.getEObject()).getOwner()) instanceof Slot)) continue;
            InstanceSpecification instanceSpecification2 = ((Slot)element).getOwningInstance();
            this.processInstanceSpecification(editingDomain, compoundCommand, instanceSpecification2, set);
        }
    }
}

