/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml.compare;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.astah.uml2.UML2Ecore;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.internal.AssociationChange;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.emf.compare.uml2.internal.ExtendChange;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLEdgeChangeCollector
extends UMLSwitch<Set<Diff>> {
    protected final Set<Diff> result = new HashSet<Diff>();
    protected final Comparison comparison;
    protected final Diff input;

    public UMLEdgeChangeCollector(@NonNull Comparison comparison, @NonNull Diff diff) {
        if (comparison == null) {
            throw new NullPointerException("comparison");
        }
        if (diff == null) {
            throw new NullPointerException("input");
        }
        this.comparison = comparison;
        this.input = diff;
    }

    public Set<Diff> caseActivityEdge(ActivityEdge activityEdge) {
        Match match = this.comparison.getMatch((EObject)activityEdge);
        if (match != null) {
            List<EReference> list = Arrays.asList(UMLPackage.Literals.ACTIVITY_EDGE__SOURCE, UMLPackage.Literals.ACTIVITY_EDGE__TARGET);
            EObject eObject = match.getLeft();
            EObject eObject2 = match.getRight();
            if (eObject instanceof ActivityEdge && eObject2 instanceof ActivityEdge) {
                this.addReferenceChanges(match, eObject, list);
                this.addInverseReferenceChanges(eObject, list);
                this.addReferenceChanges(match, eObject2, list);
                this.addInverseReferenceChanges(eObject2, list);
            }
        }
        return (Set)super.caseActivityEdge(activityEdge);
    }

    public Set<Diff> caseAssociation(Association association) {
        Match match = this.comparison.getMatch((EObject)association);
        if (match != null) {
            Iterables.addAll(this.result, this.a((Iterable<? extends Diff>)match.getDifferences(), AssociationChange.class));
        }
        return (Set)super.caseAssociation(association);
    }

    public Set<Diff> caseConnector(Connector connector) {
        Match match = this.comparison.getMatch((EObject)connector);
        if (match != null) {
            this.addConnectorEndRoleChanges(connector);
        }
        return (Set)super.caseConnector(connector);
    }

    protected void addConnectorEndRoleChanges(Connector connector) {
        for (ConnectorEnd connectorEnd : connector.getEnds()) {
            Match match = this.comparison.getMatch((EObject)connectorEnd);
            if (match == null) continue;
            this.addReferenceChanges(match, (EObject)connectorEnd, Arrays.asList(UMLPackage.Literals.CONNECTOR_END__ROLE, UMLPackage.Literals.CONNECTOR_END__PART_WITH_PORT));
        }
    }

    public Set<Diff> caseInstanceSpecification(InstanceSpecification instanceSpecification) {
        Match match = this.comparison.getMatch((EObject)instanceSpecification);
        if (match != null) {
            ReferenceChange referenceChange2;
            for (ReferenceChange referenceChange2 : this.a((Iterable<? extends Diff>)match.getDifferences())) {
                EReference eReference = referenceChange2.getReference();
                if (eReference != UMLPackage.Literals.INSTANCE_SPECIFICATION__SLOT || !(referenceChange2.getValue() instanceof Slot)) continue;
                this.result.add((Diff)referenceChange2);
            }
            EObject eObject = match.getLeft();
            if (eObject instanceof InstanceSpecification) {
                this.addSlotInstanceValueChanges((InstanceSpecification)eObject);
            }
            if ((referenceChange2 = match.getRight()) instanceof InstanceSpecification) {
                this.addSlotInstanceValueChanges((InstanceSpecification)referenceChange2);
            }
        }
        return (Set)super.caseInstanceSpecification(instanceSpecification);
    }

    protected void addSlotInstanceValueChanges(InstanceSpecification instanceSpecification) {
        for (Slot slot : instanceSpecification.getSlots()) {
            Match match = this.comparison.getMatch((EObject)slot);
            for (ReferenceChange referenceChange : this.a((Iterable<? extends Diff>)match.getDifferences())) {
                if (referenceChange.getReference() != UMLPackage.Literals.SLOT__VALUE || !(referenceChange.getValue() instanceof InstanceValue)) continue;
                this.result.add((Diff)referenceChange);
            }
        }
    }

    public Set<Diff> caseDirectedRelationship(DirectedRelationship directedRelationship) {
        Match match = this.comparison.getMatch((EObject)directedRelationship);
        if (match != null) {
            Iterables.addAll(this.result, this.a((Iterable<? extends Diff>)match.getDifferences(), DirectedRelationshipChange.class));
        }
        return (Set)super.caseDirectedRelationship(directedRelationship);
    }

    public Set<Diff> caseExtend(Extend extend) {
        Match match = this.comparison.getMatch((EObject)extend);
        if (match != null) {
            Iterables.addAll(this.result, this.a((Iterable<? extends Diff>)match.getDifferences(), ExtendChange.class));
        }
        return (Set)super.caseExtend(extend);
    }

    public Set<Diff> caseTransition(Transition transition) {
        Match match = this.comparison.getMatch((EObject)transition);
        if (match != null) {
            List<EReference> list = Arrays.asList(UMLPackage.Literals.TRANSITION__SOURCE, UMLPackage.Literals.TRANSITION__TARGET);
            this.addReferenceChanges(match, (EObject)transition, list);
            this.addInverseReferenceChanges((EObject)transition, list);
        }
        return (Set)super.caseTransition(transition);
    }

    public Set<Diff> defaultCase(EObject eObject) {
        return this.result.isEmpty() ? Collections.emptySet() : this.result;
    }

    protected void addReferenceChanges(Match match, EObject eObject, Collection<EReference> collection) {
        for (ReferenceChange referenceChange : this.a((Iterable<? extends Diff>)match.getDifferences())) {
            if (!collection.contains(referenceChange.getReference())) continue;
            this.result.add((Diff)referenceChange);
        }
    }

    protected void addInverseReferenceChanges(EObject eObject, Collection<EReference> collection) {
        for (ReferenceChange referenceChange : this.a((Iterable<? extends Diff>)this.comparison.getDifferences(eObject))) {
            EReference eReference = referenceChange.getReference().getEOpposite();
            if (eReference == null || referenceChange.getValue() != eObject || !collection.contains(eReference)) continue;
            this.result.add((Diff)referenceChange);
        }
    }

    protected Set<EReference> addAllRelatedReferences(EClass eClass, EReference eReference, Set<EReference> set) {
        EList eList;
        set.add(eReference);
        UML2Ecore.UMLProperty uMLProperty = UML2Ecore.getUMLProperty((EClass)eClass, (EStructuralFeature)eReference);
        if (uMLProperty != null && !(eList = uMLProperty.getAllSubsetFeatures()).isEmpty()) {
            Iterables.addAll(set, (Iterable)Iterables.filter((Iterable)eList, EReference.class));
        }
        return set;
    }

    private Iterable<ReferenceChange> a(Iterable<? extends Diff> iterable) {
        return this.a(iterable, ReferenceChange.class);
    }

    private <T extends Diff> Iterable<T> a(Iterable<? extends Diff> iterable, Class<T> clazz) {
        Iterable iterable2 = Iterables.filter(iterable, diff -> clazz.isInstance(diff) && diff.getSource() == this.input.getSource());
        return iterable2;
    }
}

