/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.astah.uml2.operations.MessagePresentations;
import net.astah.uml2.uml.Classifiers;
import net.astah.uml2.uml.InstanceSpecifications;
import net.astah.uml2.uml.Messages;
import net.astah.uml2.uml.TemplateParameters;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
class UMLExtraContentsSwitch
extends UMLSwitch<Set<EObject>>
implements Supplier<Set<EObject>> {
    protected final Set<EObject> contents = new HashSet<EObject>();
    protected final int depth;

    protected UMLExtraContentsSwitch(int n) {
        this.depth = n;
    }

    public Set<EObject> caseActivityEdge(ActivityEdge activityEdge) {
        this.contents.addAll((Collection<EObject>)activityEdge.eContents());
        UMLExtraContentsSwitch.a(this.contents, activityEdge.getSource());
        UMLExtraContentsSwitch.a(this.contents, activityEdge.getTarget());
        return (Set)super.caseActivityEdge(activityEdge);
    }

    public Set<EObject> caseActivityPartition(ActivityPartition activityPartition) {
        this.contents.addAll((Collection<EObject>)activityPartition.eContents());
        this.contents.addAll((Collection<EObject>)activityPartition.getNodes());
        return (Set)super.caseActivityPartition(activityPartition);
    }

    public Set<EObject> caseActivityParameterNode(ActivityParameterNode activityParameterNode) {
        this.contents.add((EObject)activityParameterNode.getParameter());
        return (Set)super.caseActivityParameterNode(activityParameterNode);
    }

    public Set<EObject> caseAssociation(Association association) {
        for (Property property : association.getMemberEnds()) {
            this.contents.add((EObject)property);
        }
        return (Set)super.caseAssociation(association);
    }

    public Set<EObject> caseProperty(Property property) {
        if (this.depth == 0) {
            UMLExtraContentsSwitch.a(this.contents, property.getAssociation());
        }
        return (Set)super.caseProperty(property);
    }

    public Set<EObject> caseCallBehaviorAction(CallBehaviorAction callBehaviorAction) {
        UMLExtraContentsSwitch.a(this.contents, callBehaviorAction.getBehavior());
        return (Set)super.caseCallBehaviorAction(callBehaviorAction);
    }

    public Set<EObject> caseClass(Class clazz) {
        if (this.depth == 0) {
            this.contents.addAll((Collection<EObject>)clazz.getOwnedOperations());
        }
        return (Set)super.caseClass(clazz);
    }

    public Set<EObject> caseNamespace(Namespace namespace) {
        this.contents.addAll((Collection<EObject>)namespace.getOwnedRules());
        return (Set)super.caseNamespace(namespace);
    }

    public Set<EObject> caseEnumeration(Enumeration enumeration) {
        if (this.depth == 0) {
            this.contents.addAll((Collection<EObject>)enumeration.getOwnedLiterals());
        }
        return (Set)super.caseEnumeration(enumeration);
    }

    public Set<EObject> caseDataType(DataType dataType) {
        if (this.depth == 0) {
            dataType.getOwnedAttributes().stream().filter(property -> property.getAssociation() == null).collect(Collectors.toCollection(this));
            this.contents.addAll((Collection<EObject>)dataType.getOwnedOperations());
        }
        return (Set)super.caseDataType(dataType);
    }

    public Set<EObject> caseClassifierTemplateParameter(ClassifierTemplateParameter classifierTemplateParameter) {
        ParameterableElement parameterableElement = classifierTemplateParameter.getDefault();
        Classifier classifier = TemplateParameters.getType((TemplateParameter)classifierTemplateParameter);
        UMLExtraContentsSwitch.a(this.contents, classifierTemplateParameter.getOwnedParameteredElement());
        UMLExtraContentsSwitch.a(this.contents, parameterableElement);
        UMLExtraContentsSwitch.a(this.contents, classifier);
        UMLExtraContentsSwitch.a(this.contents, this.a(parameterableElement, classifier));
        return (Set)super.caseClassifierTemplateParameter(classifierTemplateParameter);
    }

    private Relationship a(ParameterableElement parameterableElement, Classifier classifier) {
        if (parameterableElement instanceof Classifier && classifier != null) {
            for (Generalization generalization : ((Classifier)parameterableElement).getGeneralizations()) {
                if (generalization.getGeneral() != classifier) continue;
                return generalization;
            }
        }
        if (parameterableElement instanceof BehavioredClassifier && classifier instanceof Interface) {
            for (Generalization generalization : ((BehavioredClassifier)parameterableElement).getInterfaceRealizations()) {
                if (generalization.getContract() != classifier) continue;
                return generalization;
            }
        }
        return null;
    }

    public Set<EObject> caseInstanceSpecification(InstanceSpecification instanceSpecification) {
        this.contents.addAll((Collection<EObject>)instanceSpecification.eContents());
        this.contents.addAll((Collection<EObject>)instanceSpecification.getClassifiers());
        return (Set)super.caseInstanceSpecification(instanceSpecification);
    }

    public Set<EObject> caseSlot(Slot slot) {
        this.contents.addAll((Collection<EObject>)slot.eContents());
        StructuralFeature structuralFeature = slot.getDefiningFeature();
        UMLExtraContentsSwitch.a(this.contents, structuralFeature);
        if (structuralFeature instanceof Property) {
            UMLExtraContentsSwitch.a(this.contents, ((Property)structuralFeature).getAssociation());
            Class clazz = ((Property)structuralFeature).getClass_();
            InstanceSpecification instanceSpecification = (InstanceSpecification)slot.getOwner();
            Classifier classifier = InstanceSpecifications.getBase((InstanceSpecification)instanceSpecification);
            this.contents.addAll(Classifiers.getGeneralizationPaths((Classifier)classifier, (Classifier)clazz));
        }
        return (Set)super.caseSlot(slot);
    }

    public Set<EObject> caseCombinedFragment(CombinedFragment combinedFragment) {
        this.contents.addAll((Collection<EObject>)combinedFragment.eContents());
        return (Set)super.caseCombinedFragment(combinedFragment);
    }

    public Set<EObject> caseDependency(Dependency dependency) {
        this.contents.addAll((Collection<EObject>)dependency.getSuppliers());
        this.contents.addAll((Collection<EObject>)dependency.getClients());
        return (Set)super.caseDependency(dependency);
    }

    public Set<EObject> caseElement(Element element) {
        this.contents.addAll((Collection<EObject>)element.getStereotypeApplications());
        for (EAnnotation eAnnotation : element.getEAnnotations()) {
            this.contents.add((EObject)eAnnotation);
            eAnnotation.eAllContents().forEachRemaining(this.contents::add);
        }
        return (Set)super.caseElement(element);
    }

    public Set<EObject> caseFeature(Feature feature) {
        this.contents.addAll((Collection<EObject>)feature.eContents());
        return (Set)super.caseFeature(feature);
    }

    public Set<EObject> caseGeneralization(Generalization generalization) {
        UMLExtraContentsSwitch.a(this.contents, generalization.getGeneral());
        UMLExtraContentsSwitch.a(this.contents, generalization.getSpecific());
        return (Set)super.caseGeneralization(generalization);
    }

    public Set<EObject> caseInteraction(Interaction interaction) {
        if (this.depth == 0) {
            this.contents.addAll((Collection<EObject>)interaction.eContents());
        }
        return (Set)super.caseInteraction(interaction);
    }

    public Set<EObject> caseInteractionOperand(InteractionOperand interactionOperand) {
        this.contents.addAll((Collection<EObject>)interactionOperand.eContents());
        return (Set)super.caseInteractionOperand(interactionOperand);
    }

    public Set<EObject> caseInteractionUse(InteractionUse interactionUse) {
        UMLExtraContentsSwitch.a(this.contents, interactionUse.getRefersTo());
        return (Set)super.caseInteractionUse(interactionUse);
    }

    public Set<EObject> caseInterface(Interface interface_) {
        if (this.depth == 0) {
            interface_.getOwnedAttributes().stream().filter(property -> property.getAssociation() == null).collect(Collectors.toCollection(this));
            this.contents.addAll((Collection<EObject>)interface_.getOwnedOperations());
        }
        return (Set)super.caseInterface(interface_);
    }

    public Set<EObject> caseLifeline(Lifeline lifeline) {
        UMLExtraContentsSwitch.a(this.contents, lifeline.getRepresents());
        return (Set)super.caseLifeline(lifeline);
    }

    public Set<EObject> caseMessage(Message message) {
        UMLExtraContentsSwitch.a(this.contents, Messages.getOperation((Message)message));
        this.contents.addAll((Collection<EObject>)message.getArguments());
        this.contents.addAll((Collection<EObject>)MessagePresentations.getRelatedFragments((Message)message));
        EAnnotation eAnnotation = message.getEAnnotation("http://astah.net/model/1.0.0/Extension");
        if (eAnnotation != null) {
            this.contents.add((EObject)eAnnotation);
            this.contents.addAll((Collection<EObject>)eAnnotation.getContents());
        }
        return (Set)super.caseMessage(message);
    }

    public Set<EObject> caseObjectNode(ObjectNode objectNode) {
        this.contents.addAll((Collection<EObject>)objectNode.eContents());
        return (Set)super.caseObjectNode(objectNode);
    }

    public Set<EObject> caseRegion(Region region) {
        this.contents.addAll((Collection<EObject>)region.eContents());
        return (Set)super.caseRegion(region);
    }

    public Set<EObject> caseState(State state) {
        UMLExtraContentsSwitch.a(this.contents, state.getSubmachine());
        for (Transition transition : state.getIncomings()) {
            if (transition.getKind() != TransitionKind.INTERNAL_LITERAL) continue;
            UMLExtraContentsSwitch.a(this.contents, transition);
        }
        return (Set)super.caseState(state);
    }

    public Set<EObject> caseStateInvariant(StateInvariant stateInvariant) {
        this.contents.addAll((Collection<EObject>)stateInvariant.eContents());
        return (Set)super.caseStateInvariant(stateInvariant);
    }

    public Set<EObject> caseStateMachine(StateMachine stateMachine) {
        if (this.depth == 0) {
            this.contents.addAll((Collection<EObject>)stateMachine.eContents());
        }
        this.contents.addAll((Collection<EObject>)stateMachine.getRegions());
        return (Set)super.caseStateMachine(stateMachine);
    }

    public Set<EObject> caseStructuredClassifier(StructuredClassifier structuredClassifier) {
        if (this.depth == 0) {
            structuredClassifier.getOwnedAttributes().stream().filter(property -> property.getAssociation() == null).collect(Collectors.toCollection(this));
        }
        return (Set)super.caseStructuredClassifier(structuredClassifier);
    }

    public Set<EObject> caseTemplateableElement(TemplateableElement templateableElement) {
        if (this.depth == 0) {
            UMLExtraContentsSwitch.a(this.contents, templateableElement.getOwnedTemplateSignature());
        }
        return (Set)super.caseTemplateableElement(templateableElement);
    }

    public Set<EObject> caseTemplateSignature(TemplateSignature templateSignature) {
        this.contents.addAll((Collection<EObject>)templateSignature.getOwnedParameters());
        return (Set)super.caseTemplateSignature(templateSignature);
    }

    public Set<EObject> caseTransition(Transition transition) {
        this.contents.addAll((Collection<EObject>)transition.eContents());
        return (Set)super.caseTransition(transition);
    }

    public Set<EObject> caseTrigger(Trigger trigger) {
        this.contents.addAll((Collection<EObject>)trigger.eContents());
        UMLExtraContentsSwitch.a(this.contents, trigger.getEvent());
        return (Set)super.caseTrigger(trigger);
    }

    public Set<EObject> caseTypedElement(TypedElement typedElement) {
        UMLExtraContentsSwitch.a(this.contents, typedElement.getType());
        return (Set)super.caseTypedElement(typedElement);
    }

    public Set<EObject> caseConnector(Connector connector) {
        UMLExtraContentsSwitch.a(this.contents, connector.getType());
        return (Set)super.caseConnector(connector);
    }

    public Set<EObject> caseUseCase(UseCase useCase) {
        this.contents.addAll((Collection<EObject>)useCase.getExtensionPoints());
        return (Set)super.caseUseCase(useCase);
    }

    public Set<EObject> caseVertex(Vertex vertex) {
        this.contents.addAll((Collection<EObject>)vertex.eContents());
        return (Set)super.caseVertex(vertex);
    }

    public Set<EObject> caseConstraint(Constraint constraint) {
        this.contents.addAll((Collection<EObject>)constraint.eContents());
        return (Set)super.caseConstraint(constraint);
    }

    public Set<EObject> defaultCase(EObject eObject) {
        return this.get();
    }

    @Override
    public Set<EObject> get() {
        return this.contents;
    }

    static <E> boolean a(Collection<E> collection, E e) {
        return e != null && collection.add(e);
    }
}

