/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import net.astah.golf.widget.swing.ContentTableModel;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.TreeTableModel;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicClassMembers;

@Keep
@KeepPublicClassMembers
public class TreeTableModelAdapter
extends AbstractTableModel
implements ContentTableModel {
    private static final long serialVersionUID = -2329557380327434283L;
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree jTree) {
        this.tree = jTree;
        this.treeTableModel = treeTableModel;
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.treeTableModel.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public Object getRowAt(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        return treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.treeTableModel.getValueAt(this.getRowAt(n), n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.treeTableModel.isCellEditable(this.getRowAt(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.getRowAt(n), n2);
    }

    protected void delayedFireTableDataChanged() {
        SwingInvoker.runInEDT(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }
}

