/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.astah.jomt.jview.TreeTableModel;
import net.astah.jomt.jview.TreeTableModelAdapter;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class JTreeTable
extends JTable {
    private static final long serialVersionUID = 5569660645545058640L;
    protected TreeTableCellRenderer tree;
    private boolean isAutoAdjustRowHeight = true;

    public JTreeTable() {
        this((TreeTableModel)null);
    }

    public JTreeTable(TreeTableModel treeTableModel) {
        if (treeTableModel != null) {
            this.setTreeTableModel(treeTableModel);
        }
    }

    public TreeTableModel getTreeTableModel() {
        TableModel tableModel = super.getModel();
        if (tableModel instanceof TreeTableModelAdapter) {
            return ((TreeTableModelAdapter)tableModel).treeTableModel;
        }
        return null;
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(20);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (JTreeTable.this.tree != null) {
                    JTreeTable.this.tree.dispatchEvent(mouseEvent);
                }
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.editingColumn < 0 || this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int a() {
        return this.editingRow;
    }

    @Override
    public void sizeColumnsToFit(int n) {
        super.sizeColumnsToFit(n);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle rectangle = this.getCellRect(this.a(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.getColumnClass(n2) == TreeTableModel.class) {
            this.repaint(this.getCellRect(n, n2, false));
            Component component = this.a(this.getEditorComponent());
            if (component != null) {
                component.requestFocus();
            }
        }
        return bl;
    }

    private Component a(Component component) {
        if (component instanceof ItemSelectable || component instanceof JTextComponent) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int k = 0; k < n; ++k) {
                Component component2 = this.a(container.getComponent(k));
                if (component2 == null) continue;
                return component2;
            }
        }
        return null;
    }

    public boolean isAutoAdjustRowHeight() {
        return this.isAutoAdjustRowHeight;
    }

    public void setAutoAdjustRowHeight(boolean bl) {
        this.isAutoAdjustRowHeight = bl;
    }

    @Override
    public void doLayout() {
        if (this.isAutoAdjustRowHeight) {
            this.adjustRowHeight();
        }
        super.doLayout();
    }

    public void adjustRowHeight() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        for (int k = 0; k < this.getRowCount(); ++k) {
            n = Math.max(n, this.a(k));
        }
        if (n == this.getRowHeight()) {
            return;
        }
        this.setRowHeight(n);
    }

    private int a(int n) {
        int n2 = this.getRowHeight(n);
        for (int k = 0; k < this.getColumnCount(); ++k) {
            TableCellRenderer tableCellRenderer = this.a(n, k);
            Component component = this.prepareRenderer(tableCellRenderer, n, k);
            if (component == null) continue;
            double d2 = component.getPreferredSize().getHeight();
            n2 = Math.max(n2, (int)Math.ceil(d2));
        }
        if (n2 <= 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            n2 = fontMetrics.getHeight();
        }
        return n2;
    }

    private TableCellRenderer a(int n, int n2) {
        if (this.getColumnClass(n2) == TreeTableModel.class) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getDefaultRenderer(Object.class);
            }
            return tableCellRenderer;
        }
        return this.getCellRenderer(n, n2);
    }

    @Keep
    @KeepPublicProtectedClassMembers
    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -6780437423074171689L;
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int k = n; k <= n2; ++k) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(k) || (treePath = JTreeTable.this.tree.getPathForRow(k)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    class TreeTableCellEditor
    implements TableCellEditor {
        private final JPanel b = new JPanel(new BorderLayout());

        TreeTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TreePath treePath;
            TreeCellEditor treeCellEditor = JTreeTable.this.tree.getCellEditor();
            if (treeCellEditor != null && (treePath = JTreeTable.this.tree.getPathForRow(n)) != null) {
                boolean bl2;
                boolean bl3;
                Object object2 = treePath.getLastPathComponent();
                Component component = treeCellEditor.getTreeCellEditorComponent(JTreeTable.this.tree, object2, bl, bl3 = JTreeTable.this.tree.isExpanded(n), bl2 = JTreeTable.this.tree.getModel().isLeaf(object2), n);
                if (component.getParent() != this.b) {
                    this.b.removeAll();
                    this.b.add("Center", component);
                }
                Rectangle rectangle = JTreeTable.this.tree.getRowBounds(n);
                this.b.setBorder(new EmptyBorder(0, (int)rectangle.getX(), 0, 0));
                return this.b;
            }
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                for (int k = JTreeTable.this.getColumnCount() - 1; k >= 0; --k) {
                    if (JTreeTable.this.getColumnClass(k) != TreeTableModel.class) continue;
                    MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)k, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                    break;
                }
                return false;
            }
            return JTreeTable.this.tree.isEditable();
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            TreeCellEditor treeCellEditor = JTreeTable.this.tree.getCellEditor();
            return treeCellEditor == null || treeCellEditor.shouldSelectCell(eventObject);
        }

        @Override
        public boolean stopCellEditing() {
            TreeCellEditor treeCellEditor = JTreeTable.this.tree.getCellEditor();
            return treeCellEditor != null && treeCellEditor.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            TreeCellEditor treeCellEditor = JTreeTable.this.tree.getCellEditor();
            if (treeCellEditor != null) {
                treeCellEditor.cancelCellEditing();
            }
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            TreeCellEditor treeCellEditor = JTreeTable.this.tree.getCellEditor();
            if (treeCellEditor != null) {
                treeCellEditor.addCellEditorListener(cellEditorListener);
            }
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            TreeCellEditor treeCellEditor = JTreeTable.this.tree.getCellEditor();
            if (treeCellEditor != null) {
                treeCellEditor.removeCellEditorListener(cellEditorListener);
            }
        }
    }

    @Keep
    @KeepPublicProtectedClassMembers
    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private static final long serialVersionUID = 3265265838986123992L;
        protected int visibleRow;
        protected Border highlightBorder;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, graphics, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            if (bl) {
                color2 = jTable.getSelectionBackground();
                color = jTable.getSelectionForeground();
            } else {
                color2 = jTable.getBackground();
                color = jTable.getForeground();
            }
            this.highlightBorder = null;
            if (JTreeTable.this.a() == n && JTreeTable.this.getEditingColumn() == n2) {
                color2 = UIManager.getColor("Table.focusCellBackground");
                color = UIManager.getColor("Table.focusCellForeground");
            } else if (bl2) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
                if (JTreeTable.this.isCellEditable(n, n2)) {
                    color2 = UIManager.getColor("Table.focusCellBackground");
                    color = UIManager.getColor("Table.focusCellForeground");
                }
            }
            this.visibleRow = n;
            this.setBackground(color2);
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                if (bl) {
                    defaultTreeCellRenderer.setTextSelectionColor(color);
                    defaultTreeCellRenderer.setBackgroundSelectionColor(color2);
                } else {
                    defaultTreeCellRenderer.setTextNonSelectionColor(color);
                    defaultTreeCellRenderer.setBackgroundNonSelectionColor(color2);
                }
            }
            return this;
        }
    }
}

