/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jutil;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class SwingInvoker {
    static Queue<Runnable> a = new LinkedList<Runnable>();

    public static void runInEDT(Runnable runnable) {
        if (SwingInvoker.isOnEDT()) {
            runnable.run();
            return;
        }
        SwingInvoker.runLaterInEDT(runnable);
    }

    public static void runLaterInEDT(Runnable runnable) {
        if (a != null) {
            a.add(runnable);
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEDTAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (SwingInvoker.isOnEDT()) {
            runnable.run();
            return;
        }
        SwingUtilities.invokeAndWait(runnable);
    }

    public static <V> V runInEDTAndWait(Callable<V> callable) throws ExecutionException, InterruptedException {
        if (SwingInvoker.isOnEDT()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                throw new ExecutionException(exception.getMessage(), exception);
            }
        }
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        SwingUtilities.invokeLater(futureTask);
        return futureTask.get();
    }

    public static <T> T runInEDTAndWaitResult(RunnableWithResult<T> runnableWithResult) throws InvocationTargetException, InterruptedException {
        if (SwingInvoker.isOnEDT()) {
            runnableWithResult.run();
            return runnableWithResult.getResult();
        }
        SwingUtilities.invokeAndWait(runnableWithResult);
        return runnableWithResult.getResult();
    }

    public static boolean isOnEDT() {
        return SwingUtilities.isEventDispatchThread() || SwingInvoker.isHeadless();
    }

    public static boolean isHeadless() {
        return a != null;
    }

    public static void setHeadless(boolean bl) {
        if (SwingInvoker.isHeadless() != bl) {
            a = bl ? new LinkedList<Runnable>() : null;
        }
    }

    public static void flushQueue() {
        Runnable runnable;
        while (a != null && (runnable = a.poll()) != null) {
            runnable.run();
        }
    }

    public static abstract class RunnableWithResult<T>
    implements Runnable {
        private T a;

        @Override
        public final void run() {
            this.a = this.runWithResult();
        }

        public abstract T runWithResult();

        public T getResult() {
            return this.a;
        }
    }
}

