/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import lombok.NonNull;

public class TableHeaderCellRendererAdapter
implements TableCellRenderer {
    protected final DefaultTableCellRenderer cellRenderer;
    private int horizontalAlignment = 0;

    public TableHeaderCellRendererAdapter(@NonNull DefaultTableCellRenderer defaultTableCellRenderer) {
        if (defaultTableCellRenderer == null) {
            throw new NullPointerException("cellRenderer");
        }
        this.cellRenderer = defaultTableCellRenderer;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.cellRenderer.setHorizontalAlignment(this.horizontalAlignment);
        Component component = this.getDefaultRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component != null) {
            this.cellRenderer.setForeground(component.getForeground());
            this.cellRenderer.setBackground(component.getBackground());
        }
        Component component2 = this.cellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component != null && component.isFontSet()) {
            component2.setFont(component.getFont());
        }
        if (component instanceof JComponent && component2 instanceof JComponent) {
            ((JComponent)component2).setBorder(((JComponent)component).getBorder());
        }
        return component2;
    }

    protected Component getDefaultRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader;
        if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
            TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        return null;
    }
}

