/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Color;
import java.awt.Component;
import java.io.InputStream;
import javax.swing.ProgressMonitorInputStream;
import net.astah.golf.util.GolfProperties;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.view.swing.ColorChooserPeer;
import net.astah.golf.view.swing.FontChooserPeer;
import net.astah.golf.view.swing.SwingColorChooserPeer;
import net.astah.golf.view.swing.SwingFontChooserPeer;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CComponent;
import net.astah.golf.widget.GolfWidgetFactory;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.golf.widget.swing.SwingComponent;

public class SwingWidgetFactory
extends GolfWidgetFactory {
    private SwingWidgetFactory() {
    }

    public static GolfWidgetFactory instance() {
        if (instance == null) {
            instance = new SwingWidgetFactory();
        }
        return instance;
    }

    @Override
    public CColor createCColor(Color color) {
        return new SwingColor(color);
    }

    @Override
    public CColor createWhiteColor() {
        return new SwingColor(Color.WHITE);
    }

    @Override
    public CColor createBlackColor() {
        return new SwingColor(Color.BLACK);
    }

    @Override
    public CColor createBlueColor() {
        return new SwingColor(Color.BLUE);
    }

    @Override
    public CColor createRedColor() {
        return new SwingColor(Color.RED);
    }

    @Override
    public CColor createGreenColor() {
        return new SwingColor(Color.GREEN);
    }

    @Override
    public CColor createGrayColor() {
        return new SwingColor(Color.GRAY);
    }

    @Override
    public CColor createLightGrayColor() {
        return new SwingColor(Color.LIGHT_GRAY);
    }

    @Override
    public CColor createPinkColor() {
        return new SwingColor(Color.PINK);
    }

    @Override
    public CColor createCyanColor() {
        return new SwingColor(Color.CYAN);
    }

    @Override
    public CColor createMagentaColor() {
        return new SwingColor(Color.MAGENTA);
    }

    @Override
    public CColor createOrangeColor() {
        return new SwingColor(Color.ORANGE);
    }

    @Override
    public CColor createColor(CColor cColor, float f2, float f3) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return f3 == 0.0f ? this.createColor(0, 0, 0) : (f2 == 1.0f && f3 == 1.0f ? cColor : new SwingColor(new Color(Math.min(Math.round((float)cColor.getRed() * f2), 255), Math.min(Math.round((float)cColor.getGreen() * f2), 255), Math.min(Math.round((float)cColor.getBlue() * f2), 255), Math.round(255.0f * f3))));
    }

    @Override
    public ColorChooserPeer createColorChooser(ResourceBundleList resourceBundleList, GolfProperties golfProperties) {
        return new SwingColorChooserPeer(resourceBundleList, golfProperties);
    }

    @Override
    public InputStream createProgressMonitorInputStream(CComponent cComponent, String string, InputStream inputStream) {
        Component component = ((SwingComponent)cComponent).getComponent();
        if (component == null) {
            throw new IllegalStateException("component is null.");
        }
        return new ProgressMonitorInputStream(component, string, inputStream);
    }

    @Override
    public CColor createColor(int n, int n2, int n3) {
        return new SwingColor(new Color(n, n2, n3));
    }

    @Override
    public FontChooserPeer createFontChooser() {
        return new SwingFontChooserPeer();
    }
}

