/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.astah.golf.widget.CTreeTable;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ISelectionChangedListener;
import net.astah.golf.widget.IStructuredSelection;
import net.astah.golf.widget.ITreeSelection;
import net.astah.golf.widget.SelectionSupport;
import net.astah.golf.widget.StructuredSelection;
import net.astah.golf.widget.TreeSelection;
import net.astah.golf.widget.swing.NavigableTreeTableModel;
import net.astah.golf.widget.swing.SwingJComponent;
import net.astah.jomt.jview.JTreeTable;
import net.astah.jomt.jview.TreeTableModel;

public class SwingTreeTable
extends SwingJComponent
implements CTreeTable {
    private final SelectionSupport selectionSupport = new SelectionSupport(this, this::createSelection);

    public SwingTreeTable(JTreeTable jTreeTable) {
        super(jTreeTable);
        jTreeTable.getTree().getSelectionModel().addTreeSelectionListener(treeSelectionEvent -> this.selectionSupport.update());
    }

    @Override
    public TableCellEditor getCellEditor() {
        return ((JTreeTable)this.component).getCellEditor();
    }

    @Override
    public TreePath[] getSelectionPaths() {
        return ((JTreeTable)this.component).getTree().getSelectionPaths();
    }

    @Override
    public void setSelectionPaths(List<TreePath> list) {
        if (list == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[list.size()];
        for (int k = 0; k < list.size(); ++k) {
            treePathArray[k] = list.get(k);
        }
        ((JTreeTable)this.component).getTree().setSelectionPaths(treePathArray);
    }

    @Override
    public boolean isEditing() {
        return ((JTreeTable)this.component).isEditing();
    }

    @Override
    public void setEditable(boolean bl) {
        ((JTreeTable)this.component).getTree().setEditable(bl);
    }

    @Override
    public Object getPathForLocation(int n, int n2) {
        return ((JTreeTable)this.component).getTree().getPathForLocation(n, n2);
    }

    @Override
    public void clearSelection() {
        ((JTreeTable)this.component).clearSelection();
    }

    @Override
    public void repaint() {
        this.component.repaint();
    }

    @Override
    public void addSelectionPath(Object object) {
        ((JTreeTable)this.component).getTree().addSelectionPath((TreePath)object);
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Object getSelectionPath() {
        return ((JTreeTable)this.component).getTree().getSelectionPath();
    }

    @Override
    public int getClosestRowForLocation(int n, int n2) {
        return ((JTreeTable)this.component).getTree().getClosestRowForLocation(n, n2);
    }

    @Override
    public int getRowCount() {
        return ((JTreeTable)this.component).getRowCount();
    }

    @Override
    public void scrollRowToVisible(int n) {
        JTree jTree = ((JTreeTable)this.component).getTree();
        Rectangle rectangle = jTree.getPathBounds(jTree.getPathForRow(n));
        if (rectangle != null) {
            ((JTreeTable)this.component).scrollRectToVisible(rectangle);
        }
    }

    @Override
    public Object getSelectedUserObject() {
        TreePath treePath = ((JTreeTable)this.component).getTree().getSelectionPath();
        return this.getSelectedUserObject(treePath);
    }

    @Override
    public Object getSelectedUserObject(Object object) {
        return ((TreePath)object).getLastPathComponent();
    }

    @Override
    public String getModifyNameString(ChangeEvent changeEvent) {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)changeEvent.getSource();
        return defaultCellEditor.getCellEditorValue().toString();
    }

    @Override
    public void startEditingAtPath(TreePath treePath) {
        JTreeTable jTreeTable = (JTreeTable)this.component;
        int n = jTreeTable.getTree().getRowForPath(treePath);
        if (n >= 0) {
            int n2 = jTreeTable.getColumnCount();
            for (int k = 0; k < n2; ++k) {
                if (jTreeTable.getColumnClass(k) != TreeTableModel.class) continue;
                jTreeTable.editCellAt(n, k);
                break;
            }
        }
    }

    @Override
    public void updateUI() {
        ((JTable)this.component).updateUI();
    }

    @Override
    public int getEditingColumn() {
        return 0;
    }

    @Override
    public int getEditingRow() {
        return 0;
    }

    @Override
    public Object getCellEditor(int n, int n2) {
        return null;
    }

    @Override
    public ISelection getSelection() {
        return this.selectionSupport.getSelection();
    }

    @Override
    public void setSelection(ISelection iSelection) {
        JTreeTable jTreeTable = (JTreeTable)this.component;
        if (jTreeTable != null) {
            if (iSelection instanceof ITreeSelection) {
                TreePath[] treePathArray = ((ITreeSelection)iSelection).getPaths();
                jTreeTable.getTree().setSelectionPaths(treePathArray);
                if (treePathArray != null && treePathArray.length > 0) {
                    jTreeTable.getTree().scrollPathToVisible(treePathArray[0]);
                }
            } else if (iSelection instanceof IStructuredSelection) {
                TreePath[] treePathArray = SwingTreeTable.getTreePaths(jTreeTable, (IStructuredSelection)iSelection);
                jTreeTable.getTree().setSelectionPaths(treePathArray);
                if (treePathArray != null && treePathArray.length > 0) {
                    jTreeTable.getTree().scrollPathToVisible(treePathArray[0]);
                }
            } else {
                jTreeTable.clearSelection();
            }
        }
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionSupport.addSelectionChangedListener(iSelectionChangedListener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionSupport.removeSelectionChangedListener(iSelectionChangedListener);
    }

    protected ISelection createSelection() {
        TreePath[] treePathArray;
        JTreeTable jTreeTable = (JTreeTable)this.component;
        if (jTreeTable != null && (treePathArray = jTreeTable.getTree().getSelectionPaths()) != null) {
            return new TreeSelection(treePathArray);
        }
        return StructuredSelection.empty();
    }

    static TreePath[] getTreePaths(JTreeTable jTreeTable, IStructuredSelection iStructuredSelection) {
        TreeTableModel treeTableModel = (TreeTableModel)jTreeTable.getTree().getModel();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(iStructuredSelection.size());
        if (treeTableModel instanceof NavigableTreeTableModel) {
            NavigableTreeTableModel navigableTreeTableModel = (NavigableTreeTableModel)treeTableModel;
            for (Object object : iStructuredSelection) {
                TreePath treePath = navigableTreeTableModel.getPath(object);
                if (treePath == null) continue;
                arrayList.add(treePath);
            }
        }
        return arrayList.toArray(new TreePath[arrayList.size()]);
    }
}

