/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.astah.golf.widget.CTree;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ISelectionChangedListener;
import net.astah.golf.widget.IStructuredSelection;
import net.astah.golf.widget.ITreeSelection;
import net.astah.golf.widget.SelectionSupport;
import net.astah.golf.widget.StructuredSelection;
import net.astah.golf.widget.TreeSelection;
import net.astah.golf.widget.swing.NavigableTreeModel;
import net.astah.golf.widget.swing.SwingJComponent;

public class SwingTree
extends SwingJComponent
implements CTree {
    private final SelectionSupport selectionSupport = new SelectionSupport(this, this::createSelection);

    public SwingTree(JTree jTree) {
        super(jTree);
        jTree.getSelectionModel().addTreeSelectionListener(treeSelectionEvent -> this.selectionSupport.update());
    }

    @Override
    public void setComponent(Component component) {
        super.setComponent(component);
        this.selectionSupport.update();
    }

    @Override
    public TreeCellEditor getCellEditor() {
        return ((JTree)this.component).getCellEditor();
    }

    @Override
    public TreePath[] getSelectionPaths() {
        return ((JTree)this.component).getSelectionPaths();
    }

    @Override
    public void setSelectionPaths(List<TreePath> list) {
        if (list == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[list.size()];
        for (int k = 0; k < list.size(); ++k) {
            treePathArray[k] = list.get(k);
        }
        ((JTree)this.component).setSelectionPaths(treePathArray);
    }

    @Override
    public boolean isEditing() {
        return ((JTree)this.component).isEditing();
    }

    @Override
    public void setEditable(boolean bl) {
        ((JTree)this.component).setEditable(bl);
    }

    @Override
    public Object getPathForLocation(int n, int n2) {
        return ((JTree)this.component).getPathForLocation(n, n2);
    }

    @Override
    public void clearSelection() {
        ((JTree)this.component).clearSelection();
    }

    @Override
    public void repaint() {
        this.component.repaint();
    }

    @Override
    public void addSelectionPath(Object object) {
        ((JTree)this.component).addSelectionPath((TreePath)object);
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        return ((JTree)this.component).getCellRenderer();
    }

    @Override
    public Object getSelectionPath() {
        return ((JTree)this.component).getSelectionPath();
    }

    @Override
    public int getClosestRowForLocation(int n, int n2) {
        return ((JTree)this.component).getClosestRowForLocation(n, n2);
    }

    @Override
    public int getRowCount() {
        return ((JTree)this.component).getRowCount();
    }

    @Override
    public void scrollRowToVisible(int n) {
        ((JTree)this.component).scrollRowToVisible(n);
    }

    @Override
    public Object getSelectedUserObject() {
        TreePath treePath = ((JTree)this.component).getSelectionPath();
        return this.getSelectedUserObject(treePath);
    }

    @Override
    public Object getSelectedUserObject(Object object) {
        return ((TreePath)object).getLastPathComponent();
    }

    @Override
    public String getModifyNameString(ChangeEvent changeEvent) {
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)changeEvent.getSource();
        return defaultCellEditor.getCellEditorValue().toString();
    }

    @Override
    public void startEditingAtPath(TreePath treePath) {
        JTree jTree = (JTree)this.component;
        jTree.startEditingAtPath(treePath);
    }

    @Override
    public void updateUI() {
        ((JTree)this.component).updateUI();
    }

    @Override
    public ISelection getSelection() {
        return this.selectionSupport.getSelection();
    }

    @Override
    public void setSelection(ISelection iSelection) {
        JTree jTree = (JTree)this.component;
        if (jTree != null) {
            if (iSelection instanceof ITreeSelection) {
                TreePath[] treePathArray = ((ITreeSelection)iSelection).getPaths();
                jTree.setSelectionPaths(treePathArray);
                if (treePathArray != null && treePathArray.length > 0) {
                    jTree.scrollPathToVisible(treePathArray[0]);
                }
            } else if (iSelection instanceof IStructuredSelection) {
                TreePath[] treePathArray = SwingTree.getTreePaths(jTree, (IStructuredSelection)iSelection);
                jTree.setSelectionPaths(treePathArray);
                if (treePathArray != null && treePathArray.length > 0) {
                    jTree.scrollPathToVisible(treePathArray[0]);
                }
            } else {
                jTree.clearSelection();
            }
        }
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionSupport.addSelectionChangedListener(iSelectionChangedListener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionSupport.removeSelectionChangedListener(iSelectionChangedListener);
    }

    protected ISelection createSelection() {
        TreePath[] treePathArray;
        JTree jTree = (JTree)this.component;
        if (jTree != null && (treePathArray = jTree.getSelectionPaths()) != null) {
            return new TreeSelection(treePathArray);
        }
        return StructuredSelection.empty();
    }

    static TreePath[] getTreePaths(JTree jTree, IStructuredSelection iStructuredSelection) {
        TreeModel treeModel = jTree.getModel();
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(iStructuredSelection.size());
        if (treeModel instanceof NavigableTreeModel) {
            NavigableTreeModel navigableTreeModel = (NavigableTreeModel)treeModel;
            for (Object object : iStructuredSelection) {
                TreePath treePath = navigableTreeModel.getPath(object);
                if (treePath == null) continue;
                arrayList.add(treePath);
            }
        }
        return arrayList.toArray(new TreePath[arrayList.size()]);
    }
}

