/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.astah.golf.widget.CTable;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ISelectionChangedListener;
import net.astah.golf.widget.IStructuredSelection;
import net.astah.golf.widget.ListSelection;
import net.astah.golf.widget.SelectionSupport;
import net.astah.golf.widget.TableSelection;
import net.astah.golf.widget.swing.ContentTableModel;
import net.astah.golf.widget.swing.SwingJComponent;

public class SwingTable
extends SwingJComponent
implements CTable {
    private final SelectionSupport selectionSupport = new SelectionSupport(this, this::createSelection);
    private final ListSelectionListener selectionListener = listSelectionEvent -> {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.selectionSupport.update();
        }
    };

    public SwingTable(JTable jTable) {
        super(jTable);
        jTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        jTable.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionListener);
    }

    @Override
    public void setComponent(Component component) {
        super.setComponent(component);
        this.selectionSupport.update();
    }

    @Override
    public int getEditingColumn() {
        return ((JTable)this.component).getEditingColumn();
    }

    @Override
    public int getEditingRow() {
        return ((JTable)this.component).getEditingRow();
    }

    @Override
    public Object getCellEditor(int n, int n2) {
        return ((JTable)this.component).getCellEditor(n, n2);
    }

    @Override
    public ISelection getSelection() {
        return this.selectionSupport.getSelection();
    }

    @Override
    public void setSelection(ISelection iSelection) {
        TableModel tableModel;
        JTable jTable = (JTable)this.component;
        if (jTable != null && iSelection instanceof IStructuredSelection && (tableModel = jTable.getModel()) instanceof ContentTableModel) {
            this.applySelection(jTable, (ContentTableModel)tableModel, (IStructuredSelection)iSelection);
        }
        jTable.getSelectionModel().clearSelection();
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionSupport.addSelectionChangedListener(iSelectionChangedListener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionSupport.removeSelectionChangedListener(iSelectionChangedListener);
    }

    protected ISelection createSelection() {
        JTable jTable = (JTable)this.component;
        TableModel tableModel = jTable.getModel();
        if (!(tableModel instanceof ContentTableModel)) {
            return TableSelection.empty();
        }
        int[] nArray = jTable.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            List<Object> list = this.getRows(jTable, (ContentTableModel)tableModel, nArray);
            int[] nArray2 = jTable.getSelectedColumns();
            ListSelection listSelection = new ListSelection(nArray, list);
            ListSelection listSelection2 = new ListSelection(nArray2);
            return new TableSelection(list, (IListSelection)listSelection, (IListSelection)listSelection2);
        }
        return TableSelection.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applySelection(JTable jTable, ContentTableModel contentTableModel, IStructuredSelection iStructuredSelection) {
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        try {
            listSelectionModel.clearSelection();
            for (Object object : iStructuredSelection) {
                int n;
                int n2 = contentTableModel.getIndexOfRow(object);
                if (n2 < 0 || (n = jTable.convertRowIndexToView(n2)) < 0) continue;
                listSelectionModel.addSelectionInterval(n, n);
            }
        }
        finally {
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    private List<Object> getRows(JTable jTable, ContentTableModel contentTableModel, int[] nArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length);
        for (int n : nArray) {
            int n2 = jTable.convertRowIndexToModel(n);
            if (n2 >= 0) {
                arrayList.add(contentTableModel.getRowAt(n2));
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    @Override
    public int getRowCount() {
        JTable jTable = (JTable)this.getComponent();
        return jTable.getRowCount();
    }
}

