/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import com.google.common.io.ByteStreams;
import java.awt.Image;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.astah.common.collect.LRUCacheMap;
import net.astah.golf.widget.swing.ScaledImageIcon;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingIconRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SwingIconRegistry.class);
    private static URIConverter uriConverter = new ExtensibleURIConverterImpl();
    private static final List<Loader> DEFAULT_LOADERS;
    public static final double ICON_NORMAL_SCALE = 1.0;
    public static final double ICON_NORMAL_HEIGHT = 16.0;
    private static double defaultScale;
    public static final SwingIconRegistry INSTANCE;
    protected final List<Loader> loaders = new CopyOnWriteArrayList<Loader>(DEFAULT_LOADERS);
    protected final Map<Object, Icon> iconCache;

    static void initializeEcore() {
        EcorePlugin.ExtensionProcessor.process((ClassLoader)TransactionalEditingDomainImpl.FactoryImpl.class.getClassLoader());
    }

    public SwingIconRegistry() {
        this(1024);
    }

    public SwingIconRegistry(int n) {
        this.iconCache = Collections.synchronizedMap(new LRUCacheMap(n));
    }

    public static double getDefaultScale() {
        return defaultScale;
    }

    public static double scaleValue(double d2) {
        return d2 * defaultScale;
    }

    public static int scaleValue(int n) {
        return (int)Math.ceil((double)n * defaultScale);
    }

    public static void setDefaultScale(double d2) {
        defaultScale = d2;
    }

    public static <T extends Modifier> T modifierOf(Set<? extends Modifier> set, Class<T> clazz) {
        for (Modifier modifier : set) {
            if (!clazz.isInstance(modifier)) continue;
            return (T)((Modifier)clazz.cast(modifier));
        }
        return null;
    }

    public boolean addLoader(Loader loader) {
        return this.loaders.add(loader);
    }

    public boolean removeLoader(Loader loader) {
        return this.loaders.remove(loader);
    }

    public Icon getIcon(Object object) {
        return this.getIcon(object, Collections.emptySet());
    }

    public Icon getIcon(Object object, Set<Modifier> set) {
        List<Object> list = Arrays.asList(object, set);
        Icon icon = this.iconCache.get(list);
        if (icon != null) {
            return icon;
        }
        try {
            Icon icon2 = this.loadIcon(object, set);
            if (icon2 == null) {
                return null;
            }
            Icon icon3 = this.iconCache.putIfAbsent(list, icon2);
            return icon3 != null ? icon3 : icon2;
        }
        catch (IOException iOException) {
            LOG.error("Failed to load icon: {}", object);
            return null;
        }
    }

    protected Icon loadIcon(Object object, Set<Modifier> set) throws IOException {
        for (Loader loader : this.loaders) {
            Icon icon = loader.load(object, set);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    private static boolean isPlainScale(double d2) {
        return d2 == 1.0;
    }

    static {
        try {
            SwingIconRegistry.initializeEcore();
        }
        catch (Exception exception) {
            LOG.error("UIFactory: failed to initialize ecore.", (Throwable)exception);
            throw exception;
        }
        DEFAULT_LOADERS = Collections.singletonList((object, set) -> {
            Icon icon;
            if (object instanceof Image) {
                Image image = (Image)object;
                double d2 = Scale.getValue(set);
                if (SwingIconRegistry.isPlainScale(d2)) {
                    return new ImageIcon(image);
                }
                return new ScaledImageIcon(image, d2);
            }
            if (object instanceof Icon) {
                icon = (Icon)object;
            } else if (object instanceof URL) {
                icon = new ImageIcon((URL)object);
            } else if (object instanceof URI) {
                Object object2;
                InputStream inputStream;
                try {
                    inputStream = uriConverter.createInputStream((URI)object);
                    object2 = null;
                    try {
                        ByteStreams.toByteArray((InputStream)inputStream);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (inputStream != null) {
                            if (object2 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object2).addSuppressed(throwable);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOG.debug("Icon image '{}' is not found.", object);
                    return null;
                }
                catch (IOException iOException) {
                    LOG.warn("An exception has occurred while fetching icon image.", (Throwable)iOException);
                    return null;
                }
                inputStream = uriConverter.normalize((URI)object);
                object2 = inputStream.toString();
                URL uRL = new URL((String)object2);
                icon = new ImageIcon(uRL);
            } else {
                return null;
            }
            double d3 = Scale.getValue(set);
            if (SwingIconRegistry.isPlainScale(d3)) {
                return icon;
            }
            return new ScaledImageIcon(icon, d3);
        });
        defaultScale = 1.0;
        INSTANCE = new SwingIconRegistry();
    }

    public static class Scale
    extends Number
    implements Modifier {
        private static final long serialVersionUID = 1L;
        private final double value;

        public Scale() {
            this.value = defaultScale;
        }

        public Scale(double d2) {
            this.value = d2;
        }

        public static double getValue(Set<Modifier> set) {
            Scale scale = SwingIconRegistry.modifierOf(set, Scale.class);
            return scale != null ? scale.getValue() : SwingIconRegistry.getDefaultScale();
        }

        public double getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ Double.hashCode(this.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Scale)) {
                return false;
            }
            Scale scale = (Scale)object;
            return Double.compare(this.value, scale.value) == 0;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public float floatValue() {
            return (float)this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }
    }

    public static interface Modifier
    extends Serializable {
    }

    public static interface Loader {
        public Icon load(Object var1, Set<Modifier> var2) throws IOException;
    }
}

