/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import net.astah.golf.draw.OnlySelectedDrawable;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CGraphics2D;
import net.astah.golf.widget.swing.SwingGraphics;

public class SwingGraphics2D
extends SwingGraphics
implements CGraphics2D {
    public SwingGraphics2D(Graphics2D graphics2D) {
        super(graphics2D);
    }

    public Graphics2D getGraphics2D() {
        return (Graphics2D)this.getComponent();
    }

    @Override
    public AffineTransform getTransform() {
        return this.getGraphics2D().getTransform();
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.getGraphics2D().setTransform(affineTransform);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.getGraphics2D().setRenderingHint(key, object);
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        if (preScale > 0.0) {
            this.getGraphics2D().setStroke(this.getScaledStroke(basicStroke));
        } else {
            this.getGraphics2D().setStroke(basicStroke);
        }
    }

    private BasicStroke getScaledStroke(BasicStroke basicStroke) {
        float f2;
        float[] fArray;
        float f3 = (float)((double)basicStroke.getLineWidth() * preScale);
        float[] fArray2 = fArray = basicStroke.getDashArray();
        float f4 = f2 = basicStroke.getDashPhase();
        if (fArray != null) {
            fArray2 = new float[fArray.length];
            for (int k = 0; k < fArray.length; ++k) {
                fArray2[k] = (float)((double)fArray[k] * preScale);
            }
            f4 = (float)((double)f2 * preScale);
        }
        return new BasicStroke(f3, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), fArray2, f4);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.getGraphics2D().getRenderingHint(key);
    }

    @Override
    public void fill(Shape shape) {
        if (preTransform != null) {
            Shape shape2 = preTransform.createTransformedShape(shape);
            this.getGraphics2D().fill(shape2);
        } else {
            this.getGraphics2D().fill(shape);
        }
    }

    @Override
    public void draw(Shape shape) {
        if (preTransform != null) {
            Shape shape2 = preTransform.createTransformedShape(shape);
            this.getGraphics2D().draw(shape2);
        } else {
            this.getGraphics2D().draw(shape);
        }
    }

    @Override
    public void translate(int n, int n2) {
        this.getGraphics2D().translate(n, n2);
    }

    @Override
    public void scale(double d2, double d3) {
        this.getGraphics2D().scale(d2, d3);
    }

    @Override
    public void translate(double d2, double d3) {
        this.getGraphics2D().translate(d2, d3);
    }

    @Override
    public void drawString(String string, float f2, float f3) {
        if (preTransform != null) {
            this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = this.getGraphics2D().getFont();
            FontRenderContext fontRenderContext = this.getGraphics2D().getFontRenderContext();
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
            Shape shape = glyphVector.getOutline(f2, f3);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(preTransform.getScaleX(), preTransform.getScaleY());
            this.getGraphics2D().fill(affineTransform.createTransformedShape(shape));
        } else if (printing && GolfUtilities.isWindowsOS()) {
            this.drawStringByChars(string, f2, f3);
        } else {
            this.getGraphics2D().drawString(string, f2, f3);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (preTransform != null) {
            this.getGraphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = this.getGraphics2D().getFont();
            FontRenderContext fontRenderContext = this.getGraphics2D().getFontRenderContext();
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, attributedCharacterIterator);
            Shape shape = glyphVector.getOutline(f2, f3);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(preTransform.getScaleX(), preTransform.getScaleY());
            this.getGraphics2D().fill(affineTransform.createTransformedShape(shape));
        } else {
            this.getGraphics2D().drawString(attributedCharacterIterator, f2, f3);
        }
    }

    public void drawStringByChars(String string, float f2, float f3) {
        this.drawString(this.getGraphics2D(), string, f2, f3);
    }

    public void drawString(Graphics graphics, String string, float f2, float f3) {
        if (string.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        AffineTransform affineTransform = graphics2D.getTransform();
        Point2D.Float float_ = new Point2D.Float(f2, f3);
        Point2D.Float float_2 = new Point2D.Float();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        GlyphVector glyphVector = graphics.getFont().createGlyphVector(fontRenderContext, cArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            Font font = graphics.getFont();
            n2 = n3;
            n4 = glyphVector.getGlyphCode(n2) >>> 24;
            while (n3 < n && glyphVector.getGlyphCode(n3) >>> 24 == n4) {
                ++n3;
            }
            String string2 = new String(cArray, n2, n3 - n2);
            graphics.drawString(string2, (int)f2, (int)f3);
            f2 = (float)((double)f2 + GolfUtilities.computeStringWidth(font, string2));
            Rectangle2D rectangle2D = font.getStringBounds(string2, fontRenderContext);
            float f4 = (float)rectangle2D.getWidth();
            float_.x += f4;
            affineTransform.transform(float_, float_2);
        }
    }

    @Override
    public void rotate(double d2, double d3, double d4) {
        this.getGraphics2D().rotate(d2, d3, d4);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.getGraphics2D().getFontRenderContext();
    }

    @Override
    public boolean isOnlySelectedDrawable() {
        return this.getComponent() instanceof OnlySelectedDrawable;
    }

    @Override
    public boolean isSpecialCase() {
        return this.getComponent() instanceof OnlySelectedDrawable && ((OnlySelectedDrawable)((Object)this.getComponent())).isSpecialCase();
    }

    @Override
    public void setPaint(GradientPaint gradientPaint) {
        if (preTransform != null) {
            Point2D point2D = preTransform.transform(gradientPaint.getPoint1(), null);
            Point2D point2D2 = preTransform.transform(gradientPaint.getPoint2(), null);
            GradientPaint gradientPaint2 = new GradientPaint(point2D, gradientPaint.getColor1(), point2D2, gradientPaint.getColor2(), gradientPaint.isCyclic());
            this.getGraphics2D().setPaint(gradientPaint2);
        } else {
            this.getGraphics2D().setPaint(gradientPaint);
        }
    }
}

