/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import net.astah.golf.widget.CCanvas;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CGraphics;
import net.astah.golf.widget.CGraphics2D;
import net.astah.golf.widget.CImage;
import net.astah.golf.widget.swing.SwingCanvas;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.golf.widget.swing.SwingGraphics2D;
import net.astah.golf.widget.swing.SwingImage;

public class SwingGraphics
implements CGraphics {
    private static final String LEFT_QUOTATION = "\u3002\u30e7";
    private static final String RIGHT_QUOTATION = "\u3002\u30c3";
    private static final String LEFT_DOUBLE_QUOTATION = "\u3002\u30fc";
    private static final String RIGHT_DOUBLE_QUOTATION = "\u3002\u30a2";
    private static final String POINTS_JP = "\u2026";
    private static final String AST_JP = "\u203b";
    private static final String LEFT_DOUBLE_QUOTATION_JP = "\u201c";
    private static final String RIGHT_DOUBLE_QUOTATION_JP = "\u201d";
    private static final String LEFT_SINGLE_QUOTATION_JP = "\u2018";
    private static final String RIGHT_SINGLE_QUOTATION_JP = "\u2019";
    public static double preScale = -1.0;
    protected static AffineTransform preTransform = null;
    protected static boolean printing;
    private Graphics component;

    public SwingGraphics(Graphics graphics) {
        this.component = graphics;
    }

    public static void setPreScale(double d2) {
        if (preTransform == null) {
            preTransform = new AffineTransform();
        }
        preScale = d2;
        preTransform.setToIdentity();
        preTransform.scale(d2, d2);
    }

    public static void resetPreScale() {
        preTransform = null;
        preScale = -1.0;
    }

    public Graphics getComponent() {
        return this.component;
    }

    public void setComponent(Graphics graphics) {
        this.component = graphics;
    }

    @Override
    public void setColor(CColor cColor) {
        this.component.setColor(((SwingColor)cColor).getComponent());
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.component.fillRect(n, n2, n3, n4);
    }

    @Override
    public void drawImage(CImage cImage, int n, int n2, CCanvas cCanvas) {
        if (preTransform != null) {
            Point2D.Double double_ = new Point2D.Double();
            preTransform.transform(new Point2D.Double(n, n2), double_);
            this.component.drawImage(((SwingImage)cImage).getComponent(), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), ((SwingCanvas)cCanvas).getComponent());
        } else {
            this.component.drawImage(((SwingImage)cImage).getComponent(), n, n2, ((SwingCanvas)cCanvas).getComponent());
        }
    }

    @Override
    public Rectangle2D getStringBounds(String string) {
        return this.component.getFontMetrics().getStringBounds(string, this.component);
    }

    @Override
    public Rectangle2D getStringBounds(String string, Font font) {
        string = this.removeSpecChar(string);
        return this.component.getFontMetrics(font).getStringBounds(string, this.component);
    }

    @Override
    public void setFont(Font font) {
        this.component.setFont(font);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.component.drawRect(n, n2, n3, n4);
    }

    @Override
    public Font getFont() {
        return this.component.getFont();
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.component.drawString(string, n, n2);
    }

    @Override
    public void drawImage(CImage cImage, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (preTransform != null) {
            Point2D.Double double_ = new Point2D.Double();
            preTransform.transform(new Point2D.Double(n, n2), double_);
            double d2 = preTransform.getScaleX();
            double d3 = preTransform.getScaleY();
            this.component.drawImage(((SwingImage)cImage).getComponent(), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), (int)((double)n3 * d2), (int)((double)n4 * d3), imageObserver);
        } else {
            this.component.drawImage(((SwingImage)cImage).getComponent(), n, n2, n3, n4, imageObserver);
        }
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.component.setClip(n, n2, n3, n4);
    }

    @Override
    public CGraphics2D getGraphics() {
        return new SwingGraphics2D((Graphics2D)this.component);
    }

    @Override
    public void setXORMode(CColor cColor) {
        this.component.setXORMode(cColor.transferToAWTColor());
    }

    @Override
    public void setPaintMode() {
        this.component.setPaintMode();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean hasSameComponent(CGraphics cGraphics) {
        return this.component == ((SwingGraphics)cGraphics).component;
    }

    @Override
    public void setPrinting(boolean bl) {
        printing = bl;
    }

    private String removeSpecChar(String string) {
        string = string.replaceAll(LEFT_DOUBLE_QUOTATION, "");
        string = string.replaceAll(RIGHT_DOUBLE_QUOTATION, "");
        string = string.replaceAll(LEFT_QUOTATION, "");
        string = string.replaceAll(RIGHT_QUOTATION, "");
        string = string.replaceAll(POINTS_JP, "");
        string = string.replaceAll(AST_JP, "");
        string = string.replaceAll(LEFT_DOUBLE_QUOTATION_JP, "");
        string = string.replaceAll(RIGHT_DOUBLE_QUOTATION_JP, "");
        string = string.replaceAll(LEFT_SINGLE_QUOTATION_JP, "");
        string = string.replaceAll(RIGHT_SINGLE_QUOTATION_JP, "");
        return string;
    }
}

