/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.swing;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.IStructuredSelection;

public class Selections {
    public static boolean isEmpty(ISelection iSelection) {
        return !(iSelection instanceof IStructuredSelection) || iSelection.isEmpty();
    }

    public static boolean contains(ISelection iSelection, Object object) {
        if (iSelection instanceof IStructuredSelection) {
            return Iterables.contains((Iterable)((IStructuredSelection)iSelection), (Object)object);
        }
        return false;
    }

    public static int size(ISelection iSelection) {
        if (Selections.isEmpty(iSelection)) {
            return 0;
        }
        return ((IStructuredSelection)iSelection).size();
    }

    public static Object getFirstElement(ISelection iSelection) {
        if (Selections.isEmpty(iSelection)) {
            return null;
        }
        return ((IStructuredSelection)iSelection).getFirstElement();
    }

    public static <E> E getFirstElement(ISelection iSelection, Class<E> clazz) {
        if (iSelection instanceof IStructuredSelection) {
            for (Object object : (IStructuredSelection)iSelection) {
                if (!clazz.isInstance(object)) continue;
                return clazz.cast(object);
            }
        }
        return null;
    }

    public static <E> Iterator<E> iterator(ISelection iSelection) {
        if (Selections.isEmpty(iSelection)) {
            return Collections.emptyIterator();
        }
        return ((IStructuredSelection)iSelection).iterator();
    }

    public static <E> Iterator<E> iterator(ISelection iSelection, Class<E> clazz) {
        if (Selections.isEmpty(iSelection)) {
            return Collections.emptyIterator();
        }
        return Iterators.filter(((IStructuredSelection)iSelection).iterator(), clazz);
    }

    public static <E> Iterable<E> iterable(ISelection iSelection) {
        if (Selections.isEmpty(iSelection)) {
            return Collections.emptySet();
        }
        return (Iterable)((Object)iSelection);
    }

    public static <E> Iterable<E> iterable(ISelection iSelection, Class<E> clazz) {
        if (Selections.isEmpty(iSelection)) {
            return Collections.emptySet();
        }
        return Iterables.filter((Iterable)((IStructuredSelection)iSelection), clazz);
    }

    public static <T> Stream<T> stream(ISelection iSelection) {
        if (Selections.isEmpty(iSelection)) {
            return Stream.empty();
        }
        return ((IStructuredSelection)iSelection).stream();
    }

    public static <T> Stream<T> stream(ISelection iSelection, Class<T> clazz) {
        if (Selections.isEmpty(iSelection)) {
            return Stream.empty();
        }
        Stream<Object> stream = ((IStructuredSelection)iSelection).stream();
        return stream.filter(clazz::isInstance);
    }
}

